package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubeControllerManagerSpecBuilder extends KubeControllerManagerSpecFluentImpl<KubeControllerManagerSpecBuilder> implements VisitableBuilder<KubeControllerManagerSpec,KubeControllerManagerSpecBuilder>{
  public KubeControllerManagerSpecBuilder() {
    this(false);
  }
  public KubeControllerManagerSpecBuilder(Boolean validationEnabled) {
    this(new KubeControllerManagerSpec(), validationEnabled);
  }
  public KubeControllerManagerSpecBuilder(KubeControllerManagerSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public KubeControllerManagerSpecBuilder(KubeControllerManagerSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubeControllerManagerSpec(), validationEnabled);
  }
  public KubeControllerManagerSpecBuilder(KubeControllerManagerSpecFluent<?> fluent,KubeControllerManagerSpec instance) {
    this(fluent, instance, false);
  }
  public KubeControllerManagerSpecBuilder(KubeControllerManagerSpecFluent<?> fluent,KubeControllerManagerSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
    fluent.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
    fluent.withLogLevel(instance.getLogLevel()); 
    fluent.withManagementState(instance.getManagementState()); 
    fluent.withObservedConfig(instance.getObservedConfig()); 
    fluent.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    fluent.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
    fluent.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    fluent.withUseMoreSecureServiceCA(instance.getUseMoreSecureServiceCA()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubeControllerManagerSpecBuilder(KubeControllerManagerSpec instance) {
    this(instance,false);
  }
  public KubeControllerManagerSpecBuilder(KubeControllerManagerSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFailedRevisionLimit(instance.getFailedRevisionLimit()); 
    this.withForceRedeploymentReason(instance.getForceRedeploymentReason()); 
    this.withLogLevel(instance.getLogLevel()); 
    this.withManagementState(instance.getManagementState()); 
    this.withObservedConfig(instance.getObservedConfig()); 
    this.withOperatorLogLevel(instance.getOperatorLogLevel()); 
    this.withSucceededRevisionLimit(instance.getSucceededRevisionLimit()); 
    this.withUnsupportedConfigOverrides(instance.getUnsupportedConfigOverrides()); 
    this.withUseMoreSecureServiceCA(instance.getUseMoreSecureServiceCA()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  KubeControllerManagerSpecFluent<?> fluent;
  Boolean validationEnabled;
  public KubeControllerManagerSpec build() {
    KubeControllerManagerSpec buildable = new KubeControllerManagerSpec(fluent.getFailedRevisionLimit(),fluent.getForceRedeploymentReason(),fluent.getLogLevel(),fluent.getManagementState(),fluent.getObservedConfig(),fluent.getOperatorLogLevel(),fluent.getSucceededRevisionLimit(),fluent.getUnsupportedConfigOverrides(),fluent.getUseMoreSecureServiceCA());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}