/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.AlertRelabelConfigSpec;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class AlertRelabelConfigSpecFluent<A extends AlertRelabelConfigSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RelabelConfigBuilder> configs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AlertRelabelConfigSpecFluent() {
    }

    public AlertRelabelConfigSpecFluent(AlertRelabelConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlertRelabelConfigSpec instance) {
        AlertRelabelConfigSpec alertRelabelConfigSpec = instance = instance != null ? instance : new AlertRelabelConfigSpec();
        if (instance != null) {
            this.withConfigs(instance.getConfigs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConfigs(int index, RelabelConfig item) {
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.configs.size()) {
            this._visitables.get((Object)"configs").add(builder);
            this.configs.add(builder);
        } else {
            this._visitables.get((Object)"configs").add(index, builder);
            this.configs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConfigs(int index, RelabelConfig item) {
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.configs.size()) {
            this._visitables.get((Object)"configs").add(builder);
            this.configs.add(builder);
        } else {
            this._visitables.get((Object)"configs").set(index, builder);
            this.configs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConfigs(RelabelConfig ... items) {
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"configs").add(builder);
            this.configs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConfigs(Collection<RelabelConfig> items) {
        if (this.configs == null) {
            this.configs = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"configs").add(builder);
            this.configs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConfigs(RelabelConfig ... items) {
        if (this.configs == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"configs").remove((Object)builder);
            this.configs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfigs(Collection<RelabelConfig> items) {
        if (this.configs == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"configs").remove((Object)builder);
            this.configs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConfigs(Predicate<RelabelConfigBuilder> predicate) {
        if (this.configs == null) {
            return (A)((Object)this);
        }
        Iterator<RelabelConfigBuilder> each = this.configs.iterator();
        List visitables = this._visitables.get((Object)"configs");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RelabelConfig> buildConfigs() {
        return this.configs != null ? AlertRelabelConfigSpecFluent.build(this.configs) : null;
    }

    public RelabelConfig buildConfig(int index) {
        return this.configs.get(index).build();
    }

    public RelabelConfig buildFirstConfig() {
        return this.configs.get(0).build();
    }

    public RelabelConfig buildLastConfig() {
        return this.configs.get(this.configs.size() - 1).build();
    }

    public RelabelConfig buildMatchingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.configs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfig(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.configs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfigs(List<RelabelConfig> configs) {
        if (this.configs != null) {
            this._visitables.get((Object)"configs").clear();
        }
        if (configs != null) {
            this.configs = new ArrayList();
            for (RelabelConfig item : configs) {
                this.addToConfigs(item);
            }
        } else {
            this.configs = null;
        }
        return (A)((Object)this);
    }

    public A withConfigs(RelabelConfig ... configs) {
        if (this.configs != null) {
            this.configs.clear();
            this._visitables.remove((Object)"configs");
        }
        if (configs != null) {
            for (RelabelConfig item : configs) {
                this.addToConfigs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConfigs() {
        return this.configs != null && !this.configs.isEmpty();
    }

    public ConfigsNested<A> addNewConfig() {
        return new ConfigsNested(-1, null);
    }

    public ConfigsNested<A> addNewConfigLike(RelabelConfig item) {
        return new ConfigsNested(-1, item);
    }

    public ConfigsNested<A> setNewConfigLike(int index, RelabelConfig item) {
        return new ConfigsNested(index, item);
    }

    public ConfigsNested<A> editConfig(int index) {
        if (this.configs.size() <= index) {
            throw new RuntimeException("Can't edit configs. Index exceeds size.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigsNested<A> editFirstConfig() {
        if (this.configs.size() == 0) {
            throw new RuntimeException("Can't edit first configs. The list is empty.");
        }
        return this.setNewConfigLike(0, this.buildConfig(0));
    }

    public ConfigsNested<A> editLastConfig() {
        int index = this.configs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configs. The list is empty.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public ConfigsNested<A> editMatchingConfig(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configs.size(); ++i) {
            if (!predicate.test(this.configs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configs. No match found.");
        }
        return this.setNewConfigLike(index, this.buildConfig(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertRelabelConfigSpecFluent that = (AlertRelabelConfigSpecFluent)((Object)o);
        if (!Objects.equals(this.configs, that.configs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.configs, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configs != null && !this.configs.isEmpty()) {
            sb.append("configs:");
            sb.append(this.configs + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigsNested<N>
    extends RelabelConfigFluent<ConfigsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        ConfigsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        public N and() {
            return (N)AlertRelabelConfigSpecFluent.this.setToConfigs(this.index, this.builder.build());
        }

        public N endConfig() {
            return this.and();
        }
    }
}

