/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.openshift.api.model.monitoring.v1.AlertmanagerEndpoints;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluent;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfig;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RelabelConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorization;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeAuthorizationFluent;
import io.fabric8.openshift.api.model.monitoring.v1.Sigv4;
import io.fabric8.openshift.api.model.monitoring.v1.Sigv4Builder;
import io.fabric8.openshift.api.model.monitoring.v1.Sigv4Fluent;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AlertmanagerEndpointsFluent<A extends AlertmanagerEndpointsFluent<A>>
extends BaseFluent<A> {
    private ArrayList<RelabelConfigBuilder> alertRelabelings = new ArrayList();
    private String apiVersion;
    private SafeAuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private String bearerTokenFile;
    private Boolean enableHttp2;
    private String name;
    private String namespace;
    private String pathPrefix;
    private IntOrStringBuilder port;
    private ArrayList<RelabelConfigBuilder> relabelings = new ArrayList();
    private String scheme;
    private Sigv4Builder sigv4;
    private String timeout;
    private TLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public AlertmanagerEndpointsFluent() {
    }

    public AlertmanagerEndpointsFluent(AlertmanagerEndpoints instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AlertmanagerEndpoints instance) {
        AlertmanagerEndpoints alertmanagerEndpoints = instance = instance != null ? instance : new AlertmanagerEndpoints();
        if (instance != null) {
            this.withAlertRelabelings(instance.getAlertRelabelings());
            this.withApiVersion(instance.getApiVersion());
            this.withAuthorization(instance.getAuthorization());
            this.withBasicAuth(instance.getBasicAuth());
            this.withBearerTokenFile(instance.getBearerTokenFile());
            this.withEnableHttp2(instance.getEnableHttp2());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withPathPrefix(instance.getPathPrefix());
            this.withPort(instance.getPort());
            this.withRelabelings(instance.getRelabelings());
            this.withScheme(instance.getScheme());
            this.withSigv4(instance.getSigv4());
            this.withTimeout(instance.getTimeout());
            this.withTlsConfig(instance.getTlsConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAlertRelabelings(int index, RelabelConfig item) {
        if (this.alertRelabelings == null) {
            this.alertRelabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.alertRelabelings.size()) {
            this._visitables.get((Object)"alertRelabelings").add(builder);
            this.alertRelabelings.add(builder);
        } else {
            this._visitables.get((Object)"alertRelabelings").add(index, builder);
            this.alertRelabelings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAlertRelabelings(int index, RelabelConfig item) {
        if (this.alertRelabelings == null) {
            this.alertRelabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.alertRelabelings.size()) {
            this._visitables.get((Object)"alertRelabelings").add(builder);
            this.alertRelabelings.add(builder);
        } else {
            this._visitables.get((Object)"alertRelabelings").set(index, builder);
            this.alertRelabelings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAlertRelabelings(RelabelConfig ... items) {
        if (this.alertRelabelings == null) {
            this.alertRelabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"alertRelabelings").add(builder);
            this.alertRelabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAlertRelabelings(Collection<RelabelConfig> items) {
        if (this.alertRelabelings == null) {
            this.alertRelabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"alertRelabelings").add(builder);
            this.alertRelabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAlertRelabelings(RelabelConfig ... items) {
        if (this.alertRelabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"alertRelabelings").remove((Object)builder);
            this.alertRelabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAlertRelabelings(Collection<RelabelConfig> items) {
        if (this.alertRelabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"alertRelabelings").remove((Object)builder);
            this.alertRelabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAlertRelabelings(Predicate<RelabelConfigBuilder> predicate) {
        if (this.alertRelabelings == null) {
            return (A)((Object)this);
        }
        Iterator<RelabelConfigBuilder> each = this.alertRelabelings.iterator();
        List visitables = this._visitables.get((Object)"alertRelabelings");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RelabelConfig> buildAlertRelabelings() {
        return this.alertRelabelings != null ? AlertmanagerEndpointsFluent.build(this.alertRelabelings) : null;
    }

    public RelabelConfig buildAlertRelabeling(int index) {
        return this.alertRelabelings.get(index).build();
    }

    public RelabelConfig buildFirstAlertRelabeling() {
        return this.alertRelabelings.get(0).build();
    }

    public RelabelConfig buildLastAlertRelabeling() {
        return this.alertRelabelings.get(this.alertRelabelings.size() - 1).build();
    }

    public RelabelConfig buildMatchingAlertRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.alertRelabelings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAlertRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.alertRelabelings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAlertRelabelings(List<RelabelConfig> alertRelabelings) {
        if (this.alertRelabelings != null) {
            this._visitables.get((Object)"alertRelabelings").clear();
        }
        if (alertRelabelings != null) {
            this.alertRelabelings = new ArrayList();
            for (RelabelConfig item : alertRelabelings) {
                this.addToAlertRelabelings(item);
            }
        } else {
            this.alertRelabelings = null;
        }
        return (A)((Object)this);
    }

    public A withAlertRelabelings(RelabelConfig ... alertRelabelings) {
        if (this.alertRelabelings != null) {
            this.alertRelabelings.clear();
            this._visitables.remove((Object)"alertRelabelings");
        }
        if (alertRelabelings != null) {
            for (RelabelConfig item : alertRelabelings) {
                this.addToAlertRelabelings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAlertRelabelings() {
        return this.alertRelabelings != null && !this.alertRelabelings.isEmpty();
    }

    public AlertRelabelingsNested<A> addNewAlertRelabeling() {
        return new AlertRelabelingsNested(-1, null);
    }

    public AlertRelabelingsNested<A> addNewAlertRelabelingLike(RelabelConfig item) {
        return new AlertRelabelingsNested(-1, item);
    }

    public AlertRelabelingsNested<A> setNewAlertRelabelingLike(int index, RelabelConfig item) {
        return new AlertRelabelingsNested(index, item);
    }

    public AlertRelabelingsNested<A> editAlertRelabeling(int index) {
        if (this.alertRelabelings.size() <= index) {
            throw new RuntimeException("Can't edit alertRelabelings. Index exceeds size.");
        }
        return this.setNewAlertRelabelingLike(index, this.buildAlertRelabeling(index));
    }

    public AlertRelabelingsNested<A> editFirstAlertRelabeling() {
        if (this.alertRelabelings.size() == 0) {
            throw new RuntimeException("Can't edit first alertRelabelings. The list is empty.");
        }
        return this.setNewAlertRelabelingLike(0, this.buildAlertRelabeling(0));
    }

    public AlertRelabelingsNested<A> editLastAlertRelabeling() {
        int index = this.alertRelabelings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last alertRelabelings. The list is empty.");
        }
        return this.setNewAlertRelabelingLike(index, this.buildAlertRelabeling(index));
    }

    public AlertRelabelingsNested<A> editMatchingAlertRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.alertRelabelings.size(); ++i) {
            if (!predicate.test(this.alertRelabelings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching alertRelabelings. No match found.");
        }
        return this.setNewAlertRelabelingLike(index, this.buildAlertRelabeling(index));
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public SafeAuthorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    public A withAuthorization(SafeAuthorization authorization) {
        this._visitables.remove((Object)"authorization");
        if (authorization != null) {
            this.authorization = new SafeAuthorizationBuilder(authorization);
            this._visitables.get((Object)"authorization").add(this.authorization);
        } else {
            this.authorization = null;
            this._visitables.get((Object)"authorization").remove((Object)this.authorization);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthorization() {
        return this.authorization != null;
    }

    public AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNested(null);
    }

    public AuthorizationNested<A> withNewAuthorizationLike(SafeAuthorization item) {
        return new AuthorizationNested(item);
    }

    public AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(null));
    }

    public AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(new SafeAuthorizationBuilder().build()));
    }

    public AuthorizationNested<A> editOrNewAuthorizationLike(SafeAuthorization item) {
        return this.withNewAuthorizationLike(Optional.ofNullable(this.buildAuthorization()).orElse(item));
    }

    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.remove((Object)"basicAuth");
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get((Object)"basicAuth").add(this.basicAuth);
        } else {
            this.basicAuth = null;
            this._visitables.get((Object)"basicAuth").remove((Object)this.basicAuth);
        }
        return (A)((Object)this);
    }

    public boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    public BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNested(null);
    }

    public BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNested(item);
    }

    public BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(null));
    }

    public BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(new BasicAuthBuilder().build()));
    }

    public BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(Optional.ofNullable(this.buildBasicAuth()).orElse(item));
    }

    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
        return (A)((Object)this);
    }

    public boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    public Boolean getEnableHttp2() {
        return this.enableHttp2;
    }

    public A withEnableHttp2(Boolean enableHttp2) {
        this.enableHttp2 = enableHttp2;
        return (A)((Object)this);
    }

    public boolean hasEnableHttp2() {
        return this.enableHttp2 != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)((Object)this);
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public A withPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return (A)((Object)this);
    }

    public boolean hasPathPrefix() {
        return this.pathPrefix != null;
    }

    public IntOrString buildPort() {
        return this.port != null ? this.port.build() : null;
    }

    public A withPort(IntOrString port) {
        this._visitables.remove((Object)"port");
        if (port != null) {
            this.port = new IntOrStringBuilder(port);
            this._visitables.get((Object)"port").add(this.port);
        } else {
            this.port = null;
            this._visitables.get((Object)"port").remove(this.port);
        }
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public A withNewPort(Object value) {
        return this.withPort(new IntOrString(value));
    }

    public PortNested<A> withNewPort() {
        return new PortNested(null);
    }

    public PortNested<A> withNewPortLike(IntOrString item) {
        return new PortNested(item);
    }

    public PortNested<A> editPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(null));
    }

    public PortNested<A> editOrNewPort() {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(new IntOrStringBuilder().build()));
    }

    public PortNested<A> editOrNewPortLike(IntOrString item) {
        return this.withNewPortLike(Optional.ofNullable(this.buildPort()).orElse(item));
    }

    public A addToRelabelings(int index, RelabelConfig item) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.relabelings.size()) {
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.add(builder);
        } else {
            this._visitables.get((Object)"relabelings").add(index, builder);
            this.relabelings.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRelabelings(int index, RelabelConfig item) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList();
        }
        RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
        if (index < 0 || index >= this.relabelings.size()) {
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.add(builder);
        } else {
            this._visitables.get((Object)"relabelings").set(index, builder);
            this.relabelings.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRelabelings(RelabelConfig ... items) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRelabelings(Collection<RelabelConfig> items) {
        if (this.relabelings == null) {
            this.relabelings = new ArrayList();
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelings").add(builder);
            this.relabelings.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRelabelings(RelabelConfig ... items) {
        if (this.relabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelings").remove((Object)builder);
            this.relabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRelabelings(Collection<RelabelConfig> items) {
        if (this.relabelings == null) {
            return (A)((Object)this);
        }
        for (RelabelConfig item : items) {
            RelabelConfigBuilder builder = new RelabelConfigBuilder(item);
            this._visitables.get((Object)"relabelings").remove((Object)builder);
            this.relabelings.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRelabelings(Predicate<RelabelConfigBuilder> predicate) {
        if (this.relabelings == null) {
            return (A)((Object)this);
        }
        Iterator<RelabelConfigBuilder> each = this.relabelings.iterator();
        List visitables = this._visitables.get((Object)"relabelings");
        while (each.hasNext()) {
            RelabelConfigBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<RelabelConfig> buildRelabelings() {
        return this.relabelings != null ? AlertmanagerEndpointsFluent.build(this.relabelings) : null;
    }

    public RelabelConfig buildRelabeling(int index) {
        return this.relabelings.get(index).build();
    }

    public RelabelConfig buildFirstRelabeling() {
        return this.relabelings.get(0).build();
    }

    public RelabelConfig buildLastRelabeling() {
        return this.relabelings.get(this.relabelings.size() - 1).build();
    }

    public RelabelConfig buildMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelings) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        for (RelabelConfigBuilder item : this.relabelings) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRelabelings(List<RelabelConfig> relabelings) {
        if (this.relabelings != null) {
            this._visitables.get((Object)"relabelings").clear();
        }
        if (relabelings != null) {
            this.relabelings = new ArrayList();
            for (RelabelConfig item : relabelings) {
                this.addToRelabelings(item);
            }
        } else {
            this.relabelings = null;
        }
        return (A)((Object)this);
    }

    public A withRelabelings(RelabelConfig ... relabelings) {
        if (this.relabelings != null) {
            this.relabelings.clear();
            this._visitables.remove((Object)"relabelings");
        }
        if (relabelings != null) {
            for (RelabelConfig item : relabelings) {
                this.addToRelabelings(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRelabelings() {
        return this.relabelings != null && !this.relabelings.isEmpty();
    }

    public RelabelingsNested<A> addNewRelabeling() {
        return new RelabelingsNested(-1, null);
    }

    public RelabelingsNested<A> addNewRelabelingLike(RelabelConfig item) {
        return new RelabelingsNested(-1, item);
    }

    public RelabelingsNested<A> setNewRelabelingLike(int index, RelabelConfig item) {
        return new RelabelingsNested(index, item);
    }

    public RelabelingsNested<A> editRelabeling(int index) {
        if (this.relabelings.size() <= index) {
            throw new RuntimeException("Can't edit relabelings. Index exceeds size.");
        }
        return this.setNewRelabelingLike(index, this.buildRelabeling(index));
    }

    public RelabelingsNested<A> editFirstRelabeling() {
        if (this.relabelings.size() == 0) {
            throw new RuntimeException("Can't edit first relabelings. The list is empty.");
        }
        return this.setNewRelabelingLike(0, this.buildRelabeling(0));
    }

    public RelabelingsNested<A> editLastRelabeling() {
        int index = this.relabelings.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last relabelings. The list is empty.");
        }
        return this.setNewRelabelingLike(index, this.buildRelabeling(index));
    }

    public RelabelingsNested<A> editMatchingRelabeling(Predicate<RelabelConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.relabelings.size(); ++i) {
            if (!predicate.test(this.relabelings.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching relabelings. No match found.");
        }
        return this.setNewRelabelingLike(index, this.buildRelabeling(index));
    }

    public String getScheme() {
        return this.scheme;
    }

    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)((Object)this);
    }

    public boolean hasScheme() {
        return this.scheme != null;
    }

    public Sigv4 buildSigv4() {
        return this.sigv4 != null ? this.sigv4.build() : null;
    }

    public A withSigv4(Sigv4 sigv4) {
        this._visitables.remove((Object)"sigv4");
        if (sigv4 != null) {
            this.sigv4 = new Sigv4Builder(sigv4);
            this._visitables.get((Object)"sigv4").add(this.sigv4);
        } else {
            this.sigv4 = null;
            this._visitables.get((Object)"sigv4").remove((Object)this.sigv4);
        }
        return (A)((Object)this);
    }

    public boolean hasSigv4() {
        return this.sigv4 != null;
    }

    public Sigv4Nested<A> withNewSigv4() {
        return new Sigv4Nested(null);
    }

    public Sigv4Nested<A> withNewSigv4Like(Sigv4 item) {
        return new Sigv4Nested(item);
    }

    public Sigv4Nested<A> editSigv4() {
        return this.withNewSigv4Like(Optional.ofNullable(this.buildSigv4()).orElse(null));
    }

    public Sigv4Nested<A> editOrNewSigv4() {
        return this.withNewSigv4Like(Optional.ofNullable(this.buildSigv4()).orElse(new Sigv4Builder().build()));
    }

    public Sigv4Nested<A> editOrNewSigv4Like(Sigv4 item) {
        return this.withNewSigv4Like(Optional.ofNullable(this.buildSigv4()).orElse(item));
    }

    public String getTimeout() {
        return this.timeout;
    }

    public A withTimeout(String timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.remove((Object)"tlsConfig");
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get((Object)"tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get((Object)"tlsConfig").remove((Object)this.tlsConfig);
        }
        return (A)((Object)this);
    }

    public boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    public TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNested(null);
    }

    public TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNested(item);
    }

    public TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(null));
    }

    public TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(new TLSConfigBuilder().build()));
    }

    public TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(Optional.ofNullable(this.buildTlsConfig()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlertmanagerEndpointsFluent that = (AlertmanagerEndpointsFluent)((Object)o);
        if (!Objects.equals(this.alertRelabelings, that.alertRelabelings)) {
            return false;
        }
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals((Object)this.authorization, (Object)that.authorization)) {
            return false;
        }
        if (!Objects.equals((Object)this.basicAuth, (Object)that.basicAuth)) {
            return false;
        }
        if (!Objects.equals(this.bearerTokenFile, that.bearerTokenFile)) {
            return false;
        }
        if (!Objects.equals(this.enableHttp2, that.enableHttp2)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.pathPrefix, that.pathPrefix)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.relabelings, that.relabelings)) {
            return false;
        }
        if (!Objects.equals(this.scheme, that.scheme)) {
            return false;
        }
        if (!Objects.equals((Object)this.sigv4, (Object)that.sigv4)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        if (!Objects.equals((Object)this.tlsConfig, (Object)that.tlsConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alertRelabelings, this.apiVersion, this.authorization, this.basicAuth, this.bearerTokenFile, this.enableHttp2, this.name, this.namespace, this.pathPrefix, this.port, this.relabelings, this.scheme, this.sigv4, this.timeout, this.tlsConfig, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alertRelabelings != null && !this.alertRelabelings.isEmpty()) {
            sb.append("alertRelabelings:");
            sb.append(this.alertRelabelings + ",");
        }
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.authorization != null) {
            sb.append("authorization:");
            sb.append(this.authorization + ",");
        }
        if (this.basicAuth != null) {
            sb.append("basicAuth:");
            sb.append(this.basicAuth + ",");
        }
        if (this.bearerTokenFile != null) {
            sb.append("bearerTokenFile:");
            sb.append(this.bearerTokenFile + ",");
        }
        if (this.enableHttp2 != null) {
            sb.append("enableHttp2:");
            sb.append(this.enableHttp2 + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.pathPrefix != null) {
            sb.append("pathPrefix:");
            sb.append(this.pathPrefix + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.relabelings != null && !this.relabelings.isEmpty()) {
            sb.append("relabelings:");
            sb.append(this.relabelings + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme + ",");
        }
        if (this.sigv4 != null) {
            sb.append("sigv4:");
            sb.append(this.sigv4 + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnableHttp2() {
        return this.withEnableHttp2(true);
    }

    public class TlsConfigNested<N>
    extends TLSConfigFluent<TlsConfigNested<N>>
    implements Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNested(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        public N and() {
            return (N)AlertmanagerEndpointsFluent.this.withTlsConfig(this.builder.build());
        }

        public N endTlsConfig() {
            return this.and();
        }
    }

    public class Sigv4Nested<N>
    extends Sigv4Fluent<Sigv4Nested<N>>
    implements Nested<N> {
        Sigv4Builder builder;

        Sigv4Nested(Sigv4 item) {
            this.builder = new Sigv4Builder(this, item);
        }

        public N and() {
            return (N)AlertmanagerEndpointsFluent.this.withSigv4(this.builder.build());
        }

        public N endSigv4() {
            return this.and();
        }
    }

    public class RelabelingsNested<N>
    extends RelabelConfigFluent<RelabelingsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        RelabelingsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        public N and() {
            return (N)AlertmanagerEndpointsFluent.this.setToRelabelings(this.index, this.builder.build());
        }

        public N endRelabeling() {
            return this.and();
        }
    }

    public class PortNested<N>
    extends IntOrStringFluent<PortNested<N>>
    implements Nested<N> {
        IntOrStringBuilder builder;

        PortNested(IntOrString item) {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this, item);
        }

        public N and() {
            return (N)AlertmanagerEndpointsFluent.this.withPort(this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class BasicAuthNested<N>
    extends BasicAuthFluent<BasicAuthNested<N>>
    implements Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNested(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        public N and() {
            return (N)AlertmanagerEndpointsFluent.this.withBasicAuth(this.builder.build());
        }

        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNested<N>
    extends SafeAuthorizationFluent<AuthorizationNested<N>>
    implements Nested<N> {
        SafeAuthorizationBuilder builder;

        AuthorizationNested(SafeAuthorization item) {
            this.builder = new SafeAuthorizationBuilder(this, item);
        }

        public N and() {
            return (N)AlertmanagerEndpointsFluent.this.withAuthorization(this.builder.build());
        }

        public N endAuthorization() {
            return this.and();
        }
    }

    public class AlertRelabelingsNested<N>
    extends RelabelConfigFluent<AlertRelabelingsNested<N>>
    implements Nested<N> {
        RelabelConfigBuilder builder;
        int index;

        AlertRelabelingsNested(int index, RelabelConfig item) {
            this.index = index;
            this.builder = new RelabelConfigBuilder(this, item);
        }

        public N and() {
            return (N)AlertmanagerEndpointsFluent.this.setToAlertRelabelings(this.index, this.builder.build());
        }

        public N endAlertRelabeling() {
            return this.and();
        }
    }
}

