/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelector;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.NamespaceSelectorFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpoint;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.PodMetricsEndpointFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpec;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodMonitorSpecFluentImpl<A extends PodMonitorSpecFluent<A>>
extends BaseFluent<A>
implements PodMonitorSpecFluent<A> {
    private String jobLabel;
    private Long labelLimit;
    private Long labelNameLengthLimit;
    private Long labelValueLengthLimit;
    private NamespaceSelectorBuilder namespaceSelector;
    private ArrayList<PodMetricsEndpointBuilder> podMetricsEndpoints = new ArrayList();
    private List<String> podTargetLabels = new ArrayList<String>();
    private Long sampleLimit;
    private LabelSelectorBuilder selector;
    private Long targetLimit;
    private Map<String, Object> additionalProperties;

    public PodMonitorSpecFluentImpl() {
    }

    public PodMonitorSpecFluentImpl(PodMonitorSpec instance) {
        this.withJobLabel(instance.getJobLabel());
        this.withLabelLimit(instance.getLabelLimit());
        this.withLabelNameLengthLimit(instance.getLabelNameLengthLimit());
        this.withLabelValueLengthLimit(instance.getLabelValueLengthLimit());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPodMetricsEndpoints(instance.getPodMetricsEndpoints());
        this.withPodTargetLabels(instance.getPodTargetLabels());
        this.withSampleLimit(instance.getSampleLimit());
        this.withSelector(instance.getSelector());
        this.withTargetLimit(instance.getTargetLimit());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getJobLabel() {
        return this.jobLabel;
    }

    @Override
    public A withJobLabel(String jobLabel) {
        this.jobLabel = jobLabel;
        return (A)this;
    }

    @Override
    public Boolean hasJobLabel() {
        return this.jobLabel != null;
    }

    @Override
    public Long getLabelLimit() {
        return this.labelLimit;
    }

    @Override
    public A withLabelLimit(Long labelLimit) {
        this.labelLimit = labelLimit;
        return (A)this;
    }

    @Override
    public Boolean hasLabelLimit() {
        return this.labelLimit != null;
    }

    @Override
    public Long getLabelNameLengthLimit() {
        return this.labelNameLengthLimit;
    }

    @Override
    public A withLabelNameLengthLimit(Long labelNameLengthLimit) {
        this.labelNameLengthLimit = labelNameLengthLimit;
        return (A)this;
    }

    @Override
    public Boolean hasLabelNameLengthLimit() {
        return this.labelNameLengthLimit != null;
    }

    @Override
    public Long getLabelValueLengthLimit() {
        return this.labelValueLengthLimit;
    }

    @Override
    public A withLabelValueLengthLimit(Long labelValueLengthLimit) {
        this.labelValueLengthLimit = labelValueLengthLimit;
        return (A)this;
    }

    @Override
    public Boolean hasLabelValueLengthLimit() {
        return this.labelValueLengthLimit != null;
    }

    @Override
    @Deprecated
    public NamespaceSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public NamespaceSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(NamespaceSelector namespaceSelector) {
        this._visitables.get((Object)"namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new NamespaceSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get((Object)"namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(NamespaceSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new NamespaceSelectorBuilder().build());
    }

    @Override
    public PodMonitorSpecFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(NamespaceSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    public A addToPodMetricsEndpoints(Integer index, PodMetricsEndpoint item) {
        if (this.podMetricsEndpoints == null) {
            this.podMetricsEndpoints = new ArrayList();
        }
        PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
        this._visitables.get((Object)"podMetricsEndpoints").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"podMetricsEndpoints").size(), builder);
        this.podMetricsEndpoints.add(index >= 0 ? index.intValue() : this.podMetricsEndpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPodMetricsEndpoints(Integer index, PodMetricsEndpoint item) {
        if (this.podMetricsEndpoints == null) {
            this.podMetricsEndpoints = new ArrayList();
        }
        PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"podMetricsEndpoints").size()) {
            this._visitables.get((Object)"podMetricsEndpoints").add(builder);
        } else {
            this._visitables.get((Object)"podMetricsEndpoints").set(index, builder);
        }
        if (index < 0 || index >= this.podMetricsEndpoints.size()) {
            this.podMetricsEndpoints.add(builder);
        } else {
            this.podMetricsEndpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPodMetricsEndpoints(PodMetricsEndpoint ... items) {
        if (this.podMetricsEndpoints == null) {
            this.podMetricsEndpoints = new ArrayList();
        }
        for (PodMetricsEndpoint item : items) {
            PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
            this._visitables.get((Object)"podMetricsEndpoints").add(builder);
            this.podMetricsEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPodMetricsEndpoints(Collection<PodMetricsEndpoint> items) {
        if (this.podMetricsEndpoints == null) {
            this.podMetricsEndpoints = new ArrayList();
        }
        for (PodMetricsEndpoint item : items) {
            PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
            this._visitables.get((Object)"podMetricsEndpoints").add(builder);
            this.podMetricsEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPodMetricsEndpoints(PodMetricsEndpoint ... items) {
        for (PodMetricsEndpoint item : items) {
            PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
            this._visitables.get((Object)"podMetricsEndpoints").remove(builder);
            if (this.podMetricsEndpoints == null) continue;
            this.podMetricsEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPodMetricsEndpoints(Collection<PodMetricsEndpoint> items) {
        for (PodMetricsEndpoint item : items) {
            PodMetricsEndpointBuilder builder = new PodMetricsEndpointBuilder(item);
            this._visitables.get((Object)"podMetricsEndpoints").remove(builder);
            if (this.podMetricsEndpoints == null) continue;
            this.podMetricsEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPodMetricsEndpoints(Predicate<PodMetricsEndpointBuilder> predicate) {
        if (this.podMetricsEndpoints == null) {
            return (A)this;
        }
        Iterator<PodMetricsEndpointBuilder> each = this.podMetricsEndpoints.iterator();
        List visitables = this._visitables.get((Object)"podMetricsEndpoints");
        while (each.hasNext()) {
            PodMetricsEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodMetricsEndpoint> getPodMetricsEndpoints() {
        return this.podMetricsEndpoints != null ? PodMonitorSpecFluentImpl.build(this.podMetricsEndpoints) : null;
    }

    @Override
    public List<PodMetricsEndpoint> buildPodMetricsEndpoints() {
        return this.podMetricsEndpoints != null ? PodMonitorSpecFluentImpl.build(this.podMetricsEndpoints) : null;
    }

    @Override
    public PodMetricsEndpoint buildPodMetricsEndpoint(Integer index) {
        return this.podMetricsEndpoints.get(index).build();
    }

    @Override
    public PodMetricsEndpoint buildFirstPodMetricsEndpoint() {
        return this.podMetricsEndpoints.get(0).build();
    }

    @Override
    public PodMetricsEndpoint buildLastPodMetricsEndpoint() {
        return this.podMetricsEndpoints.get(this.podMetricsEndpoints.size() - 1).build();
    }

    @Override
    public PodMetricsEndpoint buildMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
        for (PodMetricsEndpointBuilder item : this.podMetricsEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
        for (PodMetricsEndpointBuilder item : this.podMetricsEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPodMetricsEndpoints(List<PodMetricsEndpoint> podMetricsEndpoints) {
        if (this.podMetricsEndpoints != null) {
            this._visitables.get((Object)"podMetricsEndpoints").removeAll(this.podMetricsEndpoints);
        }
        if (podMetricsEndpoints != null) {
            this.podMetricsEndpoints = new ArrayList();
            for (PodMetricsEndpoint item : podMetricsEndpoints) {
                this.addToPodMetricsEndpoints(item);
            }
        } else {
            this.podMetricsEndpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withPodMetricsEndpoints(PodMetricsEndpoint ... podMetricsEndpoints) {
        if (this.podMetricsEndpoints != null) {
            this.podMetricsEndpoints.clear();
        }
        if (podMetricsEndpoints != null) {
            for (PodMetricsEndpoint item : podMetricsEndpoints) {
                this.addToPodMetricsEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodMetricsEndpoints() {
        return this.podMetricsEndpoints != null && !this.podMetricsEndpoints.isEmpty();
    }

    @Override
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpoint() {
        return new PodMetricsEndpointsNestedImpl();
    }

    @Override
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> addNewPodMetricsEndpointLike(PodMetricsEndpoint item) {
        return new PodMetricsEndpointsNestedImpl(-1, item);
    }

    @Override
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> setNewPodMetricsEndpointLike(Integer index, PodMetricsEndpoint item) {
        return new PodMetricsEndpointsNestedImpl(index, item);
    }

    @Override
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editPodMetricsEndpoint(Integer index) {
        if (this.podMetricsEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit podMetricsEndpoints. Index exceeds size.");
        }
        return this.setNewPodMetricsEndpointLike(index, this.buildPodMetricsEndpoint(index));
    }

    @Override
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editFirstPodMetricsEndpoint() {
        if (this.podMetricsEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first podMetricsEndpoints. The list is empty.");
        }
        return this.setNewPodMetricsEndpointLike(0, this.buildPodMetricsEndpoint(0));
    }

    @Override
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editLastPodMetricsEndpoint() {
        int index = this.podMetricsEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last podMetricsEndpoints. The list is empty.");
        }
        return this.setNewPodMetricsEndpointLike(index, this.buildPodMetricsEndpoint(index));
    }

    @Override
    public PodMonitorSpecFluent.PodMetricsEndpointsNested<A> editMatchingPodMetricsEndpoint(Predicate<PodMetricsEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.podMetricsEndpoints.size(); ++i) {
            if (!predicate.test(this.podMetricsEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching podMetricsEndpoints. No match found.");
        }
        return this.setNewPodMetricsEndpointLike(index, this.buildPodMetricsEndpoint(index));
    }

    @Override
    public A addToPodTargetLabels(Integer index, String item) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPodTargetLabels(Integer index, String item) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        this.podTargetLabels.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPodTargetLabels(String ... items) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podTargetLabels.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPodTargetLabels(Collection<String> items) {
        if (this.podTargetLabels == null) {
            this.podTargetLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podTargetLabels.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPodTargetLabels(String ... items) {
        for (String item : items) {
            if (this.podTargetLabels == null) continue;
            this.podTargetLabels.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPodTargetLabels(Collection<String> items) {
        for (String item : items) {
            if (this.podTargetLabels == null) continue;
            this.podTargetLabels.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPodTargetLabels() {
        return this.podTargetLabels;
    }

    @Override
    public String getPodTargetLabel(Integer index) {
        return this.podTargetLabels.get(index);
    }

    @Override
    public String getFirstPodTargetLabel() {
        return this.podTargetLabels.get(0);
    }

    @Override
    public String getLastPodTargetLabel() {
        return this.podTargetLabels.get(this.podTargetLabels.size() - 1);
    }

    @Override
    public String getMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item : this.podTargetLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPodTargetLabel(Predicate<String> predicate) {
        for (String item : this.podTargetLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPodTargetLabels(List<String> podTargetLabels) {
        if (podTargetLabels != null) {
            this.podTargetLabels = new ArrayList<String>();
            for (String item : podTargetLabels) {
                this.addToPodTargetLabels(item);
            }
        } else {
            this.podTargetLabels = null;
        }
        return (A)this;
    }

    @Override
    public A withPodTargetLabels(String ... podTargetLabels) {
        if (this.podTargetLabels != null) {
            this.podTargetLabels.clear();
        }
        if (podTargetLabels != null) {
            for (String item : podTargetLabels) {
                this.addToPodTargetLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodTargetLabels() {
        return this.podTargetLabels != null && !this.podTargetLabels.isEmpty();
    }

    @Override
    public Long getSampleLimit() {
        return this.sampleLimit;
    }

    @Override
    public A withSampleLimit(Long sampleLimit) {
        this.sampleLimit = sampleLimit;
        return (A)this;
    }

    @Override
    public Boolean hasSampleLimit() {
        return this.sampleLimit != null;
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get((Object)"selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public PodMonitorSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public PodMonitorSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public PodMonitorSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public PodMonitorSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PodMonitorSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public Long getTargetLimit() {
        return this.targetLimit;
    }

    @Override
    public A withTargetLimit(Long targetLimit) {
        this.targetLimit = targetLimit;
        return (A)this;
    }

    @Override
    public Boolean hasTargetLimit() {
        return this.targetLimit != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodMonitorSpecFluentImpl that = (PodMonitorSpecFluentImpl)o;
        if (this.jobLabel != null ? !this.jobLabel.equals(that.jobLabel) : that.jobLabel != null) {
            return false;
        }
        if (this.labelLimit != null ? !this.labelLimit.equals(that.labelLimit) : that.labelLimit != null) {
            return false;
        }
        if (this.labelNameLengthLimit != null ? !this.labelNameLengthLimit.equals(that.labelNameLengthLimit) : that.labelNameLengthLimit != null) {
            return false;
        }
        if (this.labelValueLengthLimit != null ? !this.labelValueLengthLimit.equals(that.labelValueLengthLimit) : that.labelValueLengthLimit != null) {
            return false;
        }
        if (this.namespaceSelector != null ? !this.namespaceSelector.equals(that.namespaceSelector) : that.namespaceSelector != null) {
            return false;
        }
        if (this.podMetricsEndpoints != null ? !this.podMetricsEndpoints.equals(that.podMetricsEndpoints) : that.podMetricsEndpoints != null) {
            return false;
        }
        if (this.podTargetLabels != null ? !this.podTargetLabels.equals(that.podTargetLabels) : that.podTargetLabels != null) {
            return false;
        }
        if (this.sampleLimit != null ? !this.sampleLimit.equals(that.sampleLimit) : that.sampleLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals((Object)that.selector) : that.selector != null) {
            return false;
        }
        if (this.targetLimit != null ? !this.targetLimit.equals(that.targetLimit) : that.targetLimit != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.jobLabel, this.labelLimit, this.labelNameLengthLimit, this.labelValueLengthLimit, this.namespaceSelector, this.podMetricsEndpoints, this.podTargetLabels, this.sampleLimit, this.selector, this.targetLimit, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobLabel != null) {
            sb.append("jobLabel:");
            sb.append(this.jobLabel + ",");
        }
        if (this.labelLimit != null) {
            sb.append("labelLimit:");
            sb.append(this.labelLimit + ",");
        }
        if (this.labelNameLengthLimit != null) {
            sb.append("labelNameLengthLimit:");
            sb.append(this.labelNameLengthLimit + ",");
        }
        if (this.labelValueLengthLimit != null) {
            sb.append("labelValueLengthLimit:");
            sb.append(this.labelValueLengthLimit + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.podMetricsEndpoints != null && !this.podMetricsEndpoints.isEmpty()) {
            sb.append("podMetricsEndpoints:");
            sb.append(this.podMetricsEndpoints + ",");
        }
        if (this.podTargetLabels != null && !this.podTargetLabels.isEmpty()) {
            sb.append("podTargetLabels:");
            sb.append(this.podTargetLabels + ",");
        }
        if (this.sampleLimit != null) {
            sb.append("sampleLimit:");
            sb.append(this.sampleLimit + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.targetLimit != null) {
            sb.append("targetLimit:");
            sb.append(this.targetLimit + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PodMonitorSpecFluent.SelectorNested<N>>
    implements PodMonitorSpecFluent.SelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)PodMonitorSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }

    class PodMetricsEndpointsNestedImpl<N>
    extends PodMetricsEndpointFluentImpl<PodMonitorSpecFluent.PodMetricsEndpointsNested<N>>
    implements PodMonitorSpecFluent.PodMetricsEndpointsNested<N>,
    Nested<N> {
        PodMetricsEndpointBuilder builder;
        Integer index;

        PodMetricsEndpointsNestedImpl(Integer index, PodMetricsEndpoint item) {
            this.index = index;
            this.builder = new PodMetricsEndpointBuilder(this, item);
        }

        PodMetricsEndpointsNestedImpl() {
            this.index = -1;
            this.builder = new PodMetricsEndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMonitorSpecFluentImpl.this.setToPodMetricsEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endPodMetricsEndpoint() {
            return this.and();
        }
    }

    class NamespaceSelectorNestedImpl<N>
    extends NamespaceSelectorFluentImpl<PodMonitorSpecFluent.NamespaceSelectorNested<N>>
    implements PodMonitorSpecFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        NamespaceSelectorBuilder builder;

        NamespaceSelectorNestedImpl(NamespaceSelector item) {
            this.builder = new NamespaceSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new NamespaceSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMonitorSpecFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }
}

