/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1.WebTLSConfigFluentImpl;

public class WebTLSConfigBuilder
extends WebTLSConfigFluentImpl<WebTLSConfigBuilder>
implements VisitableBuilder<WebTLSConfig, WebTLSConfigBuilder> {
    WebTLSConfigFluent<?> fluent;
    Boolean validationEnabled;

    public WebTLSConfigBuilder() {
        this(false);
    }

    public WebTLSConfigBuilder(Boolean validationEnabled) {
        this(new WebTLSConfig(), validationEnabled);
    }

    public WebTLSConfigBuilder(WebTLSConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public WebTLSConfigBuilder(WebTLSConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new WebTLSConfig(), validationEnabled);
    }

    public WebTLSConfigBuilder(WebTLSConfigFluent<?> fluent, WebTLSConfig instance) {
        this(fluent, instance, false);
    }

    public WebTLSConfigBuilder(WebTLSConfigFluent<?> fluent, WebTLSConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCert(instance.getCert());
        fluent.withCipherSuites(instance.getCipherSuites());
        fluent.withClientAuthType(instance.getClientAuthType());
        fluent.withClientCa(instance.getClientCa());
        fluent.withCurvePreferences(instance.getCurvePreferences());
        fluent.withKeySecret(instance.getKeySecret());
        fluent.withMaxVersion(instance.getMaxVersion());
        fluent.withMinVersion(instance.getMinVersion());
        fluent.withPreferServerCipherSuites(instance.getPreferServerCipherSuites());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public WebTLSConfigBuilder(WebTLSConfig instance) {
        this(instance, (Boolean)false);
    }

    public WebTLSConfigBuilder(WebTLSConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCert(instance.getCert());
        this.withCipherSuites(instance.getCipherSuites());
        this.withClientAuthType(instance.getClientAuthType());
        this.withClientCa(instance.getClientCa());
        this.withCurvePreferences(instance.getCurvePreferences());
        this.withKeySecret(instance.getKeySecret());
        this.withMaxVersion(instance.getMaxVersion());
        this.withMinVersion(instance.getMinVersion());
        this.withPreferServerCipherSuites(instance.getPreferServerCipherSuites());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public WebTLSConfig build() {
        WebTLSConfig buildable = new WebTLSConfig(this.fluent.getCert(), this.fluent.getCipherSuites(), this.fluent.getClientAuthType(), this.fluent.getClientCa(), this.fluent.getCurvePreferences(), this.fluent.getKeySecret(), this.fluent.getMaxVersion(), this.fluent.getMinVersion(), this.fluent.getPreferServerCipherSuites());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

