/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitor;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorList;
import io.fabric8.openshift.api.model.monitoring.v1.PodMonitorListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodMonitorListFluentImpl<A extends PodMonitorListFluent<A>>
extends BaseFluent<A>
implements PodMonitorListFluent<A> {
    private String apiVersion;
    private List<PodMonitorBuilder> items = new ArrayList<PodMonitorBuilder>();
    private String kind;
    private ListMeta metadata;

    public PodMonitorListFluentImpl() {
    }

    public PodMonitorListFluentImpl(PodMonitorList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(int index, PodMonitor item) {
        if (this.items == null) {
            this.items = new ArrayList<PodMonitorBuilder>();
        }
        PodMonitorBuilder builder = new PodMonitorBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, PodMonitor item) {
        if (this.items == null) {
            this.items = new ArrayList<PodMonitorBuilder>();
        }
        PodMonitorBuilder builder = new PodMonitorBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(PodMonitor ... items) {
        if (this.items == null) {
            this.items = new ArrayList<PodMonitorBuilder>();
        }
        for (PodMonitor item : items) {
            PodMonitorBuilder builder = new PodMonitorBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<PodMonitor> items) {
        if (this.items == null) {
            this.items = new ArrayList<PodMonitorBuilder>();
        }
        for (PodMonitor item : items) {
            PodMonitorBuilder builder = new PodMonitorBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(PodMonitor ... items) {
        for (PodMonitor item : items) {
            PodMonitorBuilder builder = new PodMonitorBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<PodMonitor> items) {
        for (PodMonitor item : items) {
            PodMonitorBuilder builder = new PodMonitorBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<PodMonitorBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<PodMonitorBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            PodMonitorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodMonitor> getItems() {
        return PodMonitorListFluentImpl.build(this.items);
    }

    @Override
    public List<PodMonitor> buildItems() {
        return PodMonitorListFluentImpl.build(this.items);
    }

    @Override
    public PodMonitor buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public PodMonitor buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public PodMonitor buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public PodMonitor buildMatchingItem(Predicate<PodMonitorBuilder> predicate) {
        for (PodMonitorBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<PodMonitorBuilder> predicate) {
        for (PodMonitorBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<PodMonitor> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<PodMonitorBuilder>();
            for (PodMonitor item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(PodMonitor ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (PodMonitor item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public PodMonitorListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public PodMonitorListFluent.ItemsNested<A> addNewItemLike(PodMonitor item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public PodMonitorListFluent.ItemsNested<A> setNewItemLike(int index, PodMonitor item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public PodMonitorListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public PodMonitorListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public PodMonitorListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public PodMonitorListFluent.ItemsNested<A> editMatchingItem(Predicate<PodMonitorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodMonitorListFluentImpl that = (PodMonitorListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends PodMonitorFluentImpl<PodMonitorListFluent.ItemsNested<N>>
    implements PodMonitorListFluent.ItemsNested<N>,
    Nested<N> {
        private final PodMonitorBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, PodMonitor item) {
            this.index = index;
            this.builder = new PodMonitorBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new PodMonitorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodMonitorListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

