/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.SecretReference;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition;
import io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.Metal3MachineStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class Metal3MachineStatusFluent<A extends Metal3MachineStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private List<MachineAddress> addresses = new ArrayList<MachineAddress>();
    private List<Condition> conditions = new ArrayList<Condition>();
    private String failureMessage;
    private String failureReason;
    private String lastUpdated;
    private SecretReference metaData;
    private SecretReference networkData;
    private String phase;
    private Boolean ready;
    private ObjectReferenceBuilder renderedData;
    private SecretReference userData;

    public Metal3MachineStatusFluent() {
    }

    public Metal3MachineStatusFluent(Metal3MachineStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToAddresses(Collection<MachineAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<MachineAddress>();
        }
        for (MachineAddress item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addNewAddress(String address, String type) {
        return this.addToAddresses(new MachineAddress(address, type));
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(MachineAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<MachineAddress>();
        }
        for (MachineAddress item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(int index, MachineAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<MachineAddress>();
        }
        this.addresses.add(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public ObjectReference buildRenderedData() {
        return this.renderedData != null ? this.renderedData.build() : null;
    }

    protected void copyInstance(Metal3MachineStatus instance) {
        Metal3MachineStatus metal3MachineStatus = instance = instance != null ? instance : new Metal3MachineStatus();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withConditions(instance.getConditions());
            this.withFailureMessage(instance.getFailureMessage());
            this.withFailureReason(instance.getFailureReason());
            this.withLastUpdated(instance.getLastUpdated());
            this.withMetaData(instance.getMetaData());
            this.withNetworkData(instance.getNetworkData());
            this.withPhase(instance.getPhase());
            this.withReady(instance.getReady());
            this.withRenderedData(instance.getRenderedData());
            this.withUserData(instance.getUserData());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RenderedDataNested<A> editOrNewRenderedData() {
        return this.withNewRenderedDataLike(Optional.ofNullable(this.buildRenderedData()).orElse(new ObjectReferenceBuilder().build()));
    }

    public RenderedDataNested<A> editOrNewRenderedDataLike(ObjectReference item) {
        return this.withNewRenderedDataLike(Optional.ofNullable(this.buildRenderedData()).orElse(item));
    }

    public RenderedDataNested<A> editRenderedData() {
        return this.withNewRenderedDataLike(Optional.ofNullable(this.buildRenderedData()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Metal3MachineStatusFluent that = (Metal3MachineStatusFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.failureMessage, that.failureMessage)) {
            return false;
        }
        if (!Objects.equals(this.failureReason, that.failureReason)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdated, that.lastUpdated)) {
            return false;
        }
        if (!Objects.equals(this.metaData, that.metaData)) {
            return false;
        }
        if (!Objects.equals(this.networkData, that.networkData)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.ready, that.ready)) {
            return false;
        }
        if (!Objects.equals(this.renderedData, that.renderedData)) {
            return false;
        }
        if (!Objects.equals(this.userData, that.userData)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public MachineAddress getAddress(int index) {
        return this.addresses.get(index);
    }

    public List<MachineAddress> getAddresses() {
        return this.addresses;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public MachineAddress getFirstAddress() {
        return this.addresses.get(0);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public MachineAddress getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public MachineAddress getMatchingAddress(Predicate<MachineAddress> predicate) {
        for (MachineAddress item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public SecretReference getMetaData() {
        return this.metaData;
    }

    public SecretReference getNetworkData() {
        return this.networkData;
    }

    public String getPhase() {
        return this.phase;
    }

    public Boolean getReady() {
        return this.ready;
    }

    public SecretReference getUserData() {
        return this.userData;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public boolean hasFailureMessage() {
        return this.failureMessage != null;
    }

    public boolean hasFailureReason() {
        return this.failureReason != null;
    }

    public boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    public boolean hasMatchingAddress(Predicate<MachineAddress> predicate) {
        for (MachineAddress item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMetaData() {
        return this.metaData != null;
    }

    public boolean hasNetworkData() {
        return this.networkData != null;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public boolean hasReady() {
        return this.ready != null;
    }

    public boolean hasRenderedData() {
        return this.renderedData != null;
    }

    public boolean hasUserData() {
        return this.userData != null;
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.failureMessage, this.failureReason, this.lastUpdated, this.metaData, this.networkData, this.phase, this.ready, this.renderedData, this.userData, this.additionalProperties);
    }

    public A removeAllFromAddresses(Collection<MachineAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (MachineAddress item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(MachineAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (MachineAddress item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A setToAddresses(int index, MachineAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<MachineAddress>();
        }
        this.addresses.set(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses);
            sb.append(",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions);
            sb.append(",");
        }
        if (this.failureMessage != null) {
            sb.append("failureMessage:");
            sb.append(this.failureMessage);
            sb.append(",");
        }
        if (this.failureReason != null) {
            sb.append("failureReason:");
            sb.append(this.failureReason);
            sb.append(",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated);
            sb.append(",");
        }
        if (this.metaData != null) {
            sb.append("metaData:");
            sb.append(this.metaData);
            sb.append(",");
        }
        if (this.networkData != null) {
            sb.append("networkData:");
            sb.append(this.networkData);
            sb.append(",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase);
            sb.append(",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready);
            sb.append(",");
        }
        if (this.renderedData != null) {
            sb.append("renderedData:");
            sb.append(this.renderedData);
            sb.append(",");
        }
        if (this.userData != null) {
            sb.append("userData:");
            sb.append(this.userData);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAddresses(List<MachineAddress> addresses) {
        if (addresses != null) {
            this.addresses = new ArrayList<MachineAddress>();
            for (MachineAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(MachineAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (MachineAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
        return (A)((Object)this);
    }

    public A withFailureReason(String failureReason) {
        this.failureReason = failureReason;
        return (A)((Object)this);
    }

    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)((Object)this);
    }

    public A withMetaData(SecretReference metaData) {
        this.metaData = metaData;
        return (A)((Object)this);
    }

    public A withNetworkData(SecretReference networkData) {
        this.networkData = networkData;
        return (A)((Object)this);
    }

    public A withNewMetaData(String name, String namespace) {
        return this.withMetaData(new SecretReference(name, namespace));
    }

    public A withNewNetworkData(String name, String namespace) {
        return this.withNetworkData(new SecretReference(name, namespace));
    }

    public RenderedDataNested<A> withNewRenderedData() {
        return new RenderedDataNested(null);
    }

    public RenderedDataNested<A> withNewRenderedDataLike(ObjectReference item) {
        return new RenderedDataNested(item);
    }

    public A withNewUserData(String name, String namespace) {
        return this.withUserData(new SecretReference(name, namespace));
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public A withReady() {
        return this.withReady(true);
    }

    public A withReady(Boolean ready) {
        this.ready = ready;
        return (A)((Object)this);
    }

    public A withRenderedData(ObjectReference renderedData) {
        this._visitables.remove((Object)"renderedData");
        if (renderedData != null) {
            this.renderedData = new ObjectReferenceBuilder(renderedData);
            this._visitables.get((Object)"renderedData").add(this.renderedData);
        } else {
            this.renderedData = null;
            this._visitables.get((Object)"renderedData").remove(this.renderedData);
        }
        return (A)((Object)this);
    }

    public A withUserData(SecretReference userData) {
        this.userData = userData;
        return (A)((Object)this);
    }

    public class RenderedDataNested<N>
    extends ObjectReferenceFluent<RenderedDataNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        RenderedDataNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)Metal3MachineStatusFluent.this.withRenderedData(this.builder.build());
        }

        public N endRenderedData() {
            return this.and();
        }
    }
}

