package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class NetworkDataIPv6DHCPFluent<A extends NetworkDataIPv6DHCPFluent<A>> extends BaseFluent<A>{
  public NetworkDataIPv6DHCPFluent() {
  }
  
  public NetworkDataIPv6DHCPFluent(NetworkDataIPv6DHCP instance) {
    this.copyInstance(instance);
  }
  private String id;
  private String link;
  private ArrayList<NetworkDataRoutev6Builder> routes = new ArrayList<NetworkDataRoutev6Builder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(NetworkDataIPv6DHCP instance) {
    instance = (instance != null ? instance : new NetworkDataIPv6DHCP());
    if (instance != null) {
          this.withId(instance.getId());
          this.withLink(instance.getLink());
          this.withRoutes(instance.getRoutes());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getId() {
    return this.id;
  }
  
  public A withId(String id) {
    this.id = id;
    return (A) this;
  }
  
  public boolean hasId() {
    return this.id != null;
  }
  
  public String getLink() {
    return this.link;
  }
  
  public A withLink(String link) {
    this.link = link;
    return (A) this;
  }
  
  public boolean hasLink() {
    return this.link != null;
  }
  
  public A addToRoutes(int index,NetworkDataRoutev6 item) {
    if (this.routes == null) {this.routes = new ArrayList<NetworkDataRoutev6Builder>();}
    NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);
    if (index < 0 || index >= routes.size()) {
        _visitables.get("routes").add(builder);
        routes.add(builder);
    } else {
        _visitables.get("routes").add(builder);
        routes.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToRoutes(int index,NetworkDataRoutev6 item) {
    if (this.routes == null) {this.routes = new ArrayList<NetworkDataRoutev6Builder>();}
    NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);
    if (index < 0 || index >= routes.size()) {
        _visitables.get("routes").add(builder);
        routes.add(builder);
    } else {
        _visitables.get("routes").add(builder);
        routes.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToRoutes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev6... items) {
    if (this.routes == null) {this.routes = new ArrayList<NetworkDataRoutev6Builder>();}
    for (NetworkDataRoutev6 item : items) {NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  
  public A addAllToRoutes(Collection<NetworkDataRoutev6> items) {
    if (this.routes == null) {this.routes = new ArrayList<NetworkDataRoutev6Builder>();}
    for (NetworkDataRoutev6 item : items) {NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);_visitables.get("routes").add(builder);this.routes.add(builder);} return (A)this;
  }
  
  public A removeFromRoutes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev6... items) {
    if (this.routes == null) return (A)this;
    for (NetworkDataRoutev6 item : items) {NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);_visitables.get("routes").remove(builder); this.routes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromRoutes(Collection<NetworkDataRoutev6> items) {
    if (this.routes == null) return (A)this;
    for (NetworkDataRoutev6 item : items) {NetworkDataRoutev6Builder builder = new NetworkDataRoutev6Builder(item);_visitables.get("routes").remove(builder); this.routes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromRoutes(Predicate<NetworkDataRoutev6Builder> predicate) {
    if (routes == null) return (A) this;
    final Iterator<NetworkDataRoutev6Builder> each = routes.iterator();
    final List visitables = _visitables.get("routes");
    while (each.hasNext()) {
      NetworkDataRoutev6Builder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NetworkDataRoutev6> buildRoutes() {
    return this.routes != null ? build(routes) : null;
  }
  
  public NetworkDataRoutev6 buildRoute(int index) {
    return this.routes.get(index).build();
  }
  
  public NetworkDataRoutev6 buildFirstRoute() {
    return this.routes.get(0).build();
  }
  
  public NetworkDataRoutev6 buildLastRoute() {
    return this.routes.get(routes.size() - 1).build();
  }
  
  public NetworkDataRoutev6 buildMatchingRoute(Predicate<NetworkDataRoutev6Builder> predicate) {
      for (NetworkDataRoutev6Builder item : routes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRoute(Predicate<NetworkDataRoutev6Builder> predicate) {
      for (NetworkDataRoutev6Builder item : routes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRoutes(List<NetworkDataRoutev6> routes) {
    if (this.routes != null) {
      this._visitables.get("routes").clear();
    }
    if (routes != null) {
        this.routes = new ArrayList();
        for (NetworkDataRoutev6 item : routes) {
          this.addToRoutes(item);
        }
    } else {
      this.routes = null;
    }
    return (A) this;
  }
  
  public A withRoutes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.NetworkDataRoutev6... routes) {
    if (this.routes != null) {
        this.routes.clear();
        _visitables.remove("routes");
    }
    if (routes != null) {
      for (NetworkDataRoutev6 item : routes) {
        this.addToRoutes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRoutes() {
    return this.routes != null && !this.routes.isEmpty();
  }
  
  public RoutesNested<A> addNewRoute() {
    return new RoutesNested(-1, null);
  }
  
  public RoutesNested<A> addNewRouteLike(NetworkDataRoutev6 item) {
    return new RoutesNested(-1, item);
  }
  
  public RoutesNested<A> setNewRouteLike(int index,NetworkDataRoutev6 item) {
    return new RoutesNested(index, item);
  }
  
  public RoutesNested<A> editRoute(int index) {
    if (routes.size() <= index) throw new RuntimeException("Can't edit routes. Index exceeds size.");
    return setNewRouteLike(index, buildRoute(index));
  }
  
  public RoutesNested<A> editFirstRoute() {
    if (routes.size() == 0) throw new RuntimeException("Can't edit first routes. The list is empty.");
    return setNewRouteLike(0, buildRoute(0));
  }
  
  public RoutesNested<A> editLastRoute() {
    int index = routes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last routes. The list is empty.");
    return setNewRouteLike(index, buildRoute(index));
  }
  
  public RoutesNested<A> editMatchingRoute(Predicate<NetworkDataRoutev6Builder> predicate) {
    int index = -1;
    for (int i=0;i<routes.size();i++) { 
    if (predicate.test(routes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching routes. No match found.");
    return setNewRouteLike(index, buildRoute(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkDataIPv6DHCPFluent that = (NetworkDataIPv6DHCPFluent) o;
    if (!java.util.Objects.equals(id, that.id)) return false;
    if (!java.util.Objects.equals(link, that.link)) return false;
    if (!java.util.Objects.equals(routes, that.routes)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(id,  link,  routes,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (id != null) { sb.append("id:"); sb.append(id + ","); }
    if (link != null) { sb.append("link:"); sb.append(link + ","); }
    if (routes != null && !routes.isEmpty()) { sb.append("routes:"); sb.append(routes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class RoutesNested<N> extends NetworkDataRoutev6Fluent<RoutesNested<N>> implements Nested<N>{
    RoutesNested(int index,NetworkDataRoutev6 item) {
      this.index = index;
      this.builder = new NetworkDataRoutev6Builder(this, item);
    }
    NetworkDataRoutev6Builder builder;
    int index;
    
    public N and() {
      return (N) NetworkDataIPv6DHCPFluent.this.setToRoutes(index,builder.build());
    }
    
    public N endRoute() {
      return and();
    }
    
  
  }

}