package io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MetaDataFluent<A extends MetaDataFluent<A>> extends BaseFluent<A>{
  public MetaDataFluent() {
  }
  
  public MetaDataFluent(MetaData instance) {
    this.copyInstance(instance);
  }
  private ArrayList<FromPoolBuilder> dnsServersFromIPPool = new ArrayList<FromPoolBuilder>();
  private ArrayList<MetaDataFromAnnotationBuilder> fromAnnotations = new ArrayList<MetaDataFromAnnotationBuilder>();
  private ArrayList<MetaDataHostInterfaceBuilder> fromHostInterfaces = new ArrayList<MetaDataHostInterfaceBuilder>();
  private ArrayList<MetaDataFromLabelBuilder> fromLabels = new ArrayList<MetaDataFromLabelBuilder>();
  private ArrayList<FromPoolBuilder> gatewaysFromIPPool = new ArrayList<FromPoolBuilder>();
  private ArrayList<MetaDataIndexBuilder> indexes = new ArrayList<MetaDataIndexBuilder>();
  private ArrayList<FromPoolBuilder> ipAddressesFromIPPool = new ArrayList<FromPoolBuilder>();
  private ArrayList<MetaDataNamespaceBuilder> namespaces = new ArrayList<MetaDataNamespaceBuilder>();
  private ArrayList<MetaDataObjectNameBuilder> objectNames = new ArrayList<MetaDataObjectNameBuilder>();
  private ArrayList<FromPoolBuilder> prefixesFromIPPool = new ArrayList<FromPoolBuilder>();
  private ArrayList<MetaDataStringBuilder> strings = new ArrayList<MetaDataStringBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MetaData instance) {
    instance = (instance != null ? instance : new MetaData());
    if (instance != null) {
          this.withDnsServersFromIPPool(instance.getDnsServersFromIPPool());
          this.withFromAnnotations(instance.getFromAnnotations());
          this.withFromHostInterfaces(instance.getFromHostInterfaces());
          this.withFromLabels(instance.getFromLabels());
          this.withGatewaysFromIPPool(instance.getGatewaysFromIPPool());
          this.withIndexes(instance.getIndexes());
          this.withIpAddressesFromIPPool(instance.getIpAddressesFromIPPool());
          this.withNamespaces(instance.getNamespaces());
          this.withObjectNames(instance.getObjectNames());
          this.withPrefixesFromIPPool(instance.getPrefixesFromIPPool());
          this.withStrings(instance.getStrings());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToDnsServersFromIPPool(int index,FromPool item) {
    if (this.dnsServersFromIPPool == null) {this.dnsServersFromIPPool = new ArrayList<FromPoolBuilder>();}
    FromPoolBuilder builder = new FromPoolBuilder(item);
    if (index < 0 || index >= dnsServersFromIPPool.size()) {
        _visitables.get("dnsServersFromIPPool").add(builder);
        dnsServersFromIPPool.add(builder);
    } else {
        _visitables.get("dnsServersFromIPPool").add(builder);
        dnsServersFromIPPool.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToDnsServersFromIPPool(int index,FromPool item) {
    if (this.dnsServersFromIPPool == null) {this.dnsServersFromIPPool = new ArrayList<FromPoolBuilder>();}
    FromPoolBuilder builder = new FromPoolBuilder(item);
    if (index < 0 || index >= dnsServersFromIPPool.size()) {
        _visitables.get("dnsServersFromIPPool").add(builder);
        dnsServersFromIPPool.add(builder);
    } else {
        _visitables.get("dnsServersFromIPPool").add(builder);
        dnsServersFromIPPool.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToDnsServersFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... items) {
    if (this.dnsServersFromIPPool == null) {this.dnsServersFromIPPool = new ArrayList<FromPoolBuilder>();}
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("dnsServersFromIPPool").add(builder);this.dnsServersFromIPPool.add(builder);} return (A)this;
  }
  
  public A addAllToDnsServersFromIPPool(Collection<FromPool> items) {
    if (this.dnsServersFromIPPool == null) {this.dnsServersFromIPPool = new ArrayList<FromPoolBuilder>();}
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("dnsServersFromIPPool").add(builder);this.dnsServersFromIPPool.add(builder);} return (A)this;
  }
  
  public A removeFromDnsServersFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... items) {
    if (this.dnsServersFromIPPool == null) return (A)this;
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("dnsServersFromIPPool").remove(builder); this.dnsServersFromIPPool.remove(builder);} return (A)this;
  }
  
  public A removeAllFromDnsServersFromIPPool(Collection<FromPool> items) {
    if (this.dnsServersFromIPPool == null) return (A)this;
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("dnsServersFromIPPool").remove(builder); this.dnsServersFromIPPool.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromDnsServersFromIPPool(Predicate<FromPoolBuilder> predicate) {
    if (dnsServersFromIPPool == null) return (A) this;
    final Iterator<FromPoolBuilder> each = dnsServersFromIPPool.iterator();
    final List visitables = _visitables.get("dnsServersFromIPPool");
    while (each.hasNext()) {
      FromPoolBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FromPool> buildDnsServersFromIPPool() {
    return this.dnsServersFromIPPool != null ? build(dnsServersFromIPPool) : null;
  }
  
  public FromPool buildDnsServersFromIPPool(int index) {
    return this.dnsServersFromIPPool.get(index).build();
  }
  
  public FromPool buildFirstDnsServersFromIPPool() {
    return this.dnsServersFromIPPool.get(0).build();
  }
  
  public FromPool buildLastDnsServersFromIPPool() {
    return this.dnsServersFromIPPool.get(dnsServersFromIPPool.size() - 1).build();
  }
  
  public FromPool buildMatchingDnsServersFromIPPool(Predicate<FromPoolBuilder> predicate) {
      for (FromPoolBuilder item : dnsServersFromIPPool) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDnsServersFromIPPool(Predicate<FromPoolBuilder> predicate) {
      for (FromPoolBuilder item : dnsServersFromIPPool) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDnsServersFromIPPool(List<FromPool> dnsServersFromIPPool) {
    if (this.dnsServersFromIPPool != null) {
      this._visitables.get("dnsServersFromIPPool").clear();
    }
    if (dnsServersFromIPPool != null) {
        this.dnsServersFromIPPool = new ArrayList();
        for (FromPool item : dnsServersFromIPPool) {
          this.addToDnsServersFromIPPool(item);
        }
    } else {
      this.dnsServersFromIPPool = null;
    }
    return (A) this;
  }
  
  public A withDnsServersFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... dnsServersFromIPPool) {
    if (this.dnsServersFromIPPool != null) {
        this.dnsServersFromIPPool.clear();
        _visitables.remove("dnsServersFromIPPool");
    }
    if (dnsServersFromIPPool != null) {
      for (FromPool item : dnsServersFromIPPool) {
        this.addToDnsServersFromIPPool(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDnsServersFromIPPool() {
    return this.dnsServersFromIPPool != null && !this.dnsServersFromIPPool.isEmpty();
  }
  
  public A addNewDnsServersFromIPPool(String apiGroup,String key,String kind,String name) {
    return (A)addToDnsServersFromIPPool(new FromPool(apiGroup, key, kind, name));
  }
  
  public DnsServersFromIPPoolNested<A> addNewDnsServersFromIPPool() {
    return new DnsServersFromIPPoolNested(-1, null);
  }
  
  public DnsServersFromIPPoolNested<A> addNewDnsServersFromIPPoolLike(FromPool item) {
    return new DnsServersFromIPPoolNested(-1, item);
  }
  
  public DnsServersFromIPPoolNested<A> setNewDnsServersFromIPPoolLike(int index,FromPool item) {
    return new DnsServersFromIPPoolNested(index, item);
  }
  
  public DnsServersFromIPPoolNested<A> editDnsServersFromIPPool(int index) {
    if (dnsServersFromIPPool.size() <= index) throw new RuntimeException("Can't edit dnsServersFromIPPool. Index exceeds size.");
    return setNewDnsServersFromIPPoolLike(index, buildDnsServersFromIPPool(index));
  }
  
  public DnsServersFromIPPoolNested<A> editFirstDnsServersFromIPPool() {
    if (dnsServersFromIPPool.size() == 0) throw new RuntimeException("Can't edit first dnsServersFromIPPool. The list is empty.");
    return setNewDnsServersFromIPPoolLike(0, buildDnsServersFromIPPool(0));
  }
  
  public DnsServersFromIPPoolNested<A> editLastDnsServersFromIPPool() {
    int index = dnsServersFromIPPool.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dnsServersFromIPPool. The list is empty.");
    return setNewDnsServersFromIPPoolLike(index, buildDnsServersFromIPPool(index));
  }
  
  public DnsServersFromIPPoolNested<A> editMatchingDnsServersFromIPPool(Predicate<FromPoolBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dnsServersFromIPPool.size();i++) { 
    if (predicate.test(dnsServersFromIPPool.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dnsServersFromIPPool. No match found.");
    return setNewDnsServersFromIPPoolLike(index, buildDnsServersFromIPPool(index));
  }
  
  public A addToFromAnnotations(int index,MetaDataFromAnnotation item) {
    if (this.fromAnnotations == null) {this.fromAnnotations = new ArrayList<MetaDataFromAnnotationBuilder>();}
    MetaDataFromAnnotationBuilder builder = new MetaDataFromAnnotationBuilder(item);
    if (index < 0 || index >= fromAnnotations.size()) {
        _visitables.get("fromAnnotations").add(builder);
        fromAnnotations.add(builder);
    } else {
        _visitables.get("fromAnnotations").add(builder);
        fromAnnotations.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToFromAnnotations(int index,MetaDataFromAnnotation item) {
    if (this.fromAnnotations == null) {this.fromAnnotations = new ArrayList<MetaDataFromAnnotationBuilder>();}
    MetaDataFromAnnotationBuilder builder = new MetaDataFromAnnotationBuilder(item);
    if (index < 0 || index >= fromAnnotations.size()) {
        _visitables.get("fromAnnotations").add(builder);
        fromAnnotations.add(builder);
    } else {
        _visitables.get("fromAnnotations").add(builder);
        fromAnnotations.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToFromAnnotations(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataFromAnnotation... items) {
    if (this.fromAnnotations == null) {this.fromAnnotations = new ArrayList<MetaDataFromAnnotationBuilder>();}
    for (MetaDataFromAnnotation item : items) {MetaDataFromAnnotationBuilder builder = new MetaDataFromAnnotationBuilder(item);_visitables.get("fromAnnotations").add(builder);this.fromAnnotations.add(builder);} return (A)this;
  }
  
  public A addAllToFromAnnotations(Collection<MetaDataFromAnnotation> items) {
    if (this.fromAnnotations == null) {this.fromAnnotations = new ArrayList<MetaDataFromAnnotationBuilder>();}
    for (MetaDataFromAnnotation item : items) {MetaDataFromAnnotationBuilder builder = new MetaDataFromAnnotationBuilder(item);_visitables.get("fromAnnotations").add(builder);this.fromAnnotations.add(builder);} return (A)this;
  }
  
  public A removeFromFromAnnotations(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataFromAnnotation... items) {
    if (this.fromAnnotations == null) return (A)this;
    for (MetaDataFromAnnotation item : items) {MetaDataFromAnnotationBuilder builder = new MetaDataFromAnnotationBuilder(item);_visitables.get("fromAnnotations").remove(builder); this.fromAnnotations.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFromAnnotations(Collection<MetaDataFromAnnotation> items) {
    if (this.fromAnnotations == null) return (A)this;
    for (MetaDataFromAnnotation item : items) {MetaDataFromAnnotationBuilder builder = new MetaDataFromAnnotationBuilder(item);_visitables.get("fromAnnotations").remove(builder); this.fromAnnotations.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFromAnnotations(Predicate<MetaDataFromAnnotationBuilder> predicate) {
    if (fromAnnotations == null) return (A) this;
    final Iterator<MetaDataFromAnnotationBuilder> each = fromAnnotations.iterator();
    final List visitables = _visitables.get("fromAnnotations");
    while (each.hasNext()) {
      MetaDataFromAnnotationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MetaDataFromAnnotation> buildFromAnnotations() {
    return this.fromAnnotations != null ? build(fromAnnotations) : null;
  }
  
  public MetaDataFromAnnotation buildFromAnnotation(int index) {
    return this.fromAnnotations.get(index).build();
  }
  
  public MetaDataFromAnnotation buildFirstFromAnnotation() {
    return this.fromAnnotations.get(0).build();
  }
  
  public MetaDataFromAnnotation buildLastFromAnnotation() {
    return this.fromAnnotations.get(fromAnnotations.size() - 1).build();
  }
  
  public MetaDataFromAnnotation buildMatchingFromAnnotation(Predicate<MetaDataFromAnnotationBuilder> predicate) {
      for (MetaDataFromAnnotationBuilder item : fromAnnotations) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFromAnnotation(Predicate<MetaDataFromAnnotationBuilder> predicate) {
      for (MetaDataFromAnnotationBuilder item : fromAnnotations) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFromAnnotations(List<MetaDataFromAnnotation> fromAnnotations) {
    if (this.fromAnnotations != null) {
      this._visitables.get("fromAnnotations").clear();
    }
    if (fromAnnotations != null) {
        this.fromAnnotations = new ArrayList();
        for (MetaDataFromAnnotation item : fromAnnotations) {
          this.addToFromAnnotations(item);
        }
    } else {
      this.fromAnnotations = null;
    }
    return (A) this;
  }
  
  public A withFromAnnotations(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataFromAnnotation... fromAnnotations) {
    if (this.fromAnnotations != null) {
        this.fromAnnotations.clear();
        _visitables.remove("fromAnnotations");
    }
    if (fromAnnotations != null) {
      for (MetaDataFromAnnotation item : fromAnnotations) {
        this.addToFromAnnotations(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFromAnnotations() {
    return this.fromAnnotations != null && !this.fromAnnotations.isEmpty();
  }
  
  public A addNewFromAnnotation(String annotation,String key,String object) {
    return (A)addToFromAnnotations(new MetaDataFromAnnotation(annotation, key, object));
  }
  
  public FromAnnotationsNested<A> addNewFromAnnotation() {
    return new FromAnnotationsNested(-1, null);
  }
  
  public FromAnnotationsNested<A> addNewFromAnnotationLike(MetaDataFromAnnotation item) {
    return new FromAnnotationsNested(-1, item);
  }
  
  public FromAnnotationsNested<A> setNewFromAnnotationLike(int index,MetaDataFromAnnotation item) {
    return new FromAnnotationsNested(index, item);
  }
  
  public FromAnnotationsNested<A> editFromAnnotation(int index) {
    if (fromAnnotations.size() <= index) throw new RuntimeException("Can't edit fromAnnotations. Index exceeds size.");
    return setNewFromAnnotationLike(index, buildFromAnnotation(index));
  }
  
  public FromAnnotationsNested<A> editFirstFromAnnotation() {
    if (fromAnnotations.size() == 0) throw new RuntimeException("Can't edit first fromAnnotations. The list is empty.");
    return setNewFromAnnotationLike(0, buildFromAnnotation(0));
  }
  
  public FromAnnotationsNested<A> editLastFromAnnotation() {
    int index = fromAnnotations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last fromAnnotations. The list is empty.");
    return setNewFromAnnotationLike(index, buildFromAnnotation(index));
  }
  
  public FromAnnotationsNested<A> editMatchingFromAnnotation(Predicate<MetaDataFromAnnotationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<fromAnnotations.size();i++) { 
    if (predicate.test(fromAnnotations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching fromAnnotations. No match found.");
    return setNewFromAnnotationLike(index, buildFromAnnotation(index));
  }
  
  public A addToFromHostInterfaces(int index,MetaDataHostInterface item) {
    if (this.fromHostInterfaces == null) {this.fromHostInterfaces = new ArrayList<MetaDataHostInterfaceBuilder>();}
    MetaDataHostInterfaceBuilder builder = new MetaDataHostInterfaceBuilder(item);
    if (index < 0 || index >= fromHostInterfaces.size()) {
        _visitables.get("fromHostInterfaces").add(builder);
        fromHostInterfaces.add(builder);
    } else {
        _visitables.get("fromHostInterfaces").add(builder);
        fromHostInterfaces.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToFromHostInterfaces(int index,MetaDataHostInterface item) {
    if (this.fromHostInterfaces == null) {this.fromHostInterfaces = new ArrayList<MetaDataHostInterfaceBuilder>();}
    MetaDataHostInterfaceBuilder builder = new MetaDataHostInterfaceBuilder(item);
    if (index < 0 || index >= fromHostInterfaces.size()) {
        _visitables.get("fromHostInterfaces").add(builder);
        fromHostInterfaces.add(builder);
    } else {
        _visitables.get("fromHostInterfaces").add(builder);
        fromHostInterfaces.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToFromHostInterfaces(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataHostInterface... items) {
    if (this.fromHostInterfaces == null) {this.fromHostInterfaces = new ArrayList<MetaDataHostInterfaceBuilder>();}
    for (MetaDataHostInterface item : items) {MetaDataHostInterfaceBuilder builder = new MetaDataHostInterfaceBuilder(item);_visitables.get("fromHostInterfaces").add(builder);this.fromHostInterfaces.add(builder);} return (A)this;
  }
  
  public A addAllToFromHostInterfaces(Collection<MetaDataHostInterface> items) {
    if (this.fromHostInterfaces == null) {this.fromHostInterfaces = new ArrayList<MetaDataHostInterfaceBuilder>();}
    for (MetaDataHostInterface item : items) {MetaDataHostInterfaceBuilder builder = new MetaDataHostInterfaceBuilder(item);_visitables.get("fromHostInterfaces").add(builder);this.fromHostInterfaces.add(builder);} return (A)this;
  }
  
  public A removeFromFromHostInterfaces(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataHostInterface... items) {
    if (this.fromHostInterfaces == null) return (A)this;
    for (MetaDataHostInterface item : items) {MetaDataHostInterfaceBuilder builder = new MetaDataHostInterfaceBuilder(item);_visitables.get("fromHostInterfaces").remove(builder); this.fromHostInterfaces.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFromHostInterfaces(Collection<MetaDataHostInterface> items) {
    if (this.fromHostInterfaces == null) return (A)this;
    for (MetaDataHostInterface item : items) {MetaDataHostInterfaceBuilder builder = new MetaDataHostInterfaceBuilder(item);_visitables.get("fromHostInterfaces").remove(builder); this.fromHostInterfaces.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFromHostInterfaces(Predicate<MetaDataHostInterfaceBuilder> predicate) {
    if (fromHostInterfaces == null) return (A) this;
    final Iterator<MetaDataHostInterfaceBuilder> each = fromHostInterfaces.iterator();
    final List visitables = _visitables.get("fromHostInterfaces");
    while (each.hasNext()) {
      MetaDataHostInterfaceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MetaDataHostInterface> buildFromHostInterfaces() {
    return this.fromHostInterfaces != null ? build(fromHostInterfaces) : null;
  }
  
  public MetaDataHostInterface buildFromHostInterface(int index) {
    return this.fromHostInterfaces.get(index).build();
  }
  
  public MetaDataHostInterface buildFirstFromHostInterface() {
    return this.fromHostInterfaces.get(0).build();
  }
  
  public MetaDataHostInterface buildLastFromHostInterface() {
    return this.fromHostInterfaces.get(fromHostInterfaces.size() - 1).build();
  }
  
  public MetaDataHostInterface buildMatchingFromHostInterface(Predicate<MetaDataHostInterfaceBuilder> predicate) {
      for (MetaDataHostInterfaceBuilder item : fromHostInterfaces) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFromHostInterface(Predicate<MetaDataHostInterfaceBuilder> predicate) {
      for (MetaDataHostInterfaceBuilder item : fromHostInterfaces) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFromHostInterfaces(List<MetaDataHostInterface> fromHostInterfaces) {
    if (this.fromHostInterfaces != null) {
      this._visitables.get("fromHostInterfaces").clear();
    }
    if (fromHostInterfaces != null) {
        this.fromHostInterfaces = new ArrayList();
        for (MetaDataHostInterface item : fromHostInterfaces) {
          this.addToFromHostInterfaces(item);
        }
    } else {
      this.fromHostInterfaces = null;
    }
    return (A) this;
  }
  
  public A withFromHostInterfaces(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataHostInterface... fromHostInterfaces) {
    if (this.fromHostInterfaces != null) {
        this.fromHostInterfaces.clear();
        _visitables.remove("fromHostInterfaces");
    }
    if (fromHostInterfaces != null) {
      for (MetaDataHostInterface item : fromHostInterfaces) {
        this.addToFromHostInterfaces(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFromHostInterfaces() {
    return this.fromHostInterfaces != null && !this.fromHostInterfaces.isEmpty();
  }
  
  public A addNewFromHostInterface(String _interface,String key) {
    return (A)addToFromHostInterfaces(new MetaDataHostInterface(_interface, key));
  }
  
  public FromHostInterfacesNested<A> addNewFromHostInterface() {
    return new FromHostInterfacesNested(-1, null);
  }
  
  public FromHostInterfacesNested<A> addNewFromHostInterfaceLike(MetaDataHostInterface item) {
    return new FromHostInterfacesNested(-1, item);
  }
  
  public FromHostInterfacesNested<A> setNewFromHostInterfaceLike(int index,MetaDataHostInterface item) {
    return new FromHostInterfacesNested(index, item);
  }
  
  public FromHostInterfacesNested<A> editFromHostInterface(int index) {
    if (fromHostInterfaces.size() <= index) throw new RuntimeException("Can't edit fromHostInterfaces. Index exceeds size.");
    return setNewFromHostInterfaceLike(index, buildFromHostInterface(index));
  }
  
  public FromHostInterfacesNested<A> editFirstFromHostInterface() {
    if (fromHostInterfaces.size() == 0) throw new RuntimeException("Can't edit first fromHostInterfaces. The list is empty.");
    return setNewFromHostInterfaceLike(0, buildFromHostInterface(0));
  }
  
  public FromHostInterfacesNested<A> editLastFromHostInterface() {
    int index = fromHostInterfaces.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last fromHostInterfaces. The list is empty.");
    return setNewFromHostInterfaceLike(index, buildFromHostInterface(index));
  }
  
  public FromHostInterfacesNested<A> editMatchingFromHostInterface(Predicate<MetaDataHostInterfaceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<fromHostInterfaces.size();i++) { 
    if (predicate.test(fromHostInterfaces.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching fromHostInterfaces. No match found.");
    return setNewFromHostInterfaceLike(index, buildFromHostInterface(index));
  }
  
  public A addToFromLabels(int index,MetaDataFromLabel item) {
    if (this.fromLabels == null) {this.fromLabels = new ArrayList<MetaDataFromLabelBuilder>();}
    MetaDataFromLabelBuilder builder = new MetaDataFromLabelBuilder(item);
    if (index < 0 || index >= fromLabels.size()) {
        _visitables.get("fromLabels").add(builder);
        fromLabels.add(builder);
    } else {
        _visitables.get("fromLabels").add(builder);
        fromLabels.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToFromLabels(int index,MetaDataFromLabel item) {
    if (this.fromLabels == null) {this.fromLabels = new ArrayList<MetaDataFromLabelBuilder>();}
    MetaDataFromLabelBuilder builder = new MetaDataFromLabelBuilder(item);
    if (index < 0 || index >= fromLabels.size()) {
        _visitables.get("fromLabels").add(builder);
        fromLabels.add(builder);
    } else {
        _visitables.get("fromLabels").add(builder);
        fromLabels.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToFromLabels(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataFromLabel... items) {
    if (this.fromLabels == null) {this.fromLabels = new ArrayList<MetaDataFromLabelBuilder>();}
    for (MetaDataFromLabel item : items) {MetaDataFromLabelBuilder builder = new MetaDataFromLabelBuilder(item);_visitables.get("fromLabels").add(builder);this.fromLabels.add(builder);} return (A)this;
  }
  
  public A addAllToFromLabels(Collection<MetaDataFromLabel> items) {
    if (this.fromLabels == null) {this.fromLabels = new ArrayList<MetaDataFromLabelBuilder>();}
    for (MetaDataFromLabel item : items) {MetaDataFromLabelBuilder builder = new MetaDataFromLabelBuilder(item);_visitables.get("fromLabels").add(builder);this.fromLabels.add(builder);} return (A)this;
  }
  
  public A removeFromFromLabels(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataFromLabel... items) {
    if (this.fromLabels == null) return (A)this;
    for (MetaDataFromLabel item : items) {MetaDataFromLabelBuilder builder = new MetaDataFromLabelBuilder(item);_visitables.get("fromLabels").remove(builder); this.fromLabels.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFromLabels(Collection<MetaDataFromLabel> items) {
    if (this.fromLabels == null) return (A)this;
    for (MetaDataFromLabel item : items) {MetaDataFromLabelBuilder builder = new MetaDataFromLabelBuilder(item);_visitables.get("fromLabels").remove(builder); this.fromLabels.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFromLabels(Predicate<MetaDataFromLabelBuilder> predicate) {
    if (fromLabels == null) return (A) this;
    final Iterator<MetaDataFromLabelBuilder> each = fromLabels.iterator();
    final List visitables = _visitables.get("fromLabels");
    while (each.hasNext()) {
      MetaDataFromLabelBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MetaDataFromLabel> buildFromLabels() {
    return this.fromLabels != null ? build(fromLabels) : null;
  }
  
  public MetaDataFromLabel buildFromLabel(int index) {
    return this.fromLabels.get(index).build();
  }
  
  public MetaDataFromLabel buildFirstFromLabel() {
    return this.fromLabels.get(0).build();
  }
  
  public MetaDataFromLabel buildLastFromLabel() {
    return this.fromLabels.get(fromLabels.size() - 1).build();
  }
  
  public MetaDataFromLabel buildMatchingFromLabel(Predicate<MetaDataFromLabelBuilder> predicate) {
      for (MetaDataFromLabelBuilder item : fromLabels) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFromLabel(Predicate<MetaDataFromLabelBuilder> predicate) {
      for (MetaDataFromLabelBuilder item : fromLabels) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFromLabels(List<MetaDataFromLabel> fromLabels) {
    if (this.fromLabels != null) {
      this._visitables.get("fromLabels").clear();
    }
    if (fromLabels != null) {
        this.fromLabels = new ArrayList();
        for (MetaDataFromLabel item : fromLabels) {
          this.addToFromLabels(item);
        }
    } else {
      this.fromLabels = null;
    }
    return (A) this;
  }
  
  public A withFromLabels(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataFromLabel... fromLabels) {
    if (this.fromLabels != null) {
        this.fromLabels.clear();
        _visitables.remove("fromLabels");
    }
    if (fromLabels != null) {
      for (MetaDataFromLabel item : fromLabels) {
        this.addToFromLabels(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFromLabels() {
    return this.fromLabels != null && !this.fromLabels.isEmpty();
  }
  
  public A addNewFromLabel(String key,String label,String object) {
    return (A)addToFromLabels(new MetaDataFromLabel(key, label, object));
  }
  
  public FromLabelsNested<A> addNewFromLabel() {
    return new FromLabelsNested(-1, null);
  }
  
  public FromLabelsNested<A> addNewFromLabelLike(MetaDataFromLabel item) {
    return new FromLabelsNested(-1, item);
  }
  
  public FromLabelsNested<A> setNewFromLabelLike(int index,MetaDataFromLabel item) {
    return new FromLabelsNested(index, item);
  }
  
  public FromLabelsNested<A> editFromLabel(int index) {
    if (fromLabels.size() <= index) throw new RuntimeException("Can't edit fromLabels. Index exceeds size.");
    return setNewFromLabelLike(index, buildFromLabel(index));
  }
  
  public FromLabelsNested<A> editFirstFromLabel() {
    if (fromLabels.size() == 0) throw new RuntimeException("Can't edit first fromLabels. The list is empty.");
    return setNewFromLabelLike(0, buildFromLabel(0));
  }
  
  public FromLabelsNested<A> editLastFromLabel() {
    int index = fromLabels.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last fromLabels. The list is empty.");
    return setNewFromLabelLike(index, buildFromLabel(index));
  }
  
  public FromLabelsNested<A> editMatchingFromLabel(Predicate<MetaDataFromLabelBuilder> predicate) {
    int index = -1;
    for (int i=0;i<fromLabels.size();i++) { 
    if (predicate.test(fromLabels.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching fromLabels. No match found.");
    return setNewFromLabelLike(index, buildFromLabel(index));
  }
  
  public A addToGatewaysFromIPPool(int index,FromPool item) {
    if (this.gatewaysFromIPPool == null) {this.gatewaysFromIPPool = new ArrayList<FromPoolBuilder>();}
    FromPoolBuilder builder = new FromPoolBuilder(item);
    if (index < 0 || index >= gatewaysFromIPPool.size()) {
        _visitables.get("gatewaysFromIPPool").add(builder);
        gatewaysFromIPPool.add(builder);
    } else {
        _visitables.get("gatewaysFromIPPool").add(builder);
        gatewaysFromIPPool.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToGatewaysFromIPPool(int index,FromPool item) {
    if (this.gatewaysFromIPPool == null) {this.gatewaysFromIPPool = new ArrayList<FromPoolBuilder>();}
    FromPoolBuilder builder = new FromPoolBuilder(item);
    if (index < 0 || index >= gatewaysFromIPPool.size()) {
        _visitables.get("gatewaysFromIPPool").add(builder);
        gatewaysFromIPPool.add(builder);
    } else {
        _visitables.get("gatewaysFromIPPool").add(builder);
        gatewaysFromIPPool.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToGatewaysFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... items) {
    if (this.gatewaysFromIPPool == null) {this.gatewaysFromIPPool = new ArrayList<FromPoolBuilder>();}
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("gatewaysFromIPPool").add(builder);this.gatewaysFromIPPool.add(builder);} return (A)this;
  }
  
  public A addAllToGatewaysFromIPPool(Collection<FromPool> items) {
    if (this.gatewaysFromIPPool == null) {this.gatewaysFromIPPool = new ArrayList<FromPoolBuilder>();}
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("gatewaysFromIPPool").add(builder);this.gatewaysFromIPPool.add(builder);} return (A)this;
  }
  
  public A removeFromGatewaysFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... items) {
    if (this.gatewaysFromIPPool == null) return (A)this;
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("gatewaysFromIPPool").remove(builder); this.gatewaysFromIPPool.remove(builder);} return (A)this;
  }
  
  public A removeAllFromGatewaysFromIPPool(Collection<FromPool> items) {
    if (this.gatewaysFromIPPool == null) return (A)this;
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("gatewaysFromIPPool").remove(builder); this.gatewaysFromIPPool.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromGatewaysFromIPPool(Predicate<FromPoolBuilder> predicate) {
    if (gatewaysFromIPPool == null) return (A) this;
    final Iterator<FromPoolBuilder> each = gatewaysFromIPPool.iterator();
    final List visitables = _visitables.get("gatewaysFromIPPool");
    while (each.hasNext()) {
      FromPoolBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FromPool> buildGatewaysFromIPPool() {
    return this.gatewaysFromIPPool != null ? build(gatewaysFromIPPool) : null;
  }
  
  public FromPool buildGatewaysFromIPPool(int index) {
    return this.gatewaysFromIPPool.get(index).build();
  }
  
  public FromPool buildFirstGatewaysFromIPPool() {
    return this.gatewaysFromIPPool.get(0).build();
  }
  
  public FromPool buildLastGatewaysFromIPPool() {
    return this.gatewaysFromIPPool.get(gatewaysFromIPPool.size() - 1).build();
  }
  
  public FromPool buildMatchingGatewaysFromIPPool(Predicate<FromPoolBuilder> predicate) {
      for (FromPoolBuilder item : gatewaysFromIPPool) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingGatewaysFromIPPool(Predicate<FromPoolBuilder> predicate) {
      for (FromPoolBuilder item : gatewaysFromIPPool) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withGatewaysFromIPPool(List<FromPool> gatewaysFromIPPool) {
    if (this.gatewaysFromIPPool != null) {
      this._visitables.get("gatewaysFromIPPool").clear();
    }
    if (gatewaysFromIPPool != null) {
        this.gatewaysFromIPPool = new ArrayList();
        for (FromPool item : gatewaysFromIPPool) {
          this.addToGatewaysFromIPPool(item);
        }
    } else {
      this.gatewaysFromIPPool = null;
    }
    return (A) this;
  }
  
  public A withGatewaysFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... gatewaysFromIPPool) {
    if (this.gatewaysFromIPPool != null) {
        this.gatewaysFromIPPool.clear();
        _visitables.remove("gatewaysFromIPPool");
    }
    if (gatewaysFromIPPool != null) {
      for (FromPool item : gatewaysFromIPPool) {
        this.addToGatewaysFromIPPool(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasGatewaysFromIPPool() {
    return this.gatewaysFromIPPool != null && !this.gatewaysFromIPPool.isEmpty();
  }
  
  public A addNewGatewaysFromIPPool(String apiGroup,String key,String kind,String name) {
    return (A)addToGatewaysFromIPPool(new FromPool(apiGroup, key, kind, name));
  }
  
  public GatewaysFromIPPoolNested<A> addNewGatewaysFromIPPool() {
    return new GatewaysFromIPPoolNested(-1, null);
  }
  
  public GatewaysFromIPPoolNested<A> addNewGatewaysFromIPPoolLike(FromPool item) {
    return new GatewaysFromIPPoolNested(-1, item);
  }
  
  public GatewaysFromIPPoolNested<A> setNewGatewaysFromIPPoolLike(int index,FromPool item) {
    return new GatewaysFromIPPoolNested(index, item);
  }
  
  public GatewaysFromIPPoolNested<A> editGatewaysFromIPPool(int index) {
    if (gatewaysFromIPPool.size() <= index) throw new RuntimeException("Can't edit gatewaysFromIPPool. Index exceeds size.");
    return setNewGatewaysFromIPPoolLike(index, buildGatewaysFromIPPool(index));
  }
  
  public GatewaysFromIPPoolNested<A> editFirstGatewaysFromIPPool() {
    if (gatewaysFromIPPool.size() == 0) throw new RuntimeException("Can't edit first gatewaysFromIPPool. The list is empty.");
    return setNewGatewaysFromIPPoolLike(0, buildGatewaysFromIPPool(0));
  }
  
  public GatewaysFromIPPoolNested<A> editLastGatewaysFromIPPool() {
    int index = gatewaysFromIPPool.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last gatewaysFromIPPool. The list is empty.");
    return setNewGatewaysFromIPPoolLike(index, buildGatewaysFromIPPool(index));
  }
  
  public GatewaysFromIPPoolNested<A> editMatchingGatewaysFromIPPool(Predicate<FromPoolBuilder> predicate) {
    int index = -1;
    for (int i=0;i<gatewaysFromIPPool.size();i++) { 
    if (predicate.test(gatewaysFromIPPool.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching gatewaysFromIPPool. No match found.");
    return setNewGatewaysFromIPPoolLike(index, buildGatewaysFromIPPool(index));
  }
  
  public A addToIndexes(int index,MetaDataIndex item) {
    if (this.indexes == null) {this.indexes = new ArrayList<MetaDataIndexBuilder>();}
    MetaDataIndexBuilder builder = new MetaDataIndexBuilder(item);
    if (index < 0 || index >= indexes.size()) {
        _visitables.get("indexes").add(builder);
        indexes.add(builder);
    } else {
        _visitables.get("indexes").add(builder);
        indexes.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToIndexes(int index,MetaDataIndex item) {
    if (this.indexes == null) {this.indexes = new ArrayList<MetaDataIndexBuilder>();}
    MetaDataIndexBuilder builder = new MetaDataIndexBuilder(item);
    if (index < 0 || index >= indexes.size()) {
        _visitables.get("indexes").add(builder);
        indexes.add(builder);
    } else {
        _visitables.get("indexes").add(builder);
        indexes.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToIndexes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataIndex... items) {
    if (this.indexes == null) {this.indexes = new ArrayList<MetaDataIndexBuilder>();}
    for (MetaDataIndex item : items) {MetaDataIndexBuilder builder = new MetaDataIndexBuilder(item);_visitables.get("indexes").add(builder);this.indexes.add(builder);} return (A)this;
  }
  
  public A addAllToIndexes(Collection<MetaDataIndex> items) {
    if (this.indexes == null) {this.indexes = new ArrayList<MetaDataIndexBuilder>();}
    for (MetaDataIndex item : items) {MetaDataIndexBuilder builder = new MetaDataIndexBuilder(item);_visitables.get("indexes").add(builder);this.indexes.add(builder);} return (A)this;
  }
  
  public A removeFromIndexes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataIndex... items) {
    if (this.indexes == null) return (A)this;
    for (MetaDataIndex item : items) {MetaDataIndexBuilder builder = new MetaDataIndexBuilder(item);_visitables.get("indexes").remove(builder); this.indexes.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIndexes(Collection<MetaDataIndex> items) {
    if (this.indexes == null) return (A)this;
    for (MetaDataIndex item : items) {MetaDataIndexBuilder builder = new MetaDataIndexBuilder(item);_visitables.get("indexes").remove(builder); this.indexes.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIndexes(Predicate<MetaDataIndexBuilder> predicate) {
    if (indexes == null) return (A) this;
    final Iterator<MetaDataIndexBuilder> each = indexes.iterator();
    final List visitables = _visitables.get("indexes");
    while (each.hasNext()) {
      MetaDataIndexBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MetaDataIndex> buildIndexes() {
    return this.indexes != null ? build(indexes) : null;
  }
  
  public MetaDataIndex buildIndex(int index) {
    return this.indexes.get(index).build();
  }
  
  public MetaDataIndex buildFirstIndex() {
    return this.indexes.get(0).build();
  }
  
  public MetaDataIndex buildLastIndex() {
    return this.indexes.get(indexes.size() - 1).build();
  }
  
  public MetaDataIndex buildMatchingIndex(Predicate<MetaDataIndexBuilder> predicate) {
      for (MetaDataIndexBuilder item : indexes) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingIndex(Predicate<MetaDataIndexBuilder> predicate) {
      for (MetaDataIndexBuilder item : indexes) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIndexes(List<MetaDataIndex> indexes) {
    if (this.indexes != null) {
      this._visitables.get("indexes").clear();
    }
    if (indexes != null) {
        this.indexes = new ArrayList();
        for (MetaDataIndex item : indexes) {
          this.addToIndexes(item);
        }
    } else {
      this.indexes = null;
    }
    return (A) this;
  }
  
  public A withIndexes(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataIndex... indexes) {
    if (this.indexes != null) {
        this.indexes.clear();
        _visitables.remove("indexes");
    }
    if (indexes != null) {
      for (MetaDataIndex item : indexes) {
        this.addToIndexes(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIndexes() {
    return this.indexes != null && !this.indexes.isEmpty();
  }
  
  public A addNewIndex(String key,Integer offset,String prefix,Integer step,String suffix) {
    return (A)addToIndexes(new MetaDataIndex(key, offset, prefix, step, suffix));
  }
  
  public IndexesNested<A> addNewIndex() {
    return new IndexesNested(-1, null);
  }
  
  public IndexesNested<A> addNewIndexLike(MetaDataIndex item) {
    return new IndexesNested(-1, item);
  }
  
  public IndexesNested<A> setNewIndexLike(int index,MetaDataIndex item) {
    return new IndexesNested(index, item);
  }
  
  public IndexesNested<A> editIndex(int index) {
    if (indexes.size() <= index) throw new RuntimeException("Can't edit indexes. Index exceeds size.");
    return setNewIndexLike(index, buildIndex(index));
  }
  
  public IndexesNested<A> editFirstIndex() {
    if (indexes.size() == 0) throw new RuntimeException("Can't edit first indexes. The list is empty.");
    return setNewIndexLike(0, buildIndex(0));
  }
  
  public IndexesNested<A> editLastIndex() {
    int index = indexes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last indexes. The list is empty.");
    return setNewIndexLike(index, buildIndex(index));
  }
  
  public IndexesNested<A> editMatchingIndex(Predicate<MetaDataIndexBuilder> predicate) {
    int index = -1;
    for (int i=0;i<indexes.size();i++) { 
    if (predicate.test(indexes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching indexes. No match found.");
    return setNewIndexLike(index, buildIndex(index));
  }
  
  public A addToIpAddressesFromIPPool(int index,FromPool item) {
    if (this.ipAddressesFromIPPool == null) {this.ipAddressesFromIPPool = new ArrayList<FromPoolBuilder>();}
    FromPoolBuilder builder = new FromPoolBuilder(item);
    if (index < 0 || index >= ipAddressesFromIPPool.size()) {
        _visitables.get("ipAddressesFromIPPool").add(builder);
        ipAddressesFromIPPool.add(builder);
    } else {
        _visitables.get("ipAddressesFromIPPool").add(builder);
        ipAddressesFromIPPool.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToIpAddressesFromIPPool(int index,FromPool item) {
    if (this.ipAddressesFromIPPool == null) {this.ipAddressesFromIPPool = new ArrayList<FromPoolBuilder>();}
    FromPoolBuilder builder = new FromPoolBuilder(item);
    if (index < 0 || index >= ipAddressesFromIPPool.size()) {
        _visitables.get("ipAddressesFromIPPool").add(builder);
        ipAddressesFromIPPool.add(builder);
    } else {
        _visitables.get("ipAddressesFromIPPool").add(builder);
        ipAddressesFromIPPool.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToIpAddressesFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... items) {
    if (this.ipAddressesFromIPPool == null) {this.ipAddressesFromIPPool = new ArrayList<FromPoolBuilder>();}
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("ipAddressesFromIPPool").add(builder);this.ipAddressesFromIPPool.add(builder);} return (A)this;
  }
  
  public A addAllToIpAddressesFromIPPool(Collection<FromPool> items) {
    if (this.ipAddressesFromIPPool == null) {this.ipAddressesFromIPPool = new ArrayList<FromPoolBuilder>();}
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("ipAddressesFromIPPool").add(builder);this.ipAddressesFromIPPool.add(builder);} return (A)this;
  }
  
  public A removeFromIpAddressesFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... items) {
    if (this.ipAddressesFromIPPool == null) return (A)this;
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("ipAddressesFromIPPool").remove(builder); this.ipAddressesFromIPPool.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIpAddressesFromIPPool(Collection<FromPool> items) {
    if (this.ipAddressesFromIPPool == null) return (A)this;
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("ipAddressesFromIPPool").remove(builder); this.ipAddressesFromIPPool.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIpAddressesFromIPPool(Predicate<FromPoolBuilder> predicate) {
    if (ipAddressesFromIPPool == null) return (A) this;
    final Iterator<FromPoolBuilder> each = ipAddressesFromIPPool.iterator();
    final List visitables = _visitables.get("ipAddressesFromIPPool");
    while (each.hasNext()) {
      FromPoolBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FromPool> buildIpAddressesFromIPPool() {
    return this.ipAddressesFromIPPool != null ? build(ipAddressesFromIPPool) : null;
  }
  
  public FromPool buildIpAddressesFromIPPool(int index) {
    return this.ipAddressesFromIPPool.get(index).build();
  }
  
  public FromPool buildFirstIpAddressesFromIPPool() {
    return this.ipAddressesFromIPPool.get(0).build();
  }
  
  public FromPool buildLastIpAddressesFromIPPool() {
    return this.ipAddressesFromIPPool.get(ipAddressesFromIPPool.size() - 1).build();
  }
  
  public FromPool buildMatchingIpAddressesFromIPPool(Predicate<FromPoolBuilder> predicate) {
      for (FromPoolBuilder item : ipAddressesFromIPPool) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingIpAddressesFromIPPool(Predicate<FromPoolBuilder> predicate) {
      for (FromPoolBuilder item : ipAddressesFromIPPool) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIpAddressesFromIPPool(List<FromPool> ipAddressesFromIPPool) {
    if (this.ipAddressesFromIPPool != null) {
      this._visitables.get("ipAddressesFromIPPool").clear();
    }
    if (ipAddressesFromIPPool != null) {
        this.ipAddressesFromIPPool = new ArrayList();
        for (FromPool item : ipAddressesFromIPPool) {
          this.addToIpAddressesFromIPPool(item);
        }
    } else {
      this.ipAddressesFromIPPool = null;
    }
    return (A) this;
  }
  
  public A withIpAddressesFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... ipAddressesFromIPPool) {
    if (this.ipAddressesFromIPPool != null) {
        this.ipAddressesFromIPPool.clear();
        _visitables.remove("ipAddressesFromIPPool");
    }
    if (ipAddressesFromIPPool != null) {
      for (FromPool item : ipAddressesFromIPPool) {
        this.addToIpAddressesFromIPPool(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIpAddressesFromIPPool() {
    return this.ipAddressesFromIPPool != null && !this.ipAddressesFromIPPool.isEmpty();
  }
  
  public A addNewIpAddressesFromIPPool(String apiGroup,String key,String kind,String name) {
    return (A)addToIpAddressesFromIPPool(new FromPool(apiGroup, key, kind, name));
  }
  
  public IpAddressesFromIPPoolNested<A> addNewIpAddressesFromIPPool() {
    return new IpAddressesFromIPPoolNested(-1, null);
  }
  
  public IpAddressesFromIPPoolNested<A> addNewIpAddressesFromIPPoolLike(FromPool item) {
    return new IpAddressesFromIPPoolNested(-1, item);
  }
  
  public IpAddressesFromIPPoolNested<A> setNewIpAddressesFromIPPoolLike(int index,FromPool item) {
    return new IpAddressesFromIPPoolNested(index, item);
  }
  
  public IpAddressesFromIPPoolNested<A> editIpAddressesFromIPPool(int index) {
    if (ipAddressesFromIPPool.size() <= index) throw new RuntimeException("Can't edit ipAddressesFromIPPool. Index exceeds size.");
    return setNewIpAddressesFromIPPoolLike(index, buildIpAddressesFromIPPool(index));
  }
  
  public IpAddressesFromIPPoolNested<A> editFirstIpAddressesFromIPPool() {
    if (ipAddressesFromIPPool.size() == 0) throw new RuntimeException("Can't edit first ipAddressesFromIPPool. The list is empty.");
    return setNewIpAddressesFromIPPoolLike(0, buildIpAddressesFromIPPool(0));
  }
  
  public IpAddressesFromIPPoolNested<A> editLastIpAddressesFromIPPool() {
    int index = ipAddressesFromIPPool.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ipAddressesFromIPPool. The list is empty.");
    return setNewIpAddressesFromIPPoolLike(index, buildIpAddressesFromIPPool(index));
  }
  
  public IpAddressesFromIPPoolNested<A> editMatchingIpAddressesFromIPPool(Predicate<FromPoolBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ipAddressesFromIPPool.size();i++) { 
    if (predicate.test(ipAddressesFromIPPool.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ipAddressesFromIPPool. No match found.");
    return setNewIpAddressesFromIPPoolLike(index, buildIpAddressesFromIPPool(index));
  }
  
  public A addToNamespaces(int index,MetaDataNamespace item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<MetaDataNamespaceBuilder>();}
    MetaDataNamespaceBuilder builder = new MetaDataNamespaceBuilder(item);
    if (index < 0 || index >= namespaces.size()) {
        _visitables.get("namespaces").add(builder);
        namespaces.add(builder);
    } else {
        _visitables.get("namespaces").add(builder);
        namespaces.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToNamespaces(int index,MetaDataNamespace item) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<MetaDataNamespaceBuilder>();}
    MetaDataNamespaceBuilder builder = new MetaDataNamespaceBuilder(item);
    if (index < 0 || index >= namespaces.size()) {
        _visitables.get("namespaces").add(builder);
        namespaces.add(builder);
    } else {
        _visitables.get("namespaces").add(builder);
        namespaces.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToNamespaces(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataNamespace... items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<MetaDataNamespaceBuilder>();}
    for (MetaDataNamespace item : items) {MetaDataNamespaceBuilder builder = new MetaDataNamespaceBuilder(item);_visitables.get("namespaces").add(builder);this.namespaces.add(builder);} return (A)this;
  }
  
  public A addAllToNamespaces(Collection<MetaDataNamespace> items) {
    if (this.namespaces == null) {this.namespaces = new ArrayList<MetaDataNamespaceBuilder>();}
    for (MetaDataNamespace item : items) {MetaDataNamespaceBuilder builder = new MetaDataNamespaceBuilder(item);_visitables.get("namespaces").add(builder);this.namespaces.add(builder);} return (A)this;
  }
  
  public A removeFromNamespaces(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataNamespace... items) {
    if (this.namespaces == null) return (A)this;
    for (MetaDataNamespace item : items) {MetaDataNamespaceBuilder builder = new MetaDataNamespaceBuilder(item);_visitables.get("namespaces").remove(builder); this.namespaces.remove(builder);} return (A)this;
  }
  
  public A removeAllFromNamespaces(Collection<MetaDataNamespace> items) {
    if (this.namespaces == null) return (A)this;
    for (MetaDataNamespace item : items) {MetaDataNamespaceBuilder builder = new MetaDataNamespaceBuilder(item);_visitables.get("namespaces").remove(builder); this.namespaces.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromNamespaces(Predicate<MetaDataNamespaceBuilder> predicate) {
    if (namespaces == null) return (A) this;
    final Iterator<MetaDataNamespaceBuilder> each = namespaces.iterator();
    final List visitables = _visitables.get("namespaces");
    while (each.hasNext()) {
      MetaDataNamespaceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MetaDataNamespace> buildNamespaces() {
    return this.namespaces != null ? build(namespaces) : null;
  }
  
  public MetaDataNamespace buildNamespace(int index) {
    return this.namespaces.get(index).build();
  }
  
  public MetaDataNamespace buildFirstNamespace() {
    return this.namespaces.get(0).build();
  }
  
  public MetaDataNamespace buildLastNamespace() {
    return this.namespaces.get(namespaces.size() - 1).build();
  }
  
  public MetaDataNamespace buildMatchingNamespace(Predicate<MetaDataNamespaceBuilder> predicate) {
      for (MetaDataNamespaceBuilder item : namespaces) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingNamespace(Predicate<MetaDataNamespaceBuilder> predicate) {
      for (MetaDataNamespaceBuilder item : namespaces) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withNamespaces(List<MetaDataNamespace> namespaces) {
    if (this.namespaces != null) {
      this._visitables.get("namespaces").clear();
    }
    if (namespaces != null) {
        this.namespaces = new ArrayList();
        for (MetaDataNamespace item : namespaces) {
          this.addToNamespaces(item);
        }
    } else {
      this.namespaces = null;
    }
    return (A) this;
  }
  
  public A withNamespaces(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataNamespace... namespaces) {
    if (this.namespaces != null) {
        this.namespaces.clear();
        _visitables.remove("namespaces");
    }
    if (namespaces != null) {
      for (MetaDataNamespace item : namespaces) {
        this.addToNamespaces(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasNamespaces() {
    return this.namespaces != null && !this.namespaces.isEmpty();
  }
  
  public A addNewNamespace(String key) {
    return (A)addToNamespaces(new MetaDataNamespace(key));
  }
  
  public NamespacesNested<A> addNewNamespace() {
    return new NamespacesNested(-1, null);
  }
  
  public NamespacesNested<A> addNewNamespaceLike(MetaDataNamespace item) {
    return new NamespacesNested(-1, item);
  }
  
  public NamespacesNested<A> setNewNamespaceLike(int index,MetaDataNamespace item) {
    return new NamespacesNested(index, item);
  }
  
  public NamespacesNested<A> editNamespace(int index) {
    if (namespaces.size() <= index) throw new RuntimeException("Can't edit namespaces. Index exceeds size.");
    return setNewNamespaceLike(index, buildNamespace(index));
  }
  
  public NamespacesNested<A> editFirstNamespace() {
    if (namespaces.size() == 0) throw new RuntimeException("Can't edit first namespaces. The list is empty.");
    return setNewNamespaceLike(0, buildNamespace(0));
  }
  
  public NamespacesNested<A> editLastNamespace() {
    int index = namespaces.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last namespaces. The list is empty.");
    return setNewNamespaceLike(index, buildNamespace(index));
  }
  
  public NamespacesNested<A> editMatchingNamespace(Predicate<MetaDataNamespaceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<namespaces.size();i++) { 
    if (predicate.test(namespaces.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching namespaces. No match found.");
    return setNewNamespaceLike(index, buildNamespace(index));
  }
  
  public A addToObjectNames(int index,MetaDataObjectName item) {
    if (this.objectNames == null) {this.objectNames = new ArrayList<MetaDataObjectNameBuilder>();}
    MetaDataObjectNameBuilder builder = new MetaDataObjectNameBuilder(item);
    if (index < 0 || index >= objectNames.size()) {
        _visitables.get("objectNames").add(builder);
        objectNames.add(builder);
    } else {
        _visitables.get("objectNames").add(builder);
        objectNames.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToObjectNames(int index,MetaDataObjectName item) {
    if (this.objectNames == null) {this.objectNames = new ArrayList<MetaDataObjectNameBuilder>();}
    MetaDataObjectNameBuilder builder = new MetaDataObjectNameBuilder(item);
    if (index < 0 || index >= objectNames.size()) {
        _visitables.get("objectNames").add(builder);
        objectNames.add(builder);
    } else {
        _visitables.get("objectNames").add(builder);
        objectNames.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToObjectNames(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataObjectName... items) {
    if (this.objectNames == null) {this.objectNames = new ArrayList<MetaDataObjectNameBuilder>();}
    for (MetaDataObjectName item : items) {MetaDataObjectNameBuilder builder = new MetaDataObjectNameBuilder(item);_visitables.get("objectNames").add(builder);this.objectNames.add(builder);} return (A)this;
  }
  
  public A addAllToObjectNames(Collection<MetaDataObjectName> items) {
    if (this.objectNames == null) {this.objectNames = new ArrayList<MetaDataObjectNameBuilder>();}
    for (MetaDataObjectName item : items) {MetaDataObjectNameBuilder builder = new MetaDataObjectNameBuilder(item);_visitables.get("objectNames").add(builder);this.objectNames.add(builder);} return (A)this;
  }
  
  public A removeFromObjectNames(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataObjectName... items) {
    if (this.objectNames == null) return (A)this;
    for (MetaDataObjectName item : items) {MetaDataObjectNameBuilder builder = new MetaDataObjectNameBuilder(item);_visitables.get("objectNames").remove(builder); this.objectNames.remove(builder);} return (A)this;
  }
  
  public A removeAllFromObjectNames(Collection<MetaDataObjectName> items) {
    if (this.objectNames == null) return (A)this;
    for (MetaDataObjectName item : items) {MetaDataObjectNameBuilder builder = new MetaDataObjectNameBuilder(item);_visitables.get("objectNames").remove(builder); this.objectNames.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromObjectNames(Predicate<MetaDataObjectNameBuilder> predicate) {
    if (objectNames == null) return (A) this;
    final Iterator<MetaDataObjectNameBuilder> each = objectNames.iterator();
    final List visitables = _visitables.get("objectNames");
    while (each.hasNext()) {
      MetaDataObjectNameBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MetaDataObjectName> buildObjectNames() {
    return this.objectNames != null ? build(objectNames) : null;
  }
  
  public MetaDataObjectName buildObjectName(int index) {
    return this.objectNames.get(index).build();
  }
  
  public MetaDataObjectName buildFirstObjectName() {
    return this.objectNames.get(0).build();
  }
  
  public MetaDataObjectName buildLastObjectName() {
    return this.objectNames.get(objectNames.size() - 1).build();
  }
  
  public MetaDataObjectName buildMatchingObjectName(Predicate<MetaDataObjectNameBuilder> predicate) {
      for (MetaDataObjectNameBuilder item : objectNames) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingObjectName(Predicate<MetaDataObjectNameBuilder> predicate) {
      for (MetaDataObjectNameBuilder item : objectNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withObjectNames(List<MetaDataObjectName> objectNames) {
    if (this.objectNames != null) {
      this._visitables.get("objectNames").clear();
    }
    if (objectNames != null) {
        this.objectNames = new ArrayList();
        for (MetaDataObjectName item : objectNames) {
          this.addToObjectNames(item);
        }
    } else {
      this.objectNames = null;
    }
    return (A) this;
  }
  
  public A withObjectNames(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataObjectName... objectNames) {
    if (this.objectNames != null) {
        this.objectNames.clear();
        _visitables.remove("objectNames");
    }
    if (objectNames != null) {
      for (MetaDataObjectName item : objectNames) {
        this.addToObjectNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasObjectNames() {
    return this.objectNames != null && !this.objectNames.isEmpty();
  }
  
  public A addNewObjectName(String key,String object) {
    return (A)addToObjectNames(new MetaDataObjectName(key, object));
  }
  
  public ObjectNamesNested<A> addNewObjectName() {
    return new ObjectNamesNested(-1, null);
  }
  
  public ObjectNamesNested<A> addNewObjectNameLike(MetaDataObjectName item) {
    return new ObjectNamesNested(-1, item);
  }
  
  public ObjectNamesNested<A> setNewObjectNameLike(int index,MetaDataObjectName item) {
    return new ObjectNamesNested(index, item);
  }
  
  public ObjectNamesNested<A> editObjectName(int index) {
    if (objectNames.size() <= index) throw new RuntimeException("Can't edit objectNames. Index exceeds size.");
    return setNewObjectNameLike(index, buildObjectName(index));
  }
  
  public ObjectNamesNested<A> editFirstObjectName() {
    if (objectNames.size() == 0) throw new RuntimeException("Can't edit first objectNames. The list is empty.");
    return setNewObjectNameLike(0, buildObjectName(0));
  }
  
  public ObjectNamesNested<A> editLastObjectName() {
    int index = objectNames.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last objectNames. The list is empty.");
    return setNewObjectNameLike(index, buildObjectName(index));
  }
  
  public ObjectNamesNested<A> editMatchingObjectName(Predicate<MetaDataObjectNameBuilder> predicate) {
    int index = -1;
    for (int i=0;i<objectNames.size();i++) { 
    if (predicate.test(objectNames.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching objectNames. No match found.");
    return setNewObjectNameLike(index, buildObjectName(index));
  }
  
  public A addToPrefixesFromIPPool(int index,FromPool item) {
    if (this.prefixesFromIPPool == null) {this.prefixesFromIPPool = new ArrayList<FromPoolBuilder>();}
    FromPoolBuilder builder = new FromPoolBuilder(item);
    if (index < 0 || index >= prefixesFromIPPool.size()) {
        _visitables.get("prefixesFromIPPool").add(builder);
        prefixesFromIPPool.add(builder);
    } else {
        _visitables.get("prefixesFromIPPool").add(builder);
        prefixesFromIPPool.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToPrefixesFromIPPool(int index,FromPool item) {
    if (this.prefixesFromIPPool == null) {this.prefixesFromIPPool = new ArrayList<FromPoolBuilder>();}
    FromPoolBuilder builder = new FromPoolBuilder(item);
    if (index < 0 || index >= prefixesFromIPPool.size()) {
        _visitables.get("prefixesFromIPPool").add(builder);
        prefixesFromIPPool.add(builder);
    } else {
        _visitables.get("prefixesFromIPPool").add(builder);
        prefixesFromIPPool.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToPrefixesFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... items) {
    if (this.prefixesFromIPPool == null) {this.prefixesFromIPPool = new ArrayList<FromPoolBuilder>();}
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("prefixesFromIPPool").add(builder);this.prefixesFromIPPool.add(builder);} return (A)this;
  }
  
  public A addAllToPrefixesFromIPPool(Collection<FromPool> items) {
    if (this.prefixesFromIPPool == null) {this.prefixesFromIPPool = new ArrayList<FromPoolBuilder>();}
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("prefixesFromIPPool").add(builder);this.prefixesFromIPPool.add(builder);} return (A)this;
  }
  
  public A removeFromPrefixesFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... items) {
    if (this.prefixesFromIPPool == null) return (A)this;
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("prefixesFromIPPool").remove(builder); this.prefixesFromIPPool.remove(builder);} return (A)this;
  }
  
  public A removeAllFromPrefixesFromIPPool(Collection<FromPool> items) {
    if (this.prefixesFromIPPool == null) return (A)this;
    for (FromPool item : items) {FromPoolBuilder builder = new FromPoolBuilder(item);_visitables.get("prefixesFromIPPool").remove(builder); this.prefixesFromIPPool.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromPrefixesFromIPPool(Predicate<FromPoolBuilder> predicate) {
    if (prefixesFromIPPool == null) return (A) this;
    final Iterator<FromPoolBuilder> each = prefixesFromIPPool.iterator();
    final List visitables = _visitables.get("prefixesFromIPPool");
    while (each.hasNext()) {
      FromPoolBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<FromPool> buildPrefixesFromIPPool() {
    return this.prefixesFromIPPool != null ? build(prefixesFromIPPool) : null;
  }
  
  public FromPool buildPrefixesFromIPPool(int index) {
    return this.prefixesFromIPPool.get(index).build();
  }
  
  public FromPool buildFirstPrefixesFromIPPool() {
    return this.prefixesFromIPPool.get(0).build();
  }
  
  public FromPool buildLastPrefixesFromIPPool() {
    return this.prefixesFromIPPool.get(prefixesFromIPPool.size() - 1).build();
  }
  
  public FromPool buildMatchingPrefixesFromIPPool(Predicate<FromPoolBuilder> predicate) {
      for (FromPoolBuilder item : prefixesFromIPPool) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingPrefixesFromIPPool(Predicate<FromPoolBuilder> predicate) {
      for (FromPoolBuilder item : prefixesFromIPPool) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withPrefixesFromIPPool(List<FromPool> prefixesFromIPPool) {
    if (this.prefixesFromIPPool != null) {
      this._visitables.get("prefixesFromIPPool").clear();
    }
    if (prefixesFromIPPool != null) {
        this.prefixesFromIPPool = new ArrayList();
        for (FromPool item : prefixesFromIPPool) {
          this.addToPrefixesFromIPPool(item);
        }
    } else {
      this.prefixesFromIPPool = null;
    }
    return (A) this;
  }
  
  public A withPrefixesFromIPPool(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.FromPool... prefixesFromIPPool) {
    if (this.prefixesFromIPPool != null) {
        this.prefixesFromIPPool.clear();
        _visitables.remove("prefixesFromIPPool");
    }
    if (prefixesFromIPPool != null) {
      for (FromPool item : prefixesFromIPPool) {
        this.addToPrefixesFromIPPool(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasPrefixesFromIPPool() {
    return this.prefixesFromIPPool != null && !this.prefixesFromIPPool.isEmpty();
  }
  
  public A addNewPrefixesFromIPPool(String apiGroup,String key,String kind,String name) {
    return (A)addToPrefixesFromIPPool(new FromPool(apiGroup, key, kind, name));
  }
  
  public PrefixesFromIPPoolNested<A> addNewPrefixesFromIPPool() {
    return new PrefixesFromIPPoolNested(-1, null);
  }
  
  public PrefixesFromIPPoolNested<A> addNewPrefixesFromIPPoolLike(FromPool item) {
    return new PrefixesFromIPPoolNested(-1, item);
  }
  
  public PrefixesFromIPPoolNested<A> setNewPrefixesFromIPPoolLike(int index,FromPool item) {
    return new PrefixesFromIPPoolNested(index, item);
  }
  
  public PrefixesFromIPPoolNested<A> editPrefixesFromIPPool(int index) {
    if (prefixesFromIPPool.size() <= index) throw new RuntimeException("Can't edit prefixesFromIPPool. Index exceeds size.");
    return setNewPrefixesFromIPPoolLike(index, buildPrefixesFromIPPool(index));
  }
  
  public PrefixesFromIPPoolNested<A> editFirstPrefixesFromIPPool() {
    if (prefixesFromIPPool.size() == 0) throw new RuntimeException("Can't edit first prefixesFromIPPool. The list is empty.");
    return setNewPrefixesFromIPPoolLike(0, buildPrefixesFromIPPool(0));
  }
  
  public PrefixesFromIPPoolNested<A> editLastPrefixesFromIPPool() {
    int index = prefixesFromIPPool.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last prefixesFromIPPool. The list is empty.");
    return setNewPrefixesFromIPPoolLike(index, buildPrefixesFromIPPool(index));
  }
  
  public PrefixesFromIPPoolNested<A> editMatchingPrefixesFromIPPool(Predicate<FromPoolBuilder> predicate) {
    int index = -1;
    for (int i=0;i<prefixesFromIPPool.size();i++) { 
    if (predicate.test(prefixesFromIPPool.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching prefixesFromIPPool. No match found.");
    return setNewPrefixesFromIPPoolLike(index, buildPrefixesFromIPPool(index));
  }
  
  public A addToStrings(int index,MetaDataString item) {
    if (this.strings == null) {this.strings = new ArrayList<MetaDataStringBuilder>();}
    MetaDataStringBuilder builder = new MetaDataStringBuilder(item);
    if (index < 0 || index >= strings.size()) {
        _visitables.get("strings").add(builder);
        strings.add(builder);
    } else {
        _visitables.get("strings").add(builder);
        strings.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToStrings(int index,MetaDataString item) {
    if (this.strings == null) {this.strings = new ArrayList<MetaDataStringBuilder>();}
    MetaDataStringBuilder builder = new MetaDataStringBuilder(item);
    if (index < 0 || index >= strings.size()) {
        _visitables.get("strings").add(builder);
        strings.add(builder);
    } else {
        _visitables.get("strings").add(builder);
        strings.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToStrings(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataString... items) {
    if (this.strings == null) {this.strings = new ArrayList<MetaDataStringBuilder>();}
    for (MetaDataString item : items) {MetaDataStringBuilder builder = new MetaDataStringBuilder(item);_visitables.get("strings").add(builder);this.strings.add(builder);} return (A)this;
  }
  
  public A addAllToStrings(Collection<MetaDataString> items) {
    if (this.strings == null) {this.strings = new ArrayList<MetaDataStringBuilder>();}
    for (MetaDataString item : items) {MetaDataStringBuilder builder = new MetaDataStringBuilder(item);_visitables.get("strings").add(builder);this.strings.add(builder);} return (A)this;
  }
  
  public A removeFromStrings(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataString... items) {
    if (this.strings == null) return (A)this;
    for (MetaDataString item : items) {MetaDataStringBuilder builder = new MetaDataStringBuilder(item);_visitables.get("strings").remove(builder); this.strings.remove(builder);} return (A)this;
  }
  
  public A removeAllFromStrings(Collection<MetaDataString> items) {
    if (this.strings == null) return (A)this;
    for (MetaDataString item : items) {MetaDataStringBuilder builder = new MetaDataStringBuilder(item);_visitables.get("strings").remove(builder); this.strings.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromStrings(Predicate<MetaDataStringBuilder> predicate) {
    if (strings == null) return (A) this;
    final Iterator<MetaDataStringBuilder> each = strings.iterator();
    final List visitables = _visitables.get("strings");
    while (each.hasNext()) {
      MetaDataStringBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MetaDataString> buildStrings() {
    return this.strings != null ? build(strings) : null;
  }
  
  public MetaDataString buildString(int index) {
    return this.strings.get(index).build();
  }
  
  public MetaDataString buildFirstString() {
    return this.strings.get(0).build();
  }
  
  public MetaDataString buildLastString() {
    return this.strings.get(strings.size() - 1).build();
  }
  
  public MetaDataString buildMatchingString(Predicate<MetaDataStringBuilder> predicate) {
      for (MetaDataStringBuilder item : strings) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingString(Predicate<MetaDataStringBuilder> predicate) {
      for (MetaDataStringBuilder item : strings) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withStrings(List<MetaDataString> strings) {
    if (this.strings != null) {
      this._visitables.get("strings").clear();
    }
    if (strings != null) {
        this.strings = new ArrayList();
        for (MetaDataString item : strings) {
          this.addToStrings(item);
        }
    } else {
      this.strings = null;
    }
    return (A) this;
  }
  
  public A withStrings(io.fabric8.openshift.api.model.miscellaneous.metal3.v1beta1.MetaDataString... strings) {
    if (this.strings != null) {
        this.strings.clear();
        _visitables.remove("strings");
    }
    if (strings != null) {
      for (MetaDataString item : strings) {
        this.addToStrings(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasStrings() {
    return this.strings != null && !this.strings.isEmpty();
  }
  
  public A addNewString(String key,String value) {
    return (A)addToStrings(new MetaDataString(key, value));
  }
  
  public StringsNested<A> addNewString() {
    return new StringsNested(-1, null);
  }
  
  public StringsNested<A> addNewStringLike(MetaDataString item) {
    return new StringsNested(-1, item);
  }
  
  public StringsNested<A> setNewStringLike(int index,MetaDataString item) {
    return new StringsNested(index, item);
  }
  
  public StringsNested<A> editString(int index) {
    if (strings.size() <= index) throw new RuntimeException("Can't edit strings. Index exceeds size.");
    return setNewStringLike(index, buildString(index));
  }
  
  public StringsNested<A> editFirstString() {
    if (strings.size() == 0) throw new RuntimeException("Can't edit first strings. The list is empty.");
    return setNewStringLike(0, buildString(0));
  }
  
  public StringsNested<A> editLastString() {
    int index = strings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last strings. The list is empty.");
    return setNewStringLike(index, buildString(index));
  }
  
  public StringsNested<A> editMatchingString(Predicate<MetaDataStringBuilder> predicate) {
    int index = -1;
    for (int i=0;i<strings.size();i++) { 
    if (predicate.test(strings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching strings. No match found.");
    return setNewStringLike(index, buildString(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetaDataFluent that = (MetaDataFluent) o;
    if (!java.util.Objects.equals(dnsServersFromIPPool, that.dnsServersFromIPPool)) return false;
    if (!java.util.Objects.equals(fromAnnotations, that.fromAnnotations)) return false;
    if (!java.util.Objects.equals(fromHostInterfaces, that.fromHostInterfaces)) return false;
    if (!java.util.Objects.equals(fromLabels, that.fromLabels)) return false;
    if (!java.util.Objects.equals(gatewaysFromIPPool, that.gatewaysFromIPPool)) return false;
    if (!java.util.Objects.equals(indexes, that.indexes)) return false;
    if (!java.util.Objects.equals(ipAddressesFromIPPool, that.ipAddressesFromIPPool)) return false;
    if (!java.util.Objects.equals(namespaces, that.namespaces)) return false;
    if (!java.util.Objects.equals(objectNames, that.objectNames)) return false;
    if (!java.util.Objects.equals(prefixesFromIPPool, that.prefixesFromIPPool)) return false;
    if (!java.util.Objects.equals(strings, that.strings)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(dnsServersFromIPPool,  fromAnnotations,  fromHostInterfaces,  fromLabels,  gatewaysFromIPPool,  indexes,  ipAddressesFromIPPool,  namespaces,  objectNames,  prefixesFromIPPool,  strings,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dnsServersFromIPPool != null && !dnsServersFromIPPool.isEmpty()) { sb.append("dnsServersFromIPPool:"); sb.append(dnsServersFromIPPool + ","); }
    if (fromAnnotations != null && !fromAnnotations.isEmpty()) { sb.append("fromAnnotations:"); sb.append(fromAnnotations + ","); }
    if (fromHostInterfaces != null && !fromHostInterfaces.isEmpty()) { sb.append("fromHostInterfaces:"); sb.append(fromHostInterfaces + ","); }
    if (fromLabels != null && !fromLabels.isEmpty()) { sb.append("fromLabels:"); sb.append(fromLabels + ","); }
    if (gatewaysFromIPPool != null && !gatewaysFromIPPool.isEmpty()) { sb.append("gatewaysFromIPPool:"); sb.append(gatewaysFromIPPool + ","); }
    if (indexes != null && !indexes.isEmpty()) { sb.append("indexes:"); sb.append(indexes + ","); }
    if (ipAddressesFromIPPool != null && !ipAddressesFromIPPool.isEmpty()) { sb.append("ipAddressesFromIPPool:"); sb.append(ipAddressesFromIPPool + ","); }
    if (namespaces != null && !namespaces.isEmpty()) { sb.append("namespaces:"); sb.append(namespaces + ","); }
    if (objectNames != null && !objectNames.isEmpty()) { sb.append("objectNames:"); sb.append(objectNames + ","); }
    if (prefixesFromIPPool != null && !prefixesFromIPPool.isEmpty()) { sb.append("prefixesFromIPPool:"); sb.append(prefixesFromIPPool + ","); }
    if (strings != null && !strings.isEmpty()) { sb.append("strings:"); sb.append(strings + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DnsServersFromIPPoolNested<N> extends FromPoolFluent<DnsServersFromIPPoolNested<N>> implements Nested<N>{
    DnsServersFromIPPoolNested(int index,FromPool item) {
      this.index = index;
      this.builder = new FromPoolBuilder(this, item);
    }
    FromPoolBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToDnsServersFromIPPool(index,builder.build());
    }
    
    public N endDnsServersFromIPPool() {
      return and();
    }
    
  
  }
  public class FromAnnotationsNested<N> extends MetaDataFromAnnotationFluent<FromAnnotationsNested<N>> implements Nested<N>{
    FromAnnotationsNested(int index,MetaDataFromAnnotation item) {
      this.index = index;
      this.builder = new MetaDataFromAnnotationBuilder(this, item);
    }
    MetaDataFromAnnotationBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToFromAnnotations(index,builder.build());
    }
    
    public N endFromAnnotation() {
      return and();
    }
    
  
  }
  public class FromHostInterfacesNested<N> extends MetaDataHostInterfaceFluent<FromHostInterfacesNested<N>> implements Nested<N>{
    FromHostInterfacesNested(int index,MetaDataHostInterface item) {
      this.index = index;
      this.builder = new MetaDataHostInterfaceBuilder(this, item);
    }
    MetaDataHostInterfaceBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToFromHostInterfaces(index,builder.build());
    }
    
    public N endFromHostInterface() {
      return and();
    }
    
  
  }
  public class FromLabelsNested<N> extends MetaDataFromLabelFluent<FromLabelsNested<N>> implements Nested<N>{
    FromLabelsNested(int index,MetaDataFromLabel item) {
      this.index = index;
      this.builder = new MetaDataFromLabelBuilder(this, item);
    }
    MetaDataFromLabelBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToFromLabels(index,builder.build());
    }
    
    public N endFromLabel() {
      return and();
    }
    
  
  }
  public class GatewaysFromIPPoolNested<N> extends FromPoolFluent<GatewaysFromIPPoolNested<N>> implements Nested<N>{
    GatewaysFromIPPoolNested(int index,FromPool item) {
      this.index = index;
      this.builder = new FromPoolBuilder(this, item);
    }
    FromPoolBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToGatewaysFromIPPool(index,builder.build());
    }
    
    public N endGatewaysFromIPPool() {
      return and();
    }
    
  
  }
  public class IndexesNested<N> extends MetaDataIndexFluent<IndexesNested<N>> implements Nested<N>{
    IndexesNested(int index,MetaDataIndex item) {
      this.index = index;
      this.builder = new MetaDataIndexBuilder(this, item);
    }
    MetaDataIndexBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToIndexes(index,builder.build());
    }
    
    public N endIndex() {
      return and();
    }
    
  
  }
  public class IpAddressesFromIPPoolNested<N> extends FromPoolFluent<IpAddressesFromIPPoolNested<N>> implements Nested<N>{
    IpAddressesFromIPPoolNested(int index,FromPool item) {
      this.index = index;
      this.builder = new FromPoolBuilder(this, item);
    }
    FromPoolBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToIpAddressesFromIPPool(index,builder.build());
    }
    
    public N endIpAddressesFromIPPool() {
      return and();
    }
    
  
  }
  public class NamespacesNested<N> extends MetaDataNamespaceFluent<NamespacesNested<N>> implements Nested<N>{
    NamespacesNested(int index,MetaDataNamespace item) {
      this.index = index;
      this.builder = new MetaDataNamespaceBuilder(this, item);
    }
    MetaDataNamespaceBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToNamespaces(index,builder.build());
    }
    
    public N endNamespace() {
      return and();
    }
    
  
  }
  public class ObjectNamesNested<N> extends MetaDataObjectNameFluent<ObjectNamesNested<N>> implements Nested<N>{
    ObjectNamesNested(int index,MetaDataObjectName item) {
      this.index = index;
      this.builder = new MetaDataObjectNameBuilder(this, item);
    }
    MetaDataObjectNameBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToObjectNames(index,builder.build());
    }
    
    public N endObjectName() {
      return and();
    }
    
  
  }
  public class PrefixesFromIPPoolNested<N> extends FromPoolFluent<PrefixesFromIPPoolNested<N>> implements Nested<N>{
    PrefixesFromIPPoolNested(int index,FromPool item) {
      this.index = index;
      this.builder = new FromPoolBuilder(this, item);
    }
    FromPoolBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToPrefixesFromIPPool(index,builder.build());
    }
    
    public N endPrefixesFromIPPool() {
      return and();
    }
    
  
  }
  public class StringsNested<N> extends MetaDataStringFluent<StringsNested<N>> implements Nested<N>{
    StringsNested(int index,MetaDataString item) {
      this.index = index;
      this.builder = new MetaDataStringBuilder(this, item);
    }
    MetaDataStringBuilder builder;
    int index;
    
    public N and() {
      return (N) MetaDataFluent.this.setToStrings(index,builder.build());
    }
    
    public N endString() {
      return and();
    }
    
  
  }

}