package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SettingSchemaFluent<A extends SettingSchemaFluent<A>> extends BaseFluent<A>{
  public SettingSchemaFluent() {
  }
  
  public SettingSchemaFluent(SettingSchema instance) {
    this.copyInstance(instance);
  }
  private List<String> allowableValues = new ArrayList<String>();
  private String attributeType;
  private Integer lowerBound;
  private Integer maxLength;
  private Integer minLength;
  private Boolean readOnly;
  private Boolean unique;
  private Integer upperBound;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SettingSchema instance) {
    instance = (instance != null ? instance : new SettingSchema());
    if (instance != null) {
          this.withAllowableValues(instance.getAllowableValues());
          this.withAttributeType(instance.getAttributeType());
          this.withLowerBound(instance.getLowerBound());
          this.withMaxLength(instance.getMaxLength());
          this.withMinLength(instance.getMinLength());
          this.withReadOnly(instance.getReadOnly());
          this.withUnique(instance.getUnique());
          this.withUpperBound(instance.getUpperBound());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAllowableValues(int index,String item) {
    if (this.allowableValues == null) {this.allowableValues = new ArrayList<String>();}
    this.allowableValues.add(index, item);
    return (A)this;
  }
  
  public A setToAllowableValues(int index,String item) {
    if (this.allowableValues == null) {this.allowableValues = new ArrayList<String>();}
    this.allowableValues.set(index, item); return (A)this;
  }
  
  public A addToAllowableValues(java.lang.String... items) {
    if (this.allowableValues == null) {this.allowableValues = new ArrayList<String>();}
    for (String item : items) {this.allowableValues.add(item);} return (A)this;
  }
  
  public A addAllToAllowableValues(Collection<String> items) {
    if (this.allowableValues == null) {this.allowableValues = new ArrayList<String>();}
    for (String item : items) {this.allowableValues.add(item);} return (A)this;
  }
  
  public A removeFromAllowableValues(java.lang.String... items) {
    if (this.allowableValues == null) return (A)this;
    for (String item : items) { this.allowableValues.remove(item);} return (A)this;
  }
  
  public A removeAllFromAllowableValues(Collection<String> items) {
    if (this.allowableValues == null) return (A)this;
    for (String item : items) { this.allowableValues.remove(item);} return (A)this;
  }
  
  public List<String> getAllowableValues() {
    return this.allowableValues;
  }
  
  public String getAllowableValue(int index) {
    return this.allowableValues.get(index);
  }
  
  public String getFirstAllowableValue() {
    return this.allowableValues.get(0);
  }
  
  public String getLastAllowableValue() {
    return this.allowableValues.get(allowableValues.size() - 1);
  }
  
  public String getMatchingAllowableValue(Predicate<String> predicate) {
      for (String item : allowableValues) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAllowableValue(Predicate<String> predicate) {
      for (String item : allowableValues) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAllowableValues(List<String> allowableValues) {
    if (allowableValues != null) {
        this.allowableValues = new ArrayList();
        for (String item : allowableValues) {
          this.addToAllowableValues(item);
        }
    } else {
      this.allowableValues = null;
    }
    return (A) this;
  }
  
  public A withAllowableValues(java.lang.String... allowableValues) {
    if (this.allowableValues != null) {
        this.allowableValues.clear();
        _visitables.remove("allowableValues");
    }
    if (allowableValues != null) {
      for (String item : allowableValues) {
        this.addToAllowableValues(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAllowableValues() {
    return this.allowableValues != null && !this.allowableValues.isEmpty();
  }
  
  public String getAttributeType() {
    return this.attributeType;
  }
  
  public A withAttributeType(String attributeType) {
    this.attributeType = attributeType;
    return (A) this;
  }
  
  public boolean hasAttributeType() {
    return this.attributeType != null;
  }
  
  public Integer getLowerBound() {
    return this.lowerBound;
  }
  
  public A withLowerBound(Integer lowerBound) {
    this.lowerBound = lowerBound;
    return (A) this;
  }
  
  public boolean hasLowerBound() {
    return this.lowerBound != null;
  }
  
  public Integer getMaxLength() {
    return this.maxLength;
  }
  
  public A withMaxLength(Integer maxLength) {
    this.maxLength = maxLength;
    return (A) this;
  }
  
  public boolean hasMaxLength() {
    return this.maxLength != null;
  }
  
  public Integer getMinLength() {
    return this.minLength;
  }
  
  public A withMinLength(Integer minLength) {
    this.minLength = minLength;
    return (A) this;
  }
  
  public boolean hasMinLength() {
    return this.minLength != null;
  }
  
  public Boolean getReadOnly() {
    return this.readOnly;
  }
  
  public A withReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
    return (A) this;
  }
  
  public boolean hasReadOnly() {
    return this.readOnly != null;
  }
  
  public Boolean getUnique() {
    return this.unique;
  }
  
  public A withUnique(Boolean unique) {
    this.unique = unique;
    return (A) this;
  }
  
  public boolean hasUnique() {
    return this.unique != null;
  }
  
  public Integer getUpperBound() {
    return this.upperBound;
  }
  
  public A withUpperBound(Integer upperBound) {
    this.upperBound = upperBound;
    return (A) this;
  }
  
  public boolean hasUpperBound() {
    return this.upperBound != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SettingSchemaFluent that = (SettingSchemaFluent) o;
    if (!java.util.Objects.equals(allowableValues, that.allowableValues)) return false;
    if (!java.util.Objects.equals(attributeType, that.attributeType)) return false;
    if (!java.util.Objects.equals(lowerBound, that.lowerBound)) return false;
    if (!java.util.Objects.equals(maxLength, that.maxLength)) return false;
    if (!java.util.Objects.equals(minLength, that.minLength)) return false;
    if (!java.util.Objects.equals(readOnly, that.readOnly)) return false;
    if (!java.util.Objects.equals(unique, that.unique)) return false;
    if (!java.util.Objects.equals(upperBound, that.upperBound)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allowableValues,  attributeType,  lowerBound,  maxLength,  minLength,  readOnly,  unique,  upperBound,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowableValues != null && !allowableValues.isEmpty()) { sb.append("allowableValues:"); sb.append(allowableValues + ","); }
    if (attributeType != null) { sb.append("attributeType:"); sb.append(attributeType + ","); }
    if (lowerBound != null) { sb.append("lowerBound:"); sb.append(lowerBound + ","); }
    if (maxLength != null) { sb.append("maxLength:"); sb.append(maxLength + ","); }
    if (minLength != null) { sb.append("minLength:"); sb.append(minLength + ","); }
    if (readOnly != null) { sb.append("readOnly:"); sb.append(readOnly + ","); }
    if (unique != null) { sb.append("unique:"); sb.append(unique + ","); }
    if (upperBound != null) { sb.append("upperBound:"); sb.append(upperBound + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReadOnly() {
    return withReadOnly(true);
  }
  
  public A withUnique() {
    return withUnique(true);
  }
  

}