package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.model.SecretReference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BMCEventSubscriptionSpecFluent<A extends BMCEventSubscriptionSpecFluent<A>> extends BaseFluent<A>{
  public BMCEventSubscriptionSpecFluent() {
  }
  
  public BMCEventSubscriptionSpecFluent(BMCEventSubscriptionSpec instance) {
    this.copyInstance(instance);
  }
  private String context;
  private String destination;
  private String hostName;
  private SecretReference httpHeadersRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BMCEventSubscriptionSpec instance) {
    instance = (instance != null ? instance : new BMCEventSubscriptionSpec());
    if (instance != null) {
          this.withContext(instance.getContext());
          this.withDestination(instance.getDestination());
          this.withHostName(instance.getHostName());
          this.withHttpHeadersRef(instance.getHttpHeadersRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getContext() {
    return this.context;
  }
  
  public A withContext(String context) {
    this.context = context;
    return (A) this;
  }
  
  public boolean hasContext() {
    return this.context != null;
  }
  
  public String getDestination() {
    return this.destination;
  }
  
  public A withDestination(String destination) {
    this.destination = destination;
    return (A) this;
  }
  
  public boolean hasDestination() {
    return this.destination != null;
  }
  
  public String getHostName() {
    return this.hostName;
  }
  
  public A withHostName(String hostName) {
    this.hostName = hostName;
    return (A) this;
  }
  
  public boolean hasHostName() {
    return this.hostName != null;
  }
  
  public SecretReference getHttpHeadersRef() {
    return this.httpHeadersRef;
  }
  
  public A withHttpHeadersRef(SecretReference httpHeadersRef) {
    this.httpHeadersRef = httpHeadersRef;
    return (A) this;
  }
  
  public boolean hasHttpHeadersRef() {
    return this.httpHeadersRef != null;
  }
  
  public A withNewHttpHeadersRef(String name,String namespace) {
    return (A)withHttpHeadersRef(new SecretReference(name, namespace));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BMCEventSubscriptionSpecFluent that = (BMCEventSubscriptionSpecFluent) o;
    if (!java.util.Objects.equals(context, that.context)) return false;
    if (!java.util.Objects.equals(destination, that.destination)) return false;
    if (!java.util.Objects.equals(hostName, that.hostName)) return false;
    if (!java.util.Objects.equals(httpHeadersRef, that.httpHeadersRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(context,  destination,  hostName,  httpHeadersRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (context != null) { sb.append("context:"); sb.append(context + ","); }
    if (destination != null) { sb.append("destination:"); sb.append(destination + ","); }
    if (hostName != null) { sb.append("hostName:"); sb.append(hostName + ","); }
    if (httpHeadersRef != null) { sb.append("httpHeadersRef:"); sb.append(httpHeadersRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}