package io.fabric8.openshift.api.model.miscellaneous.cloudcredential.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CredentialsRequestSpecFluent<A extends CredentialsRequestSpecFluent<A>> extends BaseFluent<A>{
  public CredentialsRequestSpecFluent() {
  }
  
  public CredentialsRequestSpecFluent(CredentialsRequestSpec instance) {
    this.copyInstance(instance);
  }
  private String cloudTokenPath;
  private Object providerSpec;
  private ObjectReferenceBuilder secretRef;
  private List<String> serviceAccountNames = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CredentialsRequestSpec instance) {
    instance = (instance != null ? instance : new CredentialsRequestSpec());
    if (instance != null) {
          this.withCloudTokenPath(instance.getCloudTokenPath());
          this.withProviderSpec(instance.getProviderSpec());
          this.withSecretRef(instance.getSecretRef());
          this.withServiceAccountNames(instance.getServiceAccountNames());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCloudTokenPath() {
    return this.cloudTokenPath;
  }
  
  public A withCloudTokenPath(String cloudTokenPath) {
    this.cloudTokenPath = cloudTokenPath;
    return (A) this;
  }
  
  public boolean hasCloudTokenPath() {
    return this.cloudTokenPath != null;
  }
  
  public Object getProviderSpec() {
    return this.providerSpec;
  }
  
  public A withProviderSpec(Object providerSpec) {
    this.providerSpec = providerSpec;
    return (A) this;
  }
  
  public boolean hasProviderSpec() {
    return this.providerSpec != null;
  }
  
  public ObjectReference buildSecretRef() {
    return this.secretRef != null ? this.secretRef.build() : null;
  }
  
  public A withSecretRef(ObjectReference secretRef) {
    this._visitables.remove("secretRef");
    if (secretRef != null) {
        this.secretRef = new ObjectReferenceBuilder(secretRef);
        this._visitables.get("secretRef").add(this.secretRef);
    } else {
        this.secretRef = null;
        this._visitables.get("secretRef").remove(this.secretRef);
    }
    return (A) this;
  }
  
  public boolean hasSecretRef() {
    return this.secretRef != null;
  }
  
  public SecretRefNested<A> withNewSecretRef() {
    return new SecretRefNested(null);
  }
  
  public SecretRefNested<A> withNewSecretRefLike(ObjectReference item) {
    return new SecretRefNested(item);
  }
  
  public SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(null));
  }
  
  public SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public SecretRefNested<A> editOrNewSecretRefLike(ObjectReference item) {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(item));
  }
  
  public A addToServiceAccountNames(int index,String item) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    this.serviceAccountNames.add(index, item);
    return (A)this;
  }
  
  public A setToServiceAccountNames(int index,String item) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    this.serviceAccountNames.set(index, item); return (A)this;
  }
  
  public A addToServiceAccountNames(java.lang.String... items) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    for (String item : items) {this.serviceAccountNames.add(item);} return (A)this;
  }
  
  public A addAllToServiceAccountNames(Collection<String> items) {
    if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
    for (String item : items) {this.serviceAccountNames.add(item);} return (A)this;
  }
  
  public A removeFromServiceAccountNames(java.lang.String... items) {
    if (this.serviceAccountNames == null) return (A)this;
    for (String item : items) { this.serviceAccountNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromServiceAccountNames(Collection<String> items) {
    if (this.serviceAccountNames == null) return (A)this;
    for (String item : items) { this.serviceAccountNames.remove(item);} return (A)this;
  }
  
  public List<String> getServiceAccountNames() {
    return this.serviceAccountNames;
  }
  
  public String getServiceAccountName(int index) {
    return this.serviceAccountNames.get(index);
  }
  
  public String getFirstServiceAccountName() {
    return this.serviceAccountNames.get(0);
  }
  
  public String getLastServiceAccountName() {
    return this.serviceAccountNames.get(serviceAccountNames.size() - 1);
  }
  
  public String getMatchingServiceAccountName(Predicate<String> predicate) {
      for (String item : serviceAccountNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingServiceAccountName(Predicate<String> predicate) {
      for (String item : serviceAccountNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withServiceAccountNames(List<String> serviceAccountNames) {
    if (serviceAccountNames != null) {
        this.serviceAccountNames = new ArrayList();
        for (String item : serviceAccountNames) {
          this.addToServiceAccountNames(item);
        }
    } else {
      this.serviceAccountNames = null;
    }
    return (A) this;
  }
  
  public A withServiceAccountNames(java.lang.String... serviceAccountNames) {
    if (this.serviceAccountNames != null) {
        this.serviceAccountNames.clear();
        _visitables.remove("serviceAccountNames");
    }
    if (serviceAccountNames != null) {
      for (String item : serviceAccountNames) {
        this.addToServiceAccountNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasServiceAccountNames() {
    return this.serviceAccountNames != null && !this.serviceAccountNames.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CredentialsRequestSpecFluent that = (CredentialsRequestSpecFluent) o;
    if (!java.util.Objects.equals(cloudTokenPath, that.cloudTokenPath)) return false;
    if (!java.util.Objects.equals(providerSpec, that.providerSpec)) return false;
    if (!java.util.Objects.equals(secretRef, that.secretRef)) return false;
    if (!java.util.Objects.equals(serviceAccountNames, that.serviceAccountNames)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cloudTokenPath,  providerSpec,  secretRef,  serviceAccountNames,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cloudTokenPath != null) { sb.append("cloudTokenPath:"); sb.append(cloudTokenPath + ","); }
    if (providerSpec != null) { sb.append("providerSpec:"); sb.append(providerSpec + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (serviceAccountNames != null && !serviceAccountNames.isEmpty()) { sb.append("serviceAccountNames:"); sb.append(serviceAccountNames + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class SecretRefNested<N> extends ObjectReferenceFluent<SecretRefNested<N>> implements Nested<N>{
    SecretRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) CredentialsRequestSpecFluent.this.withSecretRef(builder.build());
    }
    
    public N endSecretRef() {
      return and();
    }
    
  
  }

}