package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PerUserAPIRequestCountFluent<A extends PerUserAPIRequestCountFluent<A>> extends BaseFluent<A>{
  public PerUserAPIRequestCountFluent() {
  }
  
  public PerUserAPIRequestCountFluent(PerUserAPIRequestCount instance) {
    this.copyInstance(instance);
  }
  private ArrayList<PerVerbAPIRequestCountBuilder> byVerb = new ArrayList<PerVerbAPIRequestCountBuilder>();
  private Long requestCount;
  private String userAgent;
  private String username;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PerUserAPIRequestCount instance) {
    instance = (instance != null ? instance : new PerUserAPIRequestCount());
    if (instance != null) {
          this.withByVerb(instance.getByVerb());
          this.withRequestCount(instance.getRequestCount());
          this.withUserAgent(instance.getUserAgent());
          this.withUsername(instance.getUsername());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToByVerb(int index,PerVerbAPIRequestCount item) {
    if (this.byVerb == null) {this.byVerb = new ArrayList<PerVerbAPIRequestCountBuilder>();}
    PerVerbAPIRequestCountBuilder builder = new PerVerbAPIRequestCountBuilder(item);
    if (index < 0 || index >= byVerb.size()) {
        _visitables.get("byVerb").add(builder);
        byVerb.add(builder);
    } else {
        _visitables.get("byVerb").add(builder);
        byVerb.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToByVerb(int index,PerVerbAPIRequestCount item) {
    if (this.byVerb == null) {this.byVerb = new ArrayList<PerVerbAPIRequestCountBuilder>();}
    PerVerbAPIRequestCountBuilder builder = new PerVerbAPIRequestCountBuilder(item);
    if (index < 0 || index >= byVerb.size()) {
        _visitables.get("byVerb").add(builder);
        byVerb.add(builder);
    } else {
        _visitables.get("byVerb").add(builder);
        byVerb.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToByVerb(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerVerbAPIRequestCount... items) {
    if (this.byVerb == null) {this.byVerb = new ArrayList<PerVerbAPIRequestCountBuilder>();}
    for (PerVerbAPIRequestCount item : items) {PerVerbAPIRequestCountBuilder builder = new PerVerbAPIRequestCountBuilder(item);_visitables.get("byVerb").add(builder);this.byVerb.add(builder);} return (A)this;
  }
  
  public A addAllToByVerb(Collection<PerVerbAPIRequestCount> items) {
    if (this.byVerb == null) {this.byVerb = new ArrayList<PerVerbAPIRequestCountBuilder>();}
    for (PerVerbAPIRequestCount item : items) {PerVerbAPIRequestCountBuilder builder = new PerVerbAPIRequestCountBuilder(item);_visitables.get("byVerb").add(builder);this.byVerb.add(builder);} return (A)this;
  }
  
  public A removeFromByVerb(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerVerbAPIRequestCount... items) {
    if (this.byVerb == null) return (A)this;
    for (PerVerbAPIRequestCount item : items) {PerVerbAPIRequestCountBuilder builder = new PerVerbAPIRequestCountBuilder(item);_visitables.get("byVerb").remove(builder); this.byVerb.remove(builder);} return (A)this;
  }
  
  public A removeAllFromByVerb(Collection<PerVerbAPIRequestCount> items) {
    if (this.byVerb == null) return (A)this;
    for (PerVerbAPIRequestCount item : items) {PerVerbAPIRequestCountBuilder builder = new PerVerbAPIRequestCountBuilder(item);_visitables.get("byVerb").remove(builder); this.byVerb.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromByVerb(Predicate<PerVerbAPIRequestCountBuilder> predicate) {
    if (byVerb == null) return (A) this;
    final Iterator<PerVerbAPIRequestCountBuilder> each = byVerb.iterator();
    final List visitables = _visitables.get("byVerb");
    while (each.hasNext()) {
      PerVerbAPIRequestCountBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PerVerbAPIRequestCount> buildByVerb() {
    return this.byVerb != null ? build(byVerb) : null;
  }
  
  public PerVerbAPIRequestCount buildByVerb(int index) {
    return this.byVerb.get(index).build();
  }
  
  public PerVerbAPIRequestCount buildFirstByVerb() {
    return this.byVerb.get(0).build();
  }
  
  public PerVerbAPIRequestCount buildLastByVerb() {
    return this.byVerb.get(byVerb.size() - 1).build();
  }
  
  public PerVerbAPIRequestCount buildMatchingByVerb(Predicate<PerVerbAPIRequestCountBuilder> predicate) {
      for (PerVerbAPIRequestCountBuilder item : byVerb) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingByVerb(Predicate<PerVerbAPIRequestCountBuilder> predicate) {
      for (PerVerbAPIRequestCountBuilder item : byVerb) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withByVerb(List<PerVerbAPIRequestCount> byVerb) {
    if (this.byVerb != null) {
      this._visitables.get("byVerb").clear();
    }
    if (byVerb != null) {
        this.byVerb = new ArrayList();
        for (PerVerbAPIRequestCount item : byVerb) {
          this.addToByVerb(item);
        }
    } else {
      this.byVerb = null;
    }
    return (A) this;
  }
  
  public A withByVerb(io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.PerVerbAPIRequestCount... byVerb) {
    if (this.byVerb != null) {
        this.byVerb.clear();
        _visitables.remove("byVerb");
    }
    if (byVerb != null) {
      for (PerVerbAPIRequestCount item : byVerb) {
        this.addToByVerb(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasByVerb() {
    return this.byVerb != null && !this.byVerb.isEmpty();
  }
  
  public A addNewByVerb(Long requestCount,String verb) {
    return (A)addToByVerb(new PerVerbAPIRequestCount(requestCount, verb));
  }
  
  public ByVerbNested<A> addNewByVerb() {
    return new ByVerbNested(-1, null);
  }
  
  public ByVerbNested<A> addNewByVerbLike(PerVerbAPIRequestCount item) {
    return new ByVerbNested(-1, item);
  }
  
  public ByVerbNested<A> setNewByVerbLike(int index,PerVerbAPIRequestCount item) {
    return new ByVerbNested(index, item);
  }
  
  public ByVerbNested<A> editByVerb(int index) {
    if (byVerb.size() <= index) throw new RuntimeException("Can't edit byVerb. Index exceeds size.");
    return setNewByVerbLike(index, buildByVerb(index));
  }
  
  public ByVerbNested<A> editFirstByVerb() {
    if (byVerb.size() == 0) throw new RuntimeException("Can't edit first byVerb. The list is empty.");
    return setNewByVerbLike(0, buildByVerb(0));
  }
  
  public ByVerbNested<A> editLastByVerb() {
    int index = byVerb.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last byVerb. The list is empty.");
    return setNewByVerbLike(index, buildByVerb(index));
  }
  
  public ByVerbNested<A> editMatchingByVerb(Predicate<PerVerbAPIRequestCountBuilder> predicate) {
    int index = -1;
    for (int i=0;i<byVerb.size();i++) { 
    if (predicate.test(byVerb.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching byVerb. No match found.");
    return setNewByVerbLike(index, buildByVerb(index));
  }
  
  public Long getRequestCount() {
    return this.requestCount;
  }
  
  public A withRequestCount(Long requestCount) {
    this.requestCount = requestCount;
    return (A) this;
  }
  
  public boolean hasRequestCount() {
    return this.requestCount != null;
  }
  
  public String getUserAgent() {
    return this.userAgent;
  }
  
  public A withUserAgent(String userAgent) {
    this.userAgent = userAgent;
    return (A) this;
  }
  
  public boolean hasUserAgent() {
    return this.userAgent != null;
  }
  
  public String getUsername() {
    return this.username;
  }
  
  public A withUsername(String username) {
    this.username = username;
    return (A) this;
  }
  
  public boolean hasUsername() {
    return this.username != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PerUserAPIRequestCountFluent that = (PerUserAPIRequestCountFluent) o;
    if (!java.util.Objects.equals(byVerb, that.byVerb)) return false;
    if (!java.util.Objects.equals(requestCount, that.requestCount)) return false;
    if (!java.util.Objects.equals(userAgent, that.userAgent)) return false;
    if (!java.util.Objects.equals(username, that.username)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(byVerb,  requestCount,  userAgent,  username,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (byVerb != null && !byVerb.isEmpty()) { sb.append("byVerb:"); sb.append(byVerb + ","); }
    if (requestCount != null) { sb.append("requestCount:"); sb.append(requestCount + ","); }
    if (userAgent != null) { sb.append("userAgent:"); sb.append(userAgent + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ByVerbNested<N> extends PerVerbAPIRequestCountFluent<ByVerbNested<N>> implements Nested<N>{
    ByVerbNested(int index,PerVerbAPIRequestCount item) {
      this.index = index;
      this.builder = new PerVerbAPIRequestCountBuilder(this, item);
    }
    PerVerbAPIRequestCountBuilder builder;
    int index;
    
    public N and() {
      return (N) PerUserAPIRequestCountFluent.this.setToByVerb(index,builder.build());
    }
    
    public N endByVerb() {
      return and();
    }
    
  
  }

}