/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CPU;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CPUBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.CPUFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.Firmware;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.FirmwareBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.FirmwareFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareDetails;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareSystemVendor;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareSystemVendorBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.HardwareSystemVendorFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NIC;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NICBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.NICFluent;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.Storage;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.StorageBuilder;
import io.fabric8.openshift.api.model.miscellaneous.metal3.v1alpha1.StorageFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class HardwareDetailsFluent<A extends HardwareDetailsFluent<A>>
extends BaseFluent<A> {
    private CPUBuilder cpu;
    private FirmwareBuilder firmware;
    private String hostname;
    private ArrayList<NICBuilder> nics = new ArrayList();
    private Integer ramMebibytes;
    private ArrayList<StorageBuilder> storage = new ArrayList();
    private HardwareSystemVendorBuilder systemVendor;
    private Map<String, Object> additionalProperties;

    public HardwareDetailsFluent() {
    }

    public HardwareDetailsFluent(HardwareDetails instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HardwareDetails instance) {
        HardwareDetails hardwareDetails = instance = instance != null ? instance : new HardwareDetails();
        if (instance != null) {
            this.withCpu(instance.getCpu());
            this.withFirmware(instance.getFirmware());
            this.withHostname(instance.getHostname());
            this.withNics(instance.getNics());
            this.withRamMebibytes(instance.getRamMebibytes());
            this.withStorage(instance.getStorage());
            this.withSystemVendor(instance.getSystemVendor());
            this.withCpu(instance.getCpu());
            this.withFirmware(instance.getFirmware());
            this.withHostname(instance.getHostname());
            this.withNics(instance.getNics());
            this.withRamMebibytes(instance.getRamMebibytes());
            this.withStorage(instance.getStorage());
            this.withSystemVendor(instance.getSystemVendor());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CPU buildCpu() {
        return this.cpu != null ? this.cpu.build() : null;
    }

    public A withCpu(CPU cpu) {
        this._visitables.get((Object)"cpu").remove((Object)this.cpu);
        if (cpu != null) {
            this.cpu = new CPUBuilder(cpu);
            this._visitables.get((Object)"cpu").add(this.cpu);
        } else {
            this.cpu = null;
            this._visitables.get((Object)"cpu").remove((Object)this.cpu);
        }
        return (A)((Object)this);
    }

    public boolean hasCpu() {
        return this.cpu != null;
    }

    public CpuNested<A> withNewCpu() {
        return new CpuNested(null);
    }

    public CpuNested<A> withNewCpuLike(CPU item) {
        return new CpuNested(item);
    }

    public CpuNested<A> editCpu() {
        return this.withNewCpuLike(Optional.ofNullable(this.buildCpu()).orElse(null));
    }

    public CpuNested<A> editOrNewCpu() {
        return this.withNewCpuLike(Optional.ofNullable(this.buildCpu()).orElse(new CPUBuilder().build()));
    }

    public CpuNested<A> editOrNewCpuLike(CPU item) {
        return this.withNewCpuLike(Optional.ofNullable(this.buildCpu()).orElse(item));
    }

    public Firmware buildFirmware() {
        return this.firmware != null ? this.firmware.build() : null;
    }

    public A withFirmware(Firmware firmware) {
        this._visitables.get((Object)"firmware").remove((Object)this.firmware);
        if (firmware != null) {
            this.firmware = new FirmwareBuilder(firmware);
            this._visitables.get((Object)"firmware").add(this.firmware);
        } else {
            this.firmware = null;
            this._visitables.get((Object)"firmware").remove((Object)this.firmware);
        }
        return (A)((Object)this);
    }

    public boolean hasFirmware() {
        return this.firmware != null;
    }

    public FirmwareNested<A> withNewFirmware() {
        return new FirmwareNested(null);
    }

    public FirmwareNested<A> withNewFirmwareLike(Firmware item) {
        return new FirmwareNested(item);
    }

    public FirmwareNested<A> editFirmware() {
        return this.withNewFirmwareLike(Optional.ofNullable(this.buildFirmware()).orElse(null));
    }

    public FirmwareNested<A> editOrNewFirmware() {
        return this.withNewFirmwareLike(Optional.ofNullable(this.buildFirmware()).orElse(new FirmwareBuilder().build()));
    }

    public FirmwareNested<A> editOrNewFirmwareLike(Firmware item) {
        return this.withNewFirmwareLike(Optional.ofNullable(this.buildFirmware()).orElse(item));
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)((Object)this);
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public A addToNics(int index, NIC item) {
        if (this.nics == null) {
            this.nics = new ArrayList();
        }
        NICBuilder builder = new NICBuilder(item);
        if (index < 0 || index >= this.nics.size()) {
            this._visitables.get((Object)"nics").add(builder);
            this.nics.add(builder);
        } else {
            this._visitables.get((Object)"nics").add(index, builder);
            this.nics.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToNics(int index, NIC item) {
        if (this.nics == null) {
            this.nics = new ArrayList();
        }
        NICBuilder builder = new NICBuilder(item);
        if (index < 0 || index >= this.nics.size()) {
            this._visitables.get((Object)"nics").add(builder);
            this.nics.add(builder);
        } else {
            this._visitables.get((Object)"nics").set(index, builder);
            this.nics.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToNics(NIC ... items) {
        if (this.nics == null) {
            this.nics = new ArrayList();
        }
        for (NIC item : items) {
            NICBuilder builder = new NICBuilder(item);
            this._visitables.get((Object)"nics").add(builder);
            this.nics.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToNics(Collection<NIC> items) {
        if (this.nics == null) {
            this.nics = new ArrayList();
        }
        for (NIC item : items) {
            NICBuilder builder = new NICBuilder(item);
            this._visitables.get((Object)"nics").add(builder);
            this.nics.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromNics(NIC ... items) {
        if (this.nics == null) {
            return (A)((Object)this);
        }
        for (NIC item : items) {
            NICBuilder builder = new NICBuilder(item);
            this._visitables.get((Object)"nics").remove((Object)builder);
            this.nics.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNics(Collection<NIC> items) {
        if (this.nics == null) {
            return (A)((Object)this);
        }
        for (NIC item : items) {
            NICBuilder builder = new NICBuilder(item);
            this._visitables.get((Object)"nics").remove((Object)builder);
            this.nics.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromNics(Predicate<NICBuilder> predicate) {
        if (this.nics == null) {
            return (A)((Object)this);
        }
        Iterator<NICBuilder> each = this.nics.iterator();
        List visitables = this._visitables.get((Object)"nics");
        while (each.hasNext()) {
            NICBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NIC> buildNics() {
        return this.nics != null ? HardwareDetailsFluent.build(this.nics) : null;
    }

    public NIC buildNic(int index) {
        return this.nics.get(index).build();
    }

    public NIC buildFirstNic() {
        return this.nics.get(0).build();
    }

    public NIC buildLastNic() {
        return this.nics.get(this.nics.size() - 1).build();
    }

    public NIC buildMatchingNic(Predicate<NICBuilder> predicate) {
        for (NICBuilder item : this.nics) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNic(Predicate<NICBuilder> predicate) {
        for (NICBuilder item : this.nics) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNics(List<NIC> nics) {
        if (this.nics != null) {
            this._visitables.get((Object)"nics").clear();
        }
        if (nics != null) {
            this.nics = new ArrayList();
            for (NIC item : nics) {
                this.addToNics(item);
            }
        } else {
            this.nics = null;
        }
        return (A)((Object)this);
    }

    public A withNics(NIC ... nics) {
        if (this.nics != null) {
            this.nics.clear();
            this._visitables.remove((Object)"nics");
        }
        if (nics != null) {
            for (NIC item : nics) {
                this.addToNics(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNics() {
        return this.nics != null && !this.nics.isEmpty();
    }

    public NicsNested<A> addNewNic() {
        return new NicsNested(-1, null);
    }

    public NicsNested<A> addNewNicLike(NIC item) {
        return new NicsNested(-1, item);
    }

    public NicsNested<A> setNewNicLike(int index, NIC item) {
        return new NicsNested(index, item);
    }

    public NicsNested<A> editNic(int index) {
        if (this.nics.size() <= index) {
            throw new RuntimeException("Can't edit nics. Index exceeds size.");
        }
        return this.setNewNicLike(index, this.buildNic(index));
    }

    public NicsNested<A> editFirstNic() {
        if (this.nics.size() == 0) {
            throw new RuntimeException("Can't edit first nics. The list is empty.");
        }
        return this.setNewNicLike(0, this.buildNic(0));
    }

    public NicsNested<A> editLastNic() {
        int index = this.nics.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nics. The list is empty.");
        }
        return this.setNewNicLike(index, this.buildNic(index));
    }

    public NicsNested<A> editMatchingNic(Predicate<NICBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nics.size(); ++i) {
            if (!predicate.test(this.nics.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nics. No match found.");
        }
        return this.setNewNicLike(index, this.buildNic(index));
    }

    public Integer getRamMebibytes() {
        return this.ramMebibytes;
    }

    public A withRamMebibytes(Integer ramMebibytes) {
        this.ramMebibytes = ramMebibytes;
        return (A)((Object)this);
    }

    public boolean hasRamMebibytes() {
        return this.ramMebibytes != null;
    }

    public A addToStorage(int index, Storage item) {
        if (this.storage == null) {
            this.storage = new ArrayList();
        }
        StorageBuilder builder = new StorageBuilder(item);
        if (index < 0 || index >= this.storage.size()) {
            this._visitables.get((Object)"storage").add(builder);
            this.storage.add(builder);
        } else {
            this._visitables.get((Object)"storage").add(index, builder);
            this.storage.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToStorage(int index, Storage item) {
        if (this.storage == null) {
            this.storage = new ArrayList();
        }
        StorageBuilder builder = new StorageBuilder(item);
        if (index < 0 || index >= this.storage.size()) {
            this._visitables.get((Object)"storage").add(builder);
            this.storage.add(builder);
        } else {
            this._visitables.get((Object)"storage").set(index, builder);
            this.storage.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToStorage(Storage ... items) {
        if (this.storage == null) {
            this.storage = new ArrayList();
        }
        for (Storage item : items) {
            StorageBuilder builder = new StorageBuilder(item);
            this._visitables.get((Object)"storage").add(builder);
            this.storage.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToStorage(Collection<Storage> items) {
        if (this.storage == null) {
            this.storage = new ArrayList();
        }
        for (Storage item : items) {
            StorageBuilder builder = new StorageBuilder(item);
            this._visitables.get((Object)"storage").add(builder);
            this.storage.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromStorage(Storage ... items) {
        if (this.storage == null) {
            return (A)((Object)this);
        }
        for (Storage item : items) {
            StorageBuilder builder = new StorageBuilder(item);
            this._visitables.get((Object)"storage").remove((Object)builder);
            this.storage.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromStorage(Collection<Storage> items) {
        if (this.storage == null) {
            return (A)((Object)this);
        }
        for (Storage item : items) {
            StorageBuilder builder = new StorageBuilder(item);
            this._visitables.get((Object)"storage").remove((Object)builder);
            this.storage.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromStorage(Predicate<StorageBuilder> predicate) {
        if (this.storage == null) {
            return (A)((Object)this);
        }
        Iterator<StorageBuilder> each = this.storage.iterator();
        List visitables = this._visitables.get((Object)"storage");
        while (each.hasNext()) {
            StorageBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Storage> buildStorage() {
        return this.storage != null ? HardwareDetailsFluent.build(this.storage) : null;
    }

    public Storage buildStorage(int index) {
        return this.storage.get(index).build();
    }

    public Storage buildFirstStorage() {
        return this.storage.get(0).build();
    }

    public Storage buildLastStorage() {
        return this.storage.get(this.storage.size() - 1).build();
    }

    public Storage buildMatchingStorage(Predicate<StorageBuilder> predicate) {
        for (StorageBuilder item : this.storage) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStorage(Predicate<StorageBuilder> predicate) {
        for (StorageBuilder item : this.storage) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withStorage(List<Storage> storage) {
        if (this.storage != null) {
            this._visitables.get((Object)"storage").clear();
        }
        if (storage != null) {
            this.storage = new ArrayList();
            for (Storage item : storage) {
                this.addToStorage(item);
            }
        } else {
            this.storage = null;
        }
        return (A)((Object)this);
    }

    public A withStorage(Storage ... storage) {
        if (this.storage != null) {
            this.storage.clear();
            this._visitables.remove((Object)"storage");
        }
        if (storage != null) {
            for (Storage item : storage) {
                this.addToStorage(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasStorage() {
        return this.storage != null && !this.storage.isEmpty();
    }

    public StorageNested<A> addNewStorage() {
        return new StorageNested(-1, null);
    }

    public StorageNested<A> addNewStorageLike(Storage item) {
        return new StorageNested(-1, item);
    }

    public StorageNested<A> setNewStorageLike(int index, Storage item) {
        return new StorageNested(index, item);
    }

    public StorageNested<A> editStorage(int index) {
        if (this.storage.size() <= index) {
            throw new RuntimeException("Can't edit storage. Index exceeds size.");
        }
        return this.setNewStorageLike(index, this.buildStorage(index));
    }

    public StorageNested<A> editFirstStorage() {
        if (this.storage.size() == 0) {
            throw new RuntimeException("Can't edit first storage. The list is empty.");
        }
        return this.setNewStorageLike(0, this.buildStorage(0));
    }

    public StorageNested<A> editLastStorage() {
        int index = this.storage.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last storage. The list is empty.");
        }
        return this.setNewStorageLike(index, this.buildStorage(index));
    }

    public StorageNested<A> editMatchingStorage(Predicate<StorageBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.storage.size(); ++i) {
            if (!predicate.test(this.storage.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching storage. No match found.");
        }
        return this.setNewStorageLike(index, this.buildStorage(index));
    }

    public HardwareSystemVendor buildSystemVendor() {
        return this.systemVendor != null ? this.systemVendor.build() : null;
    }

    public A withSystemVendor(HardwareSystemVendor systemVendor) {
        this._visitables.get((Object)"systemVendor").remove((Object)this.systemVendor);
        if (systemVendor != null) {
            this.systemVendor = new HardwareSystemVendorBuilder(systemVendor);
            this._visitables.get((Object)"systemVendor").add(this.systemVendor);
        } else {
            this.systemVendor = null;
            this._visitables.get((Object)"systemVendor").remove((Object)this.systemVendor);
        }
        return (A)((Object)this);
    }

    public boolean hasSystemVendor() {
        return this.systemVendor != null;
    }

    public A withNewSystemVendor(String manufacturer, String productName, String serialNumber) {
        return this.withSystemVendor(new HardwareSystemVendor(manufacturer, productName, serialNumber));
    }

    public SystemVendorNested<A> withNewSystemVendor() {
        return new SystemVendorNested(null);
    }

    public SystemVendorNested<A> withNewSystemVendorLike(HardwareSystemVendor item) {
        return new SystemVendorNested(item);
    }

    public SystemVendorNested<A> editSystemVendor() {
        return this.withNewSystemVendorLike(Optional.ofNullable(this.buildSystemVendor()).orElse(null));
    }

    public SystemVendorNested<A> editOrNewSystemVendor() {
        return this.withNewSystemVendorLike(Optional.ofNullable(this.buildSystemVendor()).orElse(new HardwareSystemVendorBuilder().build()));
    }

    public SystemVendorNested<A> editOrNewSystemVendorLike(HardwareSystemVendor item) {
        return this.withNewSystemVendorLike(Optional.ofNullable(this.buildSystemVendor()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HardwareDetailsFluent that = (HardwareDetailsFluent)((Object)o);
        if (!Objects.equals((Object)this.cpu, (Object)that.cpu)) {
            return false;
        }
        if (!Objects.equals((Object)this.firmware, (Object)that.firmware)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.nics, that.nics)) {
            return false;
        }
        if (!Objects.equals(this.ramMebibytes, that.ramMebibytes)) {
            return false;
        }
        if (!Objects.equals(this.storage, that.storage)) {
            return false;
        }
        if (!Objects.equals((Object)this.systemVendor, (Object)that.systemVendor)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cpu, this.firmware, this.hostname, this.nics, this.ramMebibytes, this.storage, this.systemVendor, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cpu != null) {
            sb.append("cpu:");
            sb.append((Object)((Object)this.cpu) + ",");
        }
        if (this.firmware != null) {
            sb.append("firmware:");
            sb.append((Object)((Object)this.firmware) + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.nics != null && !this.nics.isEmpty()) {
            sb.append("nics:");
            sb.append(this.nics + ",");
        }
        if (this.ramMebibytes != null) {
            sb.append("ramMebibytes:");
            sb.append(this.ramMebibytes + ",");
        }
        if (this.storage != null && !this.storage.isEmpty()) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.systemVendor != null) {
            sb.append("systemVendor:");
            sb.append((Object)((Object)this.systemVendor) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SystemVendorNested<N>
    extends HardwareSystemVendorFluent<SystemVendorNested<N>>
    implements Nested<N> {
        HardwareSystemVendorBuilder builder;

        SystemVendorNested(HardwareSystemVendor item) {
            this.builder = new HardwareSystemVendorBuilder(this, item);
        }

        public N and() {
            return (N)HardwareDetailsFluent.this.withSystemVendor(this.builder.build());
        }

        public N endSystemVendor() {
            return this.and();
        }
    }

    public class StorageNested<N>
    extends StorageFluent<StorageNested<N>>
    implements Nested<N> {
        StorageBuilder builder;
        int index;

        StorageNested(int index, Storage item) {
            this.index = index;
            this.builder = new StorageBuilder(this, item);
        }

        public N and() {
            return (N)HardwareDetailsFluent.this.setToStorage(this.index, this.builder.build());
        }

        public N endStorage() {
            return this.and();
        }
    }

    public class NicsNested<N>
    extends NICFluent<NicsNested<N>>
    implements Nested<N> {
        NICBuilder builder;
        int index;

        NicsNested(int index, NIC item) {
            this.index = index;
            this.builder = new NICBuilder(this, item);
        }

        public N and() {
            return (N)HardwareDetailsFluent.this.setToNics(this.index, this.builder.build());
        }

        public N endNic() {
            return this.and();
        }
    }

    public class FirmwareNested<N>
    extends FirmwareFluent<FirmwareNested<N>>
    implements Nested<N> {
        FirmwareBuilder builder;

        FirmwareNested(Firmware item) {
            this.builder = new FirmwareBuilder(this, item);
        }

        public N and() {
            return (N)HardwareDetailsFluent.this.withFirmware(this.builder.build());
        }

        public N endFirmware() {
            return this.and();
        }
    }

    public class CpuNested<N>
    extends CPUFluent<CpuNested<N>>
    implements Nested<N> {
        CPUBuilder builder;

        CpuNested(CPU item) {
            this.builder = new CPUBuilder(this, item);
        }

        public N and() {
            return (N)HardwareDetailsFluent.this.withCpu(this.builder.build());
        }

        public N endCpu() {
            return this.and();
        }
    }
}

