/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.miscellaneous.apiserver.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCount;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountFluent;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountSpec;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountSpecBuilder;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountSpecFluentImpl;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatus;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusBuilder;
import io.fabric8.openshift.api.model.miscellaneous.apiserver.v1.APIRequestCountStatusFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class APIRequestCountFluentImpl<A extends APIRequestCountFluent<A>>
extends BaseFluent<A>
implements APIRequestCountFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private APIRequestCountSpecBuilder spec;
    private APIRequestCountStatusBuilder status;
    private Map<String, Object> additionalProperties;

    public APIRequestCountFluentImpl() {
    }

    public APIRequestCountFluentImpl(APIRequestCount instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get((Object)"metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public APIRequestCountFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public APIRequestCountFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public APIRequestCountFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public APIRequestCountFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public APIRequestCountFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public APIRequestCountSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public APIRequestCountSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(APIRequestCountSpec spec) {
        this._visitables.get((Object)"spec").remove(this.spec);
        if (spec != null) {
            this.spec = new APIRequestCountSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public A withNewSpec(Long numberOfUsersToReport) {
        return this.withSpec(new APIRequestCountSpec(numberOfUsersToReport));
    }

    @Override
    public APIRequestCountFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public APIRequestCountFluent.SpecNested<A> withNewSpecLike(APIRequestCountSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public APIRequestCountFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public APIRequestCountFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new APIRequestCountSpecBuilder().build());
    }

    @Override
    public APIRequestCountFluent.SpecNested<A> editOrNewSpecLike(APIRequestCountSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public APIRequestCountStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public APIRequestCountStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(APIRequestCountStatus status) {
        this._visitables.get((Object)"status").remove(this.status);
        if (status != null) {
            this.status = new APIRequestCountStatusBuilder(status);
            this._visitables.get((Object)"status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get((Object)"status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public APIRequestCountFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public APIRequestCountFluent.StatusNested<A> withNewStatusLike(APIRequestCountStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public APIRequestCountFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public APIRequestCountFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new APIRequestCountStatusBuilder().build());
    }

    @Override
    public APIRequestCountFluent.StatusNested<A> editOrNewStatusLike(APIRequestCountStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIRequestCountFluentImpl that = (APIRequestCountFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends APIRequestCountStatusFluentImpl<APIRequestCountFluent.StatusNested<N>>
    implements APIRequestCountFluent.StatusNested<N>,
    Nested<N> {
        APIRequestCountStatusBuilder builder;

        StatusNestedImpl(APIRequestCountStatus item) {
            this.builder = new APIRequestCountStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new APIRequestCountStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIRequestCountFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends APIRequestCountSpecFluentImpl<APIRequestCountFluent.SpecNested<N>>
    implements APIRequestCountFluent.SpecNested<N>,
    Nested<N> {
        APIRequestCountSpecBuilder builder;

        SpecNestedImpl(APIRequestCountSpec item) {
            this.builder = new APIRequestCountSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new APIRequestCountSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIRequestCountFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<APIRequestCountFluent.MetadataNested<N>>
    implements APIRequestCountFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this);
        }

        @Override
        public N and() {
            return (N)APIRequestCountFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

