package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MachineOSBuildSpecBuilder extends MachineOSBuildSpecFluent<MachineOSBuildSpecBuilder> implements VisitableBuilder<MachineOSBuildSpec,MachineOSBuildSpecBuilder>{
  public MachineOSBuildSpecBuilder() {
    this(new MachineOSBuildSpec());
  }
  
  public MachineOSBuildSpecBuilder(MachineOSBuildSpecFluent<?> fluent) {
    this(fluent, new MachineOSBuildSpec());
  }
  
  public MachineOSBuildSpecBuilder(MachineOSBuildSpecFluent<?> fluent,MachineOSBuildSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MachineOSBuildSpecBuilder(MachineOSBuildSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MachineOSBuildSpecFluent<?> fluent;
  
  public MachineOSBuildSpec build() {
    MachineOSBuildSpec buildable = new MachineOSBuildSpec(fluent.getConfigGeneration(),fluent.buildDesiredConfig(),fluent.buildMachineOSConfig(),fluent.getRenderedImagePushspec(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}