package io.fabric8.openshift.api.model.machineconfiguration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PinnedImageSetBuilder extends PinnedImageSetFluent<PinnedImageSetBuilder> implements VisitableBuilder<PinnedImageSet,PinnedImageSetBuilder>{
  public PinnedImageSetBuilder() {
    this(new PinnedImageSet());
  }
  
  public PinnedImageSetBuilder(PinnedImageSetFluent<?> fluent) {
    this(fluent, new PinnedImageSet());
  }
  
  public PinnedImageSetBuilder(PinnedImageSetFluent<?> fluent,PinnedImageSet instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PinnedImageSetBuilder(PinnedImageSet instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PinnedImageSetFluent<?> fluent;
  
  public PinnedImageSet build() {
    PinnedImageSet buildable = new PinnedImageSet(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}