package io.fabric8.openshift.api.model.machineconfiguration.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineOSBuilderReferenceFluent<A extends MachineOSBuilderReferenceFluent<A>> extends BaseFluent<A>{
  public MachineOSBuilderReferenceFluent() {
  }
  
  public MachineOSBuilderReferenceFluent(MachineOSBuilderReference instance) {
    this.copyInstance(instance);
  }
  private String imageBuilderType;
  private ObjectReferenceBuilder job;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineOSBuilderReference instance) {
    instance = (instance != null ? instance : new MachineOSBuilderReference());
    if (instance != null) {
          this.withImageBuilderType(instance.getImageBuilderType());
          this.withJob(instance.getJob());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getImageBuilderType() {
    return this.imageBuilderType;
  }
  
  public A withImageBuilderType(String imageBuilderType) {
    this.imageBuilderType = imageBuilderType;
    return (A) this;
  }
  
  public boolean hasImageBuilderType() {
    return this.imageBuilderType != null;
  }
  
  public ObjectReference buildJob() {
    return this.job != null ? this.job.build() : null;
  }
  
  public A withJob(ObjectReference job) {
    this._visitables.remove("job");
    if (job != null) {
        this.job = new ObjectReferenceBuilder(job);
        this._visitables.get("job").add(this.job);
    } else {
        this.job = null;
        this._visitables.get("job").remove(this.job);
    }
    return (A) this;
  }
  
  public boolean hasJob() {
    return this.job != null;
  }
  
  public A withNewJob(String group,String name,String namespace,String resource) {
    return (A)withJob(new ObjectReference(group, name, namespace, resource));
  }
  
  public JobNested<A> withNewJob() {
    return new JobNested(null);
  }
  
  public JobNested<A> withNewJobLike(ObjectReference item) {
    return new JobNested(item);
  }
  
  public JobNested<A> editJob() {
    return withNewJobLike(java.util.Optional.ofNullable(buildJob()).orElse(null));
  }
  
  public JobNested<A> editOrNewJob() {
    return withNewJobLike(java.util.Optional.ofNullable(buildJob()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public JobNested<A> editOrNewJobLike(ObjectReference item) {
    return withNewJobLike(java.util.Optional.ofNullable(buildJob()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineOSBuilderReferenceFluent that = (MachineOSBuilderReferenceFluent) o;
    if (!java.util.Objects.equals(imageBuilderType, that.imageBuilderType)) return false;
    if (!java.util.Objects.equals(job, that.job)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(imageBuilderType,  job,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (imageBuilderType != null) { sb.append("imageBuilderType:"); sb.append(imageBuilderType + ","); }
    if (job != null) { sb.append("job:"); sb.append(job + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class JobNested<N> extends ObjectReferenceFluent<JobNested<N>> implements Nested<N>{
    JobNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) MachineOSBuilderReferenceFluent.this.withJob(builder.build());
    }
    
    public N endJob() {
      return and();
    }
    
  
  }

}