/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machineconfiguration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MCOObjectReference;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MCOObjectReferenceBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MCOObjectReferenceFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpec;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecMachineConfigVersion;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecMachineConfigVersionBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecMachineConfigVersionFluent;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecPinnedImageSet;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecPinnedImageSetBuilder;
import io.fabric8.openshift.api.model.machineconfiguration.v1alpha1.MachineConfigNodeSpecPinnedImageSetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachineConfigNodeSpecFluent<A extends MachineConfigNodeSpecFluent<A>>
extends BaseFluent<A> {
    private MachineConfigNodeSpecMachineConfigVersionBuilder configVersion;
    private MCOObjectReferenceBuilder node;
    private ArrayList<MachineConfigNodeSpecPinnedImageSetBuilder> pinnedImageSets = new ArrayList();
    private MCOObjectReferenceBuilder pool;
    private Map<String, Object> additionalProperties;

    public MachineConfigNodeSpecFluent() {
    }

    public MachineConfigNodeSpecFluent(MachineConfigNodeSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachineConfigNodeSpec instance) {
        MachineConfigNodeSpec machineConfigNodeSpec = instance = instance != null ? instance : new MachineConfigNodeSpec();
        if (instance != null) {
            this.withConfigVersion(instance.getConfigVersion());
            this.withNode(instance.getNode());
            this.withPinnedImageSets(instance.getPinnedImageSets());
            this.withPool(instance.getPool());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MachineConfigNodeSpecMachineConfigVersion buildConfigVersion() {
        return this.configVersion != null ? this.configVersion.build() : null;
    }

    public A withConfigVersion(MachineConfigNodeSpecMachineConfigVersion configVersion) {
        this._visitables.remove((Object)"configVersion");
        if (configVersion != null) {
            this.configVersion = new MachineConfigNodeSpecMachineConfigVersionBuilder(configVersion);
            this._visitables.get((Object)"configVersion").add(this.configVersion);
        } else {
            this.configVersion = null;
            this._visitables.get((Object)"configVersion").remove((Object)this.configVersion);
        }
        return (A)((Object)this);
    }

    public boolean hasConfigVersion() {
        return this.configVersion != null;
    }

    public A withNewConfigVersion(String desired) {
        return this.withConfigVersion(new MachineConfigNodeSpecMachineConfigVersion(desired));
    }

    public ConfigVersionNested<A> withNewConfigVersion() {
        return new ConfigVersionNested(null);
    }

    public ConfigVersionNested<A> withNewConfigVersionLike(MachineConfigNodeSpecMachineConfigVersion item) {
        return new ConfigVersionNested(item);
    }

    public ConfigVersionNested<A> editConfigVersion() {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(null));
    }

    public ConfigVersionNested<A> editOrNewConfigVersion() {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(new MachineConfigNodeSpecMachineConfigVersionBuilder().build()));
    }

    public ConfigVersionNested<A> editOrNewConfigVersionLike(MachineConfigNodeSpecMachineConfigVersion item) {
        return this.withNewConfigVersionLike(Optional.ofNullable(this.buildConfigVersion()).orElse(item));
    }

    public MCOObjectReference buildNode() {
        return this.node != null ? this.node.build() : null;
    }

    public A withNode(MCOObjectReference node) {
        this._visitables.remove((Object)"node");
        if (node != null) {
            this.node = new MCOObjectReferenceBuilder(node);
            this._visitables.get((Object)"node").add(this.node);
        } else {
            this.node = null;
            this._visitables.get((Object)"node").remove((Object)this.node);
        }
        return (A)((Object)this);
    }

    public boolean hasNode() {
        return this.node != null;
    }

    public A withNewNode(String name) {
        return this.withNode(new MCOObjectReference(name));
    }

    public NodeNested<A> withNewNode() {
        return new NodeNested(null);
    }

    public NodeNested<A> withNewNodeLike(MCOObjectReference item) {
        return new NodeNested(item);
    }

    public NodeNested<A> editNode() {
        return this.withNewNodeLike(Optional.ofNullable(this.buildNode()).orElse(null));
    }

    public NodeNested<A> editOrNewNode() {
        return this.withNewNodeLike(Optional.ofNullable(this.buildNode()).orElse(new MCOObjectReferenceBuilder().build()));
    }

    public NodeNested<A> editOrNewNodeLike(MCOObjectReference item) {
        return this.withNewNodeLike(Optional.ofNullable(this.buildNode()).orElse(item));
    }

    public A addToPinnedImageSets(int index, MachineConfigNodeSpecPinnedImageSet item) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        MachineConfigNodeSpecPinnedImageSetBuilder builder = new MachineConfigNodeSpecPinnedImageSetBuilder(item);
        if (index < 0 || index >= this.pinnedImageSets.size()) {
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        } else {
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPinnedImageSets(int index, MachineConfigNodeSpecPinnedImageSet item) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        MachineConfigNodeSpecPinnedImageSetBuilder builder = new MachineConfigNodeSpecPinnedImageSetBuilder(item);
        if (index < 0 || index >= this.pinnedImageSets.size()) {
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        } else {
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPinnedImageSets(MachineConfigNodeSpecPinnedImageSet ... items) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        for (MachineConfigNodeSpecPinnedImageSet item : items) {
            MachineConfigNodeSpecPinnedImageSetBuilder builder = new MachineConfigNodeSpecPinnedImageSetBuilder(item);
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPinnedImageSets(Collection<MachineConfigNodeSpecPinnedImageSet> items) {
        if (this.pinnedImageSets == null) {
            this.pinnedImageSets = new ArrayList();
        }
        for (MachineConfigNodeSpecPinnedImageSet item : items) {
            MachineConfigNodeSpecPinnedImageSetBuilder builder = new MachineConfigNodeSpecPinnedImageSetBuilder(item);
            this._visitables.get((Object)"pinnedImageSets").add(builder);
            this.pinnedImageSets.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPinnedImageSets(MachineConfigNodeSpecPinnedImageSet ... items) {
        if (this.pinnedImageSets == null) {
            return (A)((Object)this);
        }
        for (MachineConfigNodeSpecPinnedImageSet item : items) {
            MachineConfigNodeSpecPinnedImageSetBuilder builder = new MachineConfigNodeSpecPinnedImageSetBuilder(item);
            this._visitables.get((Object)"pinnedImageSets").remove((Object)builder);
            this.pinnedImageSets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPinnedImageSets(Collection<MachineConfigNodeSpecPinnedImageSet> items) {
        if (this.pinnedImageSets == null) {
            return (A)((Object)this);
        }
        for (MachineConfigNodeSpecPinnedImageSet item : items) {
            MachineConfigNodeSpecPinnedImageSetBuilder builder = new MachineConfigNodeSpecPinnedImageSetBuilder(item);
            this._visitables.get((Object)"pinnedImageSets").remove((Object)builder);
            this.pinnedImageSets.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPinnedImageSets(Predicate<MachineConfigNodeSpecPinnedImageSetBuilder> predicate) {
        if (this.pinnedImageSets == null) {
            return (A)((Object)this);
        }
        Iterator<MachineConfigNodeSpecPinnedImageSetBuilder> each = this.pinnedImageSets.iterator();
        List visitables = this._visitables.get((Object)"pinnedImageSets");
        while (each.hasNext()) {
            MachineConfigNodeSpecPinnedImageSetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<MachineConfigNodeSpecPinnedImageSet> buildPinnedImageSets() {
        return this.pinnedImageSets != null ? MachineConfigNodeSpecFluent.build(this.pinnedImageSets) : null;
    }

    public MachineConfigNodeSpecPinnedImageSet buildPinnedImageSet(int index) {
        return this.pinnedImageSets.get(index).build();
    }

    public MachineConfigNodeSpecPinnedImageSet buildFirstPinnedImageSet() {
        return this.pinnedImageSets.get(0).build();
    }

    public MachineConfigNodeSpecPinnedImageSet buildLastPinnedImageSet() {
        return this.pinnedImageSets.get(this.pinnedImageSets.size() - 1).build();
    }

    public MachineConfigNodeSpecPinnedImageSet buildMatchingPinnedImageSet(Predicate<MachineConfigNodeSpecPinnedImageSetBuilder> predicate) {
        for (MachineConfigNodeSpecPinnedImageSetBuilder item : this.pinnedImageSets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPinnedImageSet(Predicate<MachineConfigNodeSpecPinnedImageSetBuilder> predicate) {
        for (MachineConfigNodeSpecPinnedImageSetBuilder item : this.pinnedImageSets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPinnedImageSets(List<MachineConfigNodeSpecPinnedImageSet> pinnedImageSets) {
        if (this.pinnedImageSets != null) {
            this._visitables.get((Object)"pinnedImageSets").clear();
        }
        if (pinnedImageSets != null) {
            this.pinnedImageSets = new ArrayList();
            for (MachineConfigNodeSpecPinnedImageSet item : pinnedImageSets) {
                this.addToPinnedImageSets(item);
            }
        } else {
            this.pinnedImageSets = null;
        }
        return (A)((Object)this);
    }

    public A withPinnedImageSets(MachineConfigNodeSpecPinnedImageSet ... pinnedImageSets) {
        if (this.pinnedImageSets != null) {
            this.pinnedImageSets.clear();
            this._visitables.remove((Object)"pinnedImageSets");
        }
        if (pinnedImageSets != null) {
            for (MachineConfigNodeSpecPinnedImageSet item : pinnedImageSets) {
                this.addToPinnedImageSets(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPinnedImageSets() {
        return this.pinnedImageSets != null && !this.pinnedImageSets.isEmpty();
    }

    public A addNewPinnedImageSet(String name) {
        return this.addToPinnedImageSets(new MachineConfigNodeSpecPinnedImageSet(name));
    }

    public PinnedImageSetsNested<A> addNewPinnedImageSet() {
        return new PinnedImageSetsNested(-1, null);
    }

    public PinnedImageSetsNested<A> addNewPinnedImageSetLike(MachineConfigNodeSpecPinnedImageSet item) {
        return new PinnedImageSetsNested(-1, item);
    }

    public PinnedImageSetsNested<A> setNewPinnedImageSetLike(int index, MachineConfigNodeSpecPinnedImageSet item) {
        return new PinnedImageSetsNested(index, item);
    }

    public PinnedImageSetsNested<A> editPinnedImageSet(int index) {
        if (this.pinnedImageSets.size() <= index) {
            throw new RuntimeException("Can't edit pinnedImageSets. Index exceeds size.");
        }
        return this.setNewPinnedImageSetLike(index, this.buildPinnedImageSet(index));
    }

    public PinnedImageSetsNested<A> editFirstPinnedImageSet() {
        if (this.pinnedImageSets.size() == 0) {
            throw new RuntimeException("Can't edit first pinnedImageSets. The list is empty.");
        }
        return this.setNewPinnedImageSetLike(0, this.buildPinnedImageSet(0));
    }

    public PinnedImageSetsNested<A> editLastPinnedImageSet() {
        int index = this.pinnedImageSets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pinnedImageSets. The list is empty.");
        }
        return this.setNewPinnedImageSetLike(index, this.buildPinnedImageSet(index));
    }

    public PinnedImageSetsNested<A> editMatchingPinnedImageSet(Predicate<MachineConfigNodeSpecPinnedImageSetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pinnedImageSets.size(); ++i) {
            if (!predicate.test(this.pinnedImageSets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pinnedImageSets. No match found.");
        }
        return this.setNewPinnedImageSetLike(index, this.buildPinnedImageSet(index));
    }

    public MCOObjectReference buildPool() {
        return this.pool != null ? this.pool.build() : null;
    }

    public A withPool(MCOObjectReference pool) {
        this._visitables.remove((Object)"pool");
        if (pool != null) {
            this.pool = new MCOObjectReferenceBuilder(pool);
            this._visitables.get((Object)"pool").add(this.pool);
        } else {
            this.pool = null;
            this._visitables.get((Object)"pool").remove((Object)this.pool);
        }
        return (A)((Object)this);
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public A withNewPool(String name) {
        return this.withPool(new MCOObjectReference(name));
    }

    public PoolNested<A> withNewPool() {
        return new PoolNested(null);
    }

    public PoolNested<A> withNewPoolLike(MCOObjectReference item) {
        return new PoolNested(item);
    }

    public PoolNested<A> editPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(null));
    }

    public PoolNested<A> editOrNewPool() {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(new MCOObjectReferenceBuilder().build()));
    }

    public PoolNested<A> editOrNewPoolLike(MCOObjectReference item) {
        return this.withNewPoolLike(Optional.ofNullable(this.buildPool()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachineConfigNodeSpecFluent that = (MachineConfigNodeSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.configVersion, (Object)that.configVersion)) {
            return false;
        }
        if (!Objects.equals((Object)this.node, (Object)that.node)) {
            return false;
        }
        if (!Objects.equals(this.pinnedImageSets, that.pinnedImageSets)) {
            return false;
        }
        if (!Objects.equals((Object)this.pool, (Object)that.pool)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configVersion, this.node, this.pinnedImageSets, this.pool, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configVersion != null) {
            sb.append("configVersion:");
            sb.append(String.valueOf((Object)this.configVersion) + ",");
        }
        if (this.node != null) {
            sb.append("node:");
            sb.append(String.valueOf((Object)this.node) + ",");
        }
        if (this.pinnedImageSets != null && !this.pinnedImageSets.isEmpty()) {
            sb.append("pinnedImageSets:");
            sb.append(String.valueOf(this.pinnedImageSets) + ",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(String.valueOf((Object)this.pool) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PoolNested<N>
    extends MCOObjectReferenceFluent<PoolNested<N>>
    implements Nested<N> {
        MCOObjectReferenceBuilder builder;

        PoolNested(MCOObjectReference item) {
            this.builder = new MCOObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.withPool(this.builder.build());
        }

        public N endPool() {
            return this.and();
        }
    }

    public class PinnedImageSetsNested<N>
    extends MachineConfigNodeSpecPinnedImageSetFluent<PinnedImageSetsNested<N>>
    implements Nested<N> {
        MachineConfigNodeSpecPinnedImageSetBuilder builder;
        int index;

        PinnedImageSetsNested(int index, MachineConfigNodeSpecPinnedImageSet item) {
            this.index = index;
            this.builder = new MachineConfigNodeSpecPinnedImageSetBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.setToPinnedImageSets(this.index, this.builder.build());
        }

        public N endPinnedImageSet() {
            return this.and();
        }
    }

    public class NodeNested<N>
    extends MCOObjectReferenceFluent<NodeNested<N>>
    implements Nested<N> {
        MCOObjectReferenceBuilder builder;

        NodeNested(MCOObjectReference item) {
            this.builder = new MCOObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.withNode(this.builder.build());
        }

        public N endNode() {
            return this.and();
        }
    }

    public class ConfigVersionNested<N>
    extends MachineConfigNodeSpecMachineConfigVersionFluent<ConfigVersionNested<N>>
    implements Nested<N> {
        MachineConfigNodeSpecMachineConfigVersionBuilder builder;

        ConfigVersionNested(MachineConfigNodeSpecMachineConfigVersion item) {
            this.builder = new MachineConfigNodeSpecMachineConfigVersionBuilder(this, item);
        }

        public N and() {
            return (N)MachineConfigNodeSpecFluent.this.withConfigVersion(this.builder.build());
        }

        public N endConfigVersion() {
            return this.and();
        }
    }
}

