package io.fabric8.openshift.api.model.machineconfig.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ImageRegistryBundleBuilder extends ImageRegistryBundleFluent<ImageRegistryBundleBuilder> implements VisitableBuilder<ImageRegistryBundle,ImageRegistryBundleBuilder>{
  public ImageRegistryBundleBuilder() {
    this(new ImageRegistryBundle());
  }
  
  public ImageRegistryBundleBuilder(ImageRegistryBundleFluent<?> fluent) {
    this(fluent, new ImageRegistryBundle());
  }
  
  public ImageRegistryBundleBuilder(ImageRegistryBundleFluent<?> fluent,ImageRegistryBundle instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ImageRegistryBundleBuilder(ImageRegistryBundle instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ImageRegistryBundleFluent<?> fluent;
  
  public ImageRegistryBundle build() {
    ImageRegistryBundle buildable = new ImageRegistryBundle(fluent.getData(),fluent.getFile());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}