package io.fabric8.openshift.api.model.machine.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GCPEncryptionKeyReferenceFluent<A extends GCPEncryptionKeyReferenceFluent<A>> extends BaseFluent<A>{
  public GCPEncryptionKeyReferenceFluent() {
  }
  
  public GCPEncryptionKeyReferenceFluent(GCPEncryptionKeyReference instance) {
    this.copyInstance(instance);
  }
  private GCPKMSKeyReferenceBuilder kmsKey;
  private String kmsKeyServiceAccount;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GCPEncryptionKeyReference instance) {
    instance = (instance != null ? instance : new GCPEncryptionKeyReference());
    if (instance != null) {
          this.withKmsKey(instance.getKmsKey());
          this.withKmsKeyServiceAccount(instance.getKmsKeyServiceAccount());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public GCPKMSKeyReference buildKmsKey() {
    return this.kmsKey != null ? this.kmsKey.build() : null;
  }
  
  public A withKmsKey(GCPKMSKeyReference kmsKey) {
    this._visitables.remove("kmsKey");
    if (kmsKey != null) {
        this.kmsKey = new GCPKMSKeyReferenceBuilder(kmsKey);
        this._visitables.get("kmsKey").add(this.kmsKey);
    } else {
        this.kmsKey = null;
        this._visitables.get("kmsKey").remove(this.kmsKey);
    }
    return (A) this;
  }
  
  public boolean hasKmsKey() {
    return this.kmsKey != null;
  }
  
  public A withNewKmsKey(String keyRing,String location,String name,String projectID) {
    return (A)withKmsKey(new GCPKMSKeyReference(keyRing, location, name, projectID));
  }
  
  public KmsKeyNested<A> withNewKmsKey() {
    return new KmsKeyNested(null);
  }
  
  public KmsKeyNested<A> withNewKmsKeyLike(GCPKMSKeyReference item) {
    return new KmsKeyNested(item);
  }
  
  public KmsKeyNested<A> editKmsKey() {
    return withNewKmsKeyLike(java.util.Optional.ofNullable(buildKmsKey()).orElse(null));
  }
  
  public KmsKeyNested<A> editOrNewKmsKey() {
    return withNewKmsKeyLike(java.util.Optional.ofNullable(buildKmsKey()).orElse(new GCPKMSKeyReferenceBuilder().build()));
  }
  
  public KmsKeyNested<A> editOrNewKmsKeyLike(GCPKMSKeyReference item) {
    return withNewKmsKeyLike(java.util.Optional.ofNullable(buildKmsKey()).orElse(item));
  }
  
  public String getKmsKeyServiceAccount() {
    return this.kmsKeyServiceAccount;
  }
  
  public A withKmsKeyServiceAccount(String kmsKeyServiceAccount) {
    this.kmsKeyServiceAccount = kmsKeyServiceAccount;
    return (A) this;
  }
  
  public boolean hasKmsKeyServiceAccount() {
    return this.kmsKeyServiceAccount != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GCPEncryptionKeyReferenceFluent that = (GCPEncryptionKeyReferenceFluent) o;
    if (!java.util.Objects.equals(kmsKey, that.kmsKey)) return false;
    if (!java.util.Objects.equals(kmsKeyServiceAccount, that.kmsKeyServiceAccount)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(kmsKey,  kmsKeyServiceAccount,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kmsKey != null) { sb.append("kmsKey:"); sb.append(kmsKey + ","); }
    if (kmsKeyServiceAccount != null) { sb.append("kmsKeyServiceAccount:"); sb.append(kmsKeyServiceAccount + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class KmsKeyNested<N> extends GCPKMSKeyReferenceFluent<KmsKeyNested<N>> implements Nested<N>{
    KmsKeyNested(GCPKMSKeyReference item) {
      this.builder = new GCPKMSKeyReferenceBuilder(this, item);
    }
    GCPKMSKeyReferenceBuilder builder;
    
    public N and() {
      return (N) GCPEncryptionKeyReferenceFluent.this.withKmsKey(builder.build());
    }
    
    public N endKmsKey() {
      return and();
    }
    
  
  }

}