package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class PowerVSMachineProviderConfigFluent<A extends PowerVSMachineProviderConfigFluent<A>> extends BaseFluent<A>{
  public PowerVSMachineProviderConfigFluent() {
  }
  
  public PowerVSMachineProviderConfigFluent(PowerVSMachineProviderConfig instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private PowerVSSecretReferenceBuilder credentialsSecret;
  private PowerVSResourceBuilder image;
  private String keyPairName;
  private String kind;
  private ArrayList<LoadBalancerReferenceBuilder> loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();
  private Integer memoryGiB;
  private ObjectMetaBuilder metadata;
  private PowerVSResourceBuilder network;
  private String processorType;
  private IntOrStringBuilder processors;
  private PowerVSResourceBuilder serviceInstance;
  private String systemType;
  private PowerVSSecretReferenceBuilder userDataSecret;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(PowerVSMachineProviderConfig instance) {
    instance = (instance != null ? instance : new PowerVSMachineProviderConfig());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withCredentialsSecret(instance.getCredentialsSecret());
          this.withImage(instance.getImage());
          this.withKeyPairName(instance.getKeyPairName());
          this.withKind(instance.getKind());
          this.withLoadBalancers(instance.getLoadBalancers());
          this.withMemoryGiB(instance.getMemoryGiB());
          this.withMetadata(instance.getMetadata());
          this.withNetwork(instance.getNetwork());
          this.withProcessorType(instance.getProcessorType());
          this.withProcessors(instance.getProcessors());
          this.withServiceInstance(instance.getServiceInstance());
          this.withSystemType(instance.getSystemType());
          this.withUserDataSecret(instance.getUserDataSecret());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public PowerVSSecretReference buildCredentialsSecret() {
    return this.credentialsSecret != null ? this.credentialsSecret.build() : null;
  }
  
  public A withCredentialsSecret(PowerVSSecretReference credentialsSecret) {
    this._visitables.remove("credentialsSecret");
    if (credentialsSecret != null) {
        this.credentialsSecret = new PowerVSSecretReferenceBuilder(credentialsSecret);
        this._visitables.get("credentialsSecret").add(this.credentialsSecret);
    } else {
        this.credentialsSecret = null;
        this._visitables.get("credentialsSecret").remove(this.credentialsSecret);
    }
    return (A) this;
  }
  
  public boolean hasCredentialsSecret() {
    return this.credentialsSecret != null;
  }
  
  public A withNewCredentialsSecret(String name) {
    return (A)withCredentialsSecret(new PowerVSSecretReference(name));
  }
  
  public CredentialsSecretNested<A> withNewCredentialsSecret() {
    return new CredentialsSecretNested(null);
  }
  
  public CredentialsSecretNested<A> withNewCredentialsSecretLike(PowerVSSecretReference item) {
    return new CredentialsSecretNested(item);
  }
  
  public CredentialsSecretNested<A> editCredentialsSecret() {
    return withNewCredentialsSecretLike(java.util.Optional.ofNullable(buildCredentialsSecret()).orElse(null));
  }
  
  public CredentialsSecretNested<A> editOrNewCredentialsSecret() {
    return withNewCredentialsSecretLike(java.util.Optional.ofNullable(buildCredentialsSecret()).orElse(new PowerVSSecretReferenceBuilder().build()));
  }
  
  public CredentialsSecretNested<A> editOrNewCredentialsSecretLike(PowerVSSecretReference item) {
    return withNewCredentialsSecretLike(java.util.Optional.ofNullable(buildCredentialsSecret()).orElse(item));
  }
  
  public PowerVSResource buildImage() {
    return this.image != null ? this.image.build() : null;
  }
  
  public A withImage(PowerVSResource image) {
    this._visitables.remove("image");
    if (image != null) {
        this.image = new PowerVSResourceBuilder(image);
        this._visitables.get("image").add(this.image);
    } else {
        this.image = null;
        this._visitables.get("image").remove(this.image);
    }
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public A withNewImage(String id,String name,String regex,String type) {
    return (A)withImage(new PowerVSResource(id, name, regex, type));
  }
  
  public ImageNested<A> withNewImage() {
    return new ImageNested(null);
  }
  
  public ImageNested<A> withNewImageLike(PowerVSResource item) {
    return new ImageNested(item);
  }
  
  public ImageNested<A> editImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(null));
  }
  
  public ImageNested<A> editOrNewImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(new PowerVSResourceBuilder().build()));
  }
  
  public ImageNested<A> editOrNewImageLike(PowerVSResource item) {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(item));
  }
  
  public String getKeyPairName() {
    return this.keyPairName;
  }
  
  public A withKeyPairName(String keyPairName) {
    this.keyPairName = keyPairName;
    return (A) this;
  }
  
  public boolean hasKeyPairName() {
    return this.keyPairName != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public A addToLoadBalancers(int index,LoadBalancerReference item) {
    if (this.loadBalancers == null) {this.loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();}
    LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
    if (index < 0 || index >= loadBalancers.size()) {
        _visitables.get("loadBalancers").add(builder);
        loadBalancers.add(builder);
    } else {
        _visitables.get("loadBalancers").add(builder);
        loadBalancers.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToLoadBalancers(int index,LoadBalancerReference item) {
    if (this.loadBalancers == null) {this.loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();}
    LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);
    if (index < 0 || index >= loadBalancers.size()) {
        _visitables.get("loadBalancers").add(builder);
        loadBalancers.add(builder);
    } else {
        _visitables.get("loadBalancers").add(builder);
        loadBalancers.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToLoadBalancers(io.fabric8.openshift.api.model.machine.v1.LoadBalancerReference... items) {
    if (this.loadBalancers == null) {this.loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();}
    for (LoadBalancerReference item : items) {LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);_visitables.get("loadBalancers").add(builder);this.loadBalancers.add(builder);} return (A)this;
  }
  
  public A addAllToLoadBalancers(Collection<LoadBalancerReference> items) {
    if (this.loadBalancers == null) {this.loadBalancers = new ArrayList<LoadBalancerReferenceBuilder>();}
    for (LoadBalancerReference item : items) {LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);_visitables.get("loadBalancers").add(builder);this.loadBalancers.add(builder);} return (A)this;
  }
  
  public A removeFromLoadBalancers(io.fabric8.openshift.api.model.machine.v1.LoadBalancerReference... items) {
    if (this.loadBalancers == null) return (A)this;
    for (LoadBalancerReference item : items) {LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);_visitables.get("loadBalancers").remove(builder); this.loadBalancers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromLoadBalancers(Collection<LoadBalancerReference> items) {
    if (this.loadBalancers == null) return (A)this;
    for (LoadBalancerReference item : items) {LoadBalancerReferenceBuilder builder = new LoadBalancerReferenceBuilder(item);_visitables.get("loadBalancers").remove(builder); this.loadBalancers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromLoadBalancers(Predicate<LoadBalancerReferenceBuilder> predicate) {
    if (loadBalancers == null) return (A) this;
    final Iterator<LoadBalancerReferenceBuilder> each = loadBalancers.iterator();
    final List visitables = _visitables.get("loadBalancers");
    while (each.hasNext()) {
      LoadBalancerReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LoadBalancerReference> buildLoadBalancers() {
    return this.loadBalancers != null ? build(loadBalancers) : null;
  }
  
  public LoadBalancerReference buildLoadBalancer(int index) {
    return this.loadBalancers.get(index).build();
  }
  
  public LoadBalancerReference buildFirstLoadBalancer() {
    return this.loadBalancers.get(0).build();
  }
  
  public LoadBalancerReference buildLastLoadBalancer() {
    return this.loadBalancers.get(loadBalancers.size() - 1).build();
  }
  
  public LoadBalancerReference buildMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
      for (LoadBalancerReferenceBuilder item : loadBalancers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
      for (LoadBalancerReferenceBuilder item : loadBalancers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withLoadBalancers(List<LoadBalancerReference> loadBalancers) {
    if (this.loadBalancers != null) {
      this._visitables.get("loadBalancers").clear();
    }
    if (loadBalancers != null) {
        this.loadBalancers = new ArrayList();
        for (LoadBalancerReference item : loadBalancers) {
          this.addToLoadBalancers(item);
        }
    } else {
      this.loadBalancers = null;
    }
    return (A) this;
  }
  
  public A withLoadBalancers(io.fabric8.openshift.api.model.machine.v1.LoadBalancerReference... loadBalancers) {
    if (this.loadBalancers != null) {
        this.loadBalancers.clear();
        _visitables.remove("loadBalancers");
    }
    if (loadBalancers != null) {
      for (LoadBalancerReference item : loadBalancers) {
        this.addToLoadBalancers(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasLoadBalancers() {
    return this.loadBalancers != null && !this.loadBalancers.isEmpty();
  }
  
  public A addNewLoadBalancer(String name,String type) {
    return (A)addToLoadBalancers(new LoadBalancerReference(name, type));
  }
  
  public LoadBalancersNested<A> addNewLoadBalancer() {
    return new LoadBalancersNested(-1, null);
  }
  
  public LoadBalancersNested<A> addNewLoadBalancerLike(LoadBalancerReference item) {
    return new LoadBalancersNested(-1, item);
  }
  
  public LoadBalancersNested<A> setNewLoadBalancerLike(int index,LoadBalancerReference item) {
    return new LoadBalancersNested(index, item);
  }
  
  public LoadBalancersNested<A> editLoadBalancer(int index) {
    if (loadBalancers.size() <= index) throw new RuntimeException("Can't edit loadBalancers. Index exceeds size.");
    return setNewLoadBalancerLike(index, buildLoadBalancer(index));
  }
  
  public LoadBalancersNested<A> editFirstLoadBalancer() {
    if (loadBalancers.size() == 0) throw new RuntimeException("Can't edit first loadBalancers. The list is empty.");
    return setNewLoadBalancerLike(0, buildLoadBalancer(0));
  }
  
  public LoadBalancersNested<A> editLastLoadBalancer() {
    int index = loadBalancers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last loadBalancers. The list is empty.");
    return setNewLoadBalancerLike(index, buildLoadBalancer(index));
  }
  
  public LoadBalancersNested<A> editMatchingLoadBalancer(Predicate<LoadBalancerReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<loadBalancers.size();i++) { 
    if (predicate.test(loadBalancers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching loadBalancers. No match found.");
    return setNewLoadBalancerLike(index, buildLoadBalancer(index));
  }
  
  public Integer getMemoryGiB() {
    return this.memoryGiB;
  }
  
  public A withMemoryGiB(Integer memoryGiB) {
    this.memoryGiB = memoryGiB;
    return (A) this;
  }
  
  public boolean hasMemoryGiB() {
    return this.memoryGiB != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public PowerVSResource buildNetwork() {
    return this.network != null ? this.network.build() : null;
  }
  
  public A withNetwork(PowerVSResource network) {
    this._visitables.remove("network");
    if (network != null) {
        this.network = new PowerVSResourceBuilder(network);
        this._visitables.get("network").add(this.network);
    } else {
        this.network = null;
        this._visitables.get("network").remove(this.network);
    }
    return (A) this;
  }
  
  public boolean hasNetwork() {
    return this.network != null;
  }
  
  public A withNewNetwork(String id,String name,String regex,String type) {
    return (A)withNetwork(new PowerVSResource(id, name, regex, type));
  }
  
  public NetworkNested<A> withNewNetwork() {
    return new NetworkNested(null);
  }
  
  public NetworkNested<A> withNewNetworkLike(PowerVSResource item) {
    return new NetworkNested(item);
  }
  
  public NetworkNested<A> editNetwork() {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(null));
  }
  
  public NetworkNested<A> editOrNewNetwork() {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(new PowerVSResourceBuilder().build()));
  }
  
  public NetworkNested<A> editOrNewNetworkLike(PowerVSResource item) {
    return withNewNetworkLike(java.util.Optional.ofNullable(buildNetwork()).orElse(item));
  }
  
  public String getProcessorType() {
    return this.processorType;
  }
  
  public A withProcessorType(String processorType) {
    this.processorType = processorType;
    return (A) this;
  }
  
  public boolean hasProcessorType() {
    return this.processorType != null;
  }
  
  public IntOrString buildProcessors() {
    return this.processors != null ? this.processors.build() : null;
  }
  
  public A withProcessors(IntOrString processors) {
    this._visitables.remove("processors");
    if (processors != null) {
        this.processors = new IntOrStringBuilder(processors);
        this._visitables.get("processors").add(this.processors);
    } else {
        this.processors = null;
        this._visitables.get("processors").remove(this.processors);
    }
    return (A) this;
  }
  
  public boolean hasProcessors() {
    return this.processors != null;
  }
  
  public A withNewProcessors(Object value) {
    return (A)withProcessors(new IntOrString(value));
  }
  
  public ProcessorsNested<A> withNewProcessors() {
    return new ProcessorsNested(null);
  }
  
  public ProcessorsNested<A> withNewProcessorsLike(IntOrString item) {
    return new ProcessorsNested(item);
  }
  
  public ProcessorsNested<A> editProcessors() {
    return withNewProcessorsLike(java.util.Optional.ofNullable(buildProcessors()).orElse(null));
  }
  
  public ProcessorsNested<A> editOrNewProcessors() {
    return withNewProcessorsLike(java.util.Optional.ofNullable(buildProcessors()).orElse(new IntOrStringBuilder().build()));
  }
  
  public ProcessorsNested<A> editOrNewProcessorsLike(IntOrString item) {
    return withNewProcessorsLike(java.util.Optional.ofNullable(buildProcessors()).orElse(item));
  }
  
  public PowerVSResource buildServiceInstance() {
    return this.serviceInstance != null ? this.serviceInstance.build() : null;
  }
  
  public A withServiceInstance(PowerVSResource serviceInstance) {
    this._visitables.remove("serviceInstance");
    if (serviceInstance != null) {
        this.serviceInstance = new PowerVSResourceBuilder(serviceInstance);
        this._visitables.get("serviceInstance").add(this.serviceInstance);
    } else {
        this.serviceInstance = null;
        this._visitables.get("serviceInstance").remove(this.serviceInstance);
    }
    return (A) this;
  }
  
  public boolean hasServiceInstance() {
    return this.serviceInstance != null;
  }
  
  public A withNewServiceInstance(String id,String name,String regex,String type) {
    return (A)withServiceInstance(new PowerVSResource(id, name, regex, type));
  }
  
  public ServiceInstanceNested<A> withNewServiceInstance() {
    return new ServiceInstanceNested(null);
  }
  
  public ServiceInstanceNested<A> withNewServiceInstanceLike(PowerVSResource item) {
    return new ServiceInstanceNested(item);
  }
  
  public ServiceInstanceNested<A> editServiceInstance() {
    return withNewServiceInstanceLike(java.util.Optional.ofNullable(buildServiceInstance()).orElse(null));
  }
  
  public ServiceInstanceNested<A> editOrNewServiceInstance() {
    return withNewServiceInstanceLike(java.util.Optional.ofNullable(buildServiceInstance()).orElse(new PowerVSResourceBuilder().build()));
  }
  
  public ServiceInstanceNested<A> editOrNewServiceInstanceLike(PowerVSResource item) {
    return withNewServiceInstanceLike(java.util.Optional.ofNullable(buildServiceInstance()).orElse(item));
  }
  
  public String getSystemType() {
    return this.systemType;
  }
  
  public A withSystemType(String systemType) {
    this.systemType = systemType;
    return (A) this;
  }
  
  public boolean hasSystemType() {
    return this.systemType != null;
  }
  
  public PowerVSSecretReference buildUserDataSecret() {
    return this.userDataSecret != null ? this.userDataSecret.build() : null;
  }
  
  public A withUserDataSecret(PowerVSSecretReference userDataSecret) {
    this._visitables.remove("userDataSecret");
    if (userDataSecret != null) {
        this.userDataSecret = new PowerVSSecretReferenceBuilder(userDataSecret);
        this._visitables.get("userDataSecret").add(this.userDataSecret);
    } else {
        this.userDataSecret = null;
        this._visitables.get("userDataSecret").remove(this.userDataSecret);
    }
    return (A) this;
  }
  
  public boolean hasUserDataSecret() {
    return this.userDataSecret != null;
  }
  
  public A withNewUserDataSecret(String name) {
    return (A)withUserDataSecret(new PowerVSSecretReference(name));
  }
  
  public UserDataSecretNested<A> withNewUserDataSecret() {
    return new UserDataSecretNested(null);
  }
  
  public UserDataSecretNested<A> withNewUserDataSecretLike(PowerVSSecretReference item) {
    return new UserDataSecretNested(item);
  }
  
  public UserDataSecretNested<A> editUserDataSecret() {
    return withNewUserDataSecretLike(java.util.Optional.ofNullable(buildUserDataSecret()).orElse(null));
  }
  
  public UserDataSecretNested<A> editOrNewUserDataSecret() {
    return withNewUserDataSecretLike(java.util.Optional.ofNullable(buildUserDataSecret()).orElse(new PowerVSSecretReferenceBuilder().build()));
  }
  
  public UserDataSecretNested<A> editOrNewUserDataSecretLike(PowerVSSecretReference item) {
    return withNewUserDataSecretLike(java.util.Optional.ofNullable(buildUserDataSecret()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PowerVSMachineProviderConfigFluent that = (PowerVSMachineProviderConfigFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(credentialsSecret, that.credentialsSecret)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(keyPairName, that.keyPairName)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(loadBalancers, that.loadBalancers)) return false;
    if (!java.util.Objects.equals(memoryGiB, that.memoryGiB)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(network, that.network)) return false;
    if (!java.util.Objects.equals(processorType, that.processorType)) return false;
    if (!java.util.Objects.equals(processors, that.processors)) return false;
    if (!java.util.Objects.equals(serviceInstance, that.serviceInstance)) return false;
    if (!java.util.Objects.equals(systemType, that.systemType)) return false;
    if (!java.util.Objects.equals(userDataSecret, that.userDataSecret)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  credentialsSecret,  image,  keyPairName,  kind,  loadBalancers,  memoryGiB,  metadata,  network,  processorType,  processors,  serviceInstance,  systemType,  userDataSecret,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (credentialsSecret != null) { sb.append("credentialsSecret:"); sb.append(credentialsSecret + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (keyPairName != null) { sb.append("keyPairName:"); sb.append(keyPairName + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (loadBalancers != null && !loadBalancers.isEmpty()) { sb.append("loadBalancers:"); sb.append(loadBalancers + ","); }
    if (memoryGiB != null) { sb.append("memoryGiB:"); sb.append(memoryGiB + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (processorType != null) { sb.append("processorType:"); sb.append(processorType + ","); }
    if (processors != null) { sb.append("processors:"); sb.append(processors + ","); }
    if (serviceInstance != null) { sb.append("serviceInstance:"); sb.append(serviceInstance + ","); }
    if (systemType != null) { sb.append("systemType:"); sb.append(systemType + ","); }
    if (userDataSecret != null) { sb.append("userDataSecret:"); sb.append(userDataSecret + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CredentialsSecretNested<N> extends PowerVSSecretReferenceFluent<CredentialsSecretNested<N>> implements Nested<N>{
    CredentialsSecretNested(PowerVSSecretReference item) {
      this.builder = new PowerVSSecretReferenceBuilder(this, item);
    }
    PowerVSSecretReferenceBuilder builder;
    
    public N and() {
      return (N) PowerVSMachineProviderConfigFluent.this.withCredentialsSecret(builder.build());
    }
    
    public N endCredentialsSecret() {
      return and();
    }
    
  
  }
  public class ImageNested<N> extends PowerVSResourceFluent<ImageNested<N>> implements Nested<N>{
    ImageNested(PowerVSResource item) {
      this.builder = new PowerVSResourceBuilder(this, item);
    }
    PowerVSResourceBuilder builder;
    
    public N and() {
      return (N) PowerVSMachineProviderConfigFluent.this.withImage(builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }
  public class LoadBalancersNested<N> extends LoadBalancerReferenceFluent<LoadBalancersNested<N>> implements Nested<N>{
    LoadBalancersNested(int index,LoadBalancerReference item) {
      this.index = index;
      this.builder = new LoadBalancerReferenceBuilder(this, item);
    }
    LoadBalancerReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) PowerVSMachineProviderConfigFluent.this.setToLoadBalancers(index,builder.build());
    }
    
    public N endLoadBalancer() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) PowerVSMachineProviderConfigFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }
  public class NetworkNested<N> extends PowerVSResourceFluent<NetworkNested<N>> implements Nested<N>{
    NetworkNested(PowerVSResource item) {
      this.builder = new PowerVSResourceBuilder(this, item);
    }
    PowerVSResourceBuilder builder;
    
    public N and() {
      return (N) PowerVSMachineProviderConfigFluent.this.withNetwork(builder.build());
    }
    
    public N endNetwork() {
      return and();
    }
    
  
  }
  public class ProcessorsNested<N> extends IntOrStringFluent<ProcessorsNested<N>> implements Nested<N>{
    ProcessorsNested(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    IntOrStringBuilder builder;
    
    public N and() {
      return (N) PowerVSMachineProviderConfigFluent.this.withProcessors(builder.build());
    }
    
    public N endProcessors() {
      return and();
    }
    
  
  }
  public class ServiceInstanceNested<N> extends PowerVSResourceFluent<ServiceInstanceNested<N>> implements Nested<N>{
    ServiceInstanceNested(PowerVSResource item) {
      this.builder = new PowerVSResourceBuilder(this, item);
    }
    PowerVSResourceBuilder builder;
    
    public N and() {
      return (N) PowerVSMachineProviderConfigFluent.this.withServiceInstance(builder.build());
    }
    
    public N endServiceInstance() {
      return and();
    }
    
  
  }
  public class UserDataSecretNested<N> extends PowerVSSecretReferenceFluent<UserDataSecretNested<N>> implements Nested<N>{
    UserDataSecretNested(PowerVSSecretReference item) {
      this.builder = new PowerVSSecretReferenceBuilder(this, item);
    }
    PowerVSSecretReferenceBuilder builder;
    
    public N and() {
      return (N) PowerVSMachineProviderConfigFluent.this.withUserDataSecret(builder.build());
    }
    
    public N endUserDataSecret() {
      return and();
    }
    
  
  }

}