package io.fabric8.openshift.api.model.machine.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NutanixVMStorageConfigBuilder extends NutanixVMStorageConfigFluent<NutanixVMStorageConfigBuilder> implements VisitableBuilder<NutanixVMStorageConfig,NutanixVMStorageConfigBuilder>{
  public NutanixVMStorageConfigBuilder() {
    this(new NutanixVMStorageConfig());
  }
  
  public NutanixVMStorageConfigBuilder(NutanixVMStorageConfigFluent<?> fluent) {
    this(fluent, new NutanixVMStorageConfig());
  }
  
  public NutanixVMStorageConfigBuilder(NutanixVMStorageConfigFluent<?> fluent,NutanixVMStorageConfig instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NutanixVMStorageConfigBuilder(NutanixVMStorageConfig instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NutanixVMStorageConfigFluent<?> fluent;
  
  public NutanixVMStorageConfig build() {
    NutanixVMStorageConfig buildable = new NutanixVMStorageConfig(fluent.getDiskMode(),fluent.buildStorageContainer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}