/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1alpha1.AdditionalBlockDevice;
import io.fabric8.openshift.api.model.machine.v1alpha1.BlockDeviceStorage;
import io.fabric8.openshift.api.model.machine.v1alpha1.BlockDeviceStorageBuilder;
import io.fabric8.openshift.api.model.machine.v1alpha1.BlockDeviceStorageFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AdditionalBlockDeviceFluent<A extends AdditionalBlockDeviceFluent<A>>
extends BaseFluent<A> {
    private String name;
    private Integer sizeGiB;
    private BlockDeviceStorageBuilder storage;
    private Map<String, Object> additionalProperties;

    public AdditionalBlockDeviceFluent() {
    }

    public AdditionalBlockDeviceFluent(AdditionalBlockDevice instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AdditionalBlockDevice instance) {
        AdditionalBlockDevice additionalBlockDevice = instance = instance != null ? instance : new AdditionalBlockDevice();
        if (instance != null) {
            this.withName(instance.getName());
            this.withSizeGiB(instance.getSizeGiB());
            this.withStorage(instance.getStorage());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Integer getSizeGiB() {
        return this.sizeGiB;
    }

    public A withSizeGiB(Integer sizeGiB) {
        this.sizeGiB = sizeGiB;
        return (A)((Object)this);
    }

    public boolean hasSizeGiB() {
        return this.sizeGiB != null;
    }

    public BlockDeviceStorage buildStorage() {
        return this.storage != null ? this.storage.build() : null;
    }

    public A withStorage(BlockDeviceStorage storage) {
        this._visitables.remove((Object)"storage");
        if (storage != null) {
            this.storage = new BlockDeviceStorageBuilder(storage);
            this._visitables.get((Object)"storage").add(this.storage);
        } else {
            this.storage = null;
            this._visitables.get((Object)"storage").remove((Object)this.storage);
        }
        return (A)((Object)this);
    }

    public boolean hasStorage() {
        return this.storage != null;
    }

    public StorageNested<A> withNewStorage() {
        return new StorageNested(null);
    }

    public StorageNested<A> withNewStorageLike(BlockDeviceStorage item) {
        return new StorageNested(item);
    }

    public StorageNested<A> editStorage() {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(null));
    }

    public StorageNested<A> editOrNewStorage() {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(new BlockDeviceStorageBuilder().build()));
    }

    public StorageNested<A> editOrNewStorageLike(BlockDeviceStorage item) {
        return this.withNewStorageLike(Optional.ofNullable(this.buildStorage()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdditionalBlockDeviceFluent that = (AdditionalBlockDeviceFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.sizeGiB, that.sizeGiB)) {
            return false;
        }
        if (!Objects.equals((Object)this.storage, (Object)that.storage)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sizeGiB, this.storage, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.sizeGiB != null) {
            sb.append("sizeGiB:");
            sb.append(this.sizeGiB + ",");
        }
        if (this.storage != null) {
            sb.append("storage:");
            sb.append(this.storage + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StorageNested<N>
    extends BlockDeviceStorageFluent<StorageNested<N>>
    implements Nested<N> {
        BlockDeviceStorageBuilder builder;

        StorageNested(BlockDeviceStorage item) {
            this.builder = new BlockDeviceStorageBuilder(this, item);
        }

        public N and() {
            return (N)AdditionalBlockDeviceFluent.this.withStorage(this.builder.build());
        }

        public N endStorage() {
            return this.and();
        }
    }
}

