/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.nutanix.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.nutanix.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.nutanix.v1.OSDisk;
import io.fabric8.openshift.api.model.installer.nutanix.v1.OSDiskBuilder;
import io.fabric8.openshift.api.model.installer.nutanix.v1.OSDiskFluent;
import io.fabric8.openshift.api.model.machine.v1.NutanixCategory;
import io.fabric8.openshift.api.model.machine.v1.NutanixResourceIdentifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private String bootType;
    private List<NutanixCategory> categories = new ArrayList<NutanixCategory>();
    private Long coresPerSocket;
    private Long cpus;
    private Long memoryMiB;
    private OSDiskBuilder osDisk;
    private NutanixResourceIdentifier project;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withBootType(instance.getBootType());
            this.withCategories(instance.getCategories());
            this.withCoresPerSocket(instance.getCoresPerSocket());
            this.withCpus(instance.getCpus());
            this.withMemoryMiB(instance.getMemoryMiB());
            this.withOsDisk(instance.getOsDisk());
            this.withProject(instance.getProject());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getBootType() {
        return this.bootType;
    }

    public A withBootType(String bootType) {
        this.bootType = bootType;
        return (A)((Object)this);
    }

    public boolean hasBootType() {
        return this.bootType != null;
    }

    public A addToCategories(int index, NutanixCategory item) {
        if (this.categories == null) {
            this.categories = new ArrayList<NutanixCategory>();
        }
        this.categories.add(index, item);
        return (A)((Object)this);
    }

    public A setToCategories(int index, NutanixCategory item) {
        if (this.categories == null) {
            this.categories = new ArrayList<NutanixCategory>();
        }
        this.categories.set(index, item);
        return (A)((Object)this);
    }

    public A addToCategories(NutanixCategory ... items) {
        if (this.categories == null) {
            this.categories = new ArrayList<NutanixCategory>();
        }
        for (NutanixCategory item : items) {
            this.categories.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCategories(Collection<NutanixCategory> items) {
        if (this.categories == null) {
            this.categories = new ArrayList<NutanixCategory>();
        }
        for (NutanixCategory item : items) {
            this.categories.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCategories(NutanixCategory ... items) {
        if (this.categories == null) {
            return (A)((Object)this);
        }
        for (NutanixCategory item : items) {
            this.categories.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCategories(Collection<NutanixCategory> items) {
        if (this.categories == null) {
            return (A)((Object)this);
        }
        for (NutanixCategory item : items) {
            this.categories.remove(item);
        }
        return (A)((Object)this);
    }

    public List<NutanixCategory> getCategories() {
        return this.categories;
    }

    public NutanixCategory getCategory(int index) {
        return this.categories.get(index);
    }

    public NutanixCategory getFirstCategory() {
        return this.categories.get(0);
    }

    public NutanixCategory getLastCategory() {
        return this.categories.get(this.categories.size() - 1);
    }

    public NutanixCategory getMatchingCategory(Predicate<NutanixCategory> predicate) {
        for (NutanixCategory item : this.categories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCategory(Predicate<NutanixCategory> predicate) {
        for (NutanixCategory item : this.categories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCategories(List<NutanixCategory> categories) {
        if (categories != null) {
            this.categories = new ArrayList<NutanixCategory>();
            for (NutanixCategory item : categories) {
                this.addToCategories(item);
            }
        } else {
            this.categories = null;
        }
        return (A)((Object)this);
    }

    public A withCategories(NutanixCategory ... categories) {
        if (this.categories != null) {
            this.categories.clear();
            this._visitables.remove((Object)"categories");
        }
        if (categories != null) {
            for (NutanixCategory item : categories) {
                this.addToCategories(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCategories() {
        return this.categories != null && !this.categories.isEmpty();
    }

    public A addNewCategory(String key, String value) {
        return this.addToCategories(new NutanixCategory(key, value));
    }

    public Long getCoresPerSocket() {
        return this.coresPerSocket;
    }

    public A withCoresPerSocket(Long coresPerSocket) {
        this.coresPerSocket = coresPerSocket;
        return (A)((Object)this);
    }

    public boolean hasCoresPerSocket() {
        return this.coresPerSocket != null;
    }

    public Long getCpus() {
        return this.cpus;
    }

    public A withCpus(Long cpus) {
        this.cpus = cpus;
        return (A)((Object)this);
    }

    public boolean hasCpus() {
        return this.cpus != null;
    }

    public Long getMemoryMiB() {
        return this.memoryMiB;
    }

    public A withMemoryMiB(Long memoryMiB) {
        this.memoryMiB = memoryMiB;
        return (A)((Object)this);
    }

    public boolean hasMemoryMiB() {
        return this.memoryMiB != null;
    }

    public OSDisk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    public A withOsDisk(OSDisk osDisk) {
        this._visitables.remove((Object)"osDisk");
        if (osDisk != null) {
            this.osDisk = new OSDiskBuilder(osDisk);
            this._visitables.get((Object)"osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get((Object)"osDisk").remove((Object)this.osDisk);
        }
        return (A)((Object)this);
    }

    public boolean hasOsDisk() {
        return this.osDisk != null;
    }

    public A withNewOsDisk(Long diskSizeGiB) {
        return this.withOsDisk(new OSDisk(diskSizeGiB));
    }

    public OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNested(null);
    }

    public OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
        return new OsDiskNested(item);
    }

    public OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(null));
    }

    public OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(new OSDiskBuilder().build()));
    }

    public OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(item));
    }

    public NutanixResourceIdentifier getProject() {
        return this.project;
    }

    public A withProject(NutanixResourceIdentifier project) {
        this.project = project;
        return (A)((Object)this);
    }

    public boolean hasProject() {
        return this.project != null;
    }

    public A withNewProject(String name, String type, String uuid) {
        return this.withProject(new NutanixResourceIdentifier(name, type, uuid));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)((Object)o);
        if (!Objects.equals(this.bootType, that.bootType)) {
            return false;
        }
        if (!Objects.equals(this.categories, that.categories)) {
            return false;
        }
        if (!Objects.equals(this.coresPerSocket, that.coresPerSocket)) {
            return false;
        }
        if (!Objects.equals(this.cpus, that.cpus)) {
            return false;
        }
        if (!Objects.equals(this.memoryMiB, that.memoryMiB)) {
            return false;
        }
        if (!Objects.equals((Object)this.osDisk, (Object)that.osDisk)) {
            return false;
        }
        if (!Objects.equals(this.project, that.project)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bootType, this.categories, this.coresPerSocket, this.cpus, this.memoryMiB, this.osDisk, this.project, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.bootType != null) {
            sb.append("bootType:");
            sb.append(this.bootType + ",");
        }
        if (this.categories != null && !this.categories.isEmpty()) {
            sb.append("categories:");
            sb.append(this.categories + ",");
        }
        if (this.coresPerSocket != null) {
            sb.append("coresPerSocket:");
            sb.append(this.coresPerSocket + ",");
        }
        if (this.cpus != null) {
            sb.append("cpus:");
            sb.append(this.cpus + ",");
        }
        if (this.memoryMiB != null) {
            sb.append("memoryMiB:");
            sb.append(this.memoryMiB + ",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append((Object)((Object)this.osDisk) + ",");
        }
        if (this.project != null) {
            sb.append("project:");
            sb.append(this.project + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OsDiskNested<N>
    extends OSDiskFluent<OsDiskNested<N>>
    implements Nested<N> {
        OSDiskBuilder builder;

        OsDiskNested(OSDisk item) {
            this.builder = new OSDiskBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolFluent.this.withOsDisk(this.builder.build());
        }

        public N endOsDisk() {
            return this.and();
        }
    }
}

