/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.Platform;
import io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent;
import io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluentImpl;
import java.util.Objects;

public class PlatformBuilder
extends PlatformFluentImpl<PlatformBuilder>
implements VisitableBuilder<Platform, PlatformBuilder> {
    PlatformFluent<?> fluent;
    Boolean validationEnabled;

    public PlatformBuilder() {
        this(false);
    }

    public PlatformBuilder(Boolean validationEnabled) {
        this(new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Platform(), validationEnabled);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance) {
        this(fluent, instance, false);
    }

    public PlatformBuilder(PlatformFluent<?> fluent, Platform instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAmiID(instance.getAmiID());
        fluent.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        fluent.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
        fluent.withHostedZone(instance.getHostedZone());
        fluent.withRegion(instance.getRegion());
        fluent.withServiceEndpoints(instance.getServiceEndpoints());
        fluent.withSubnets(instance.getSubnets());
        fluent.withUserTags(instance.getUserTags());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public PlatformBuilder(Platform instance) {
        this(instance, (Boolean)false);
    }

    public PlatformBuilder(Platform instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAmiID(instance.getAmiID());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
        this.withHostedZone(instance.getHostedZone());
        this.withRegion(instance.getRegion());
        this.withServiceEndpoints(instance.getServiceEndpoints());
        this.withSubnets(instance.getSubnets());
        this.withUserTags(instance.getUserTags());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public Platform build() {
        Platform buildable = new Platform(this.fluent.getAmiID(), this.fluent.getDefaultMachinePlatform(), this.fluent.getExperimentalPropagateUserTags(), this.fluent.getHostedZone(), this.fluent.getRegion(), this.fluent.getServiceEndpoints(), this.fluent.getSubnets(), this.fluent.getUserTags());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlatformBuilder that = (PlatformBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

