/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.installer.v1.ClusterNetworkEntryFluentImpl;
import io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntry;
import io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryBuilder;
import io.fabric8.openshift.api.model.installer.v1.MachineNetworkEntryFluentImpl;
import io.fabric8.openshift.api.model.installer.v1.Networking;
import io.fabric8.openshift.api.model.installer.v1.NetworkingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkingFluentImpl<A extends NetworkingFluent<A>>
extends BaseFluent<A>
implements NetworkingFluent<A> {
    private List<ClusterNetworkEntryBuilder> clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
    private List<ClusterNetworkEntryBuilder> deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
    private String machineCIDR;
    private List<MachineNetworkEntryBuilder> machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();
    private String networkType;
    private String serviceCIDR;
    private List<String> serviceNetwork = new ArrayList<String>();
    private String type;
    private Map<String, Object> additionalProperties;

    public NetworkingFluentImpl() {
    }

    public NetworkingFluentImpl(Networking instance) {
        this.withClusterNetwork(instance.getClusterNetwork());
        this.withDeprecatedClusterNetworks(instance.getDeprecatedClusterNetworks());
        this.withMachineCIDR(instance.getMachineCIDR());
        this.withMachineNetwork(instance.getMachineNetwork());
        this.withNetworkType(instance.getNetworkType());
        this.withServiceCIDR(instance.getServiceCIDR());
        this.withServiceNetwork(instance.getServiceNetwork());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToClusterNetwork(Integer index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        this._visitables.get((Object)"clusterNetwork").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"clusterNetwork").size(), builder);
        this.clusterNetwork.add(index >= 0 ? index.intValue() : this.clusterNetwork.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClusterNetwork(Integer index, ClusterNetworkEntry item) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"clusterNetwork").size()) {
            this._visitables.get((Object)"clusterNetwork").add(builder);
        } else {
            this._visitables.get((Object)"clusterNetwork").set(index, builder);
        }
        if (index < 0 || index >= this.clusterNetwork.size()) {
            this.clusterNetwork.add(builder);
        } else {
            this.clusterNetwork.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusterNetwork(ClusterNetworkEntry ... items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterNetwork(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetwork == null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").add(builder);
            this.clusterNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterNetwork(ClusterNetworkEntry ... items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").remove(builder);
            if (this.clusterNetwork == null) continue;
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterNetwork(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"clusterNetwork").remove(builder);
            if (this.clusterNetwork == null) continue;
            this.clusterNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetwork == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetwork.iterator();
        List visitables = this._visitables.get((Object)"clusterNetwork");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterNetworkEntry> getClusterNetwork() {
        return NetworkingFluentImpl.build(this.clusterNetwork);
    }

    @Override
    public List<ClusterNetworkEntry> buildClusterNetwork() {
        return NetworkingFluentImpl.build(this.clusterNetwork);
    }

    @Override
    public ClusterNetworkEntry buildClusterNetwork(Integer index) {
        return this.clusterNetwork.get(index).build();
    }

    @Override
    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetwork.get(0).build();
    }

    @Override
    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetwork.get(this.clusterNetwork.size() - 1).build();
    }

    @Override
    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterNetwork(List<ClusterNetworkEntry> clusterNetwork) {
        if (this.clusterNetwork != null) {
            this._visitables.get((Object)"clusterNetwork").removeAll(this.clusterNetwork);
        }
        if (clusterNetwork != null) {
            this.clusterNetwork = new ArrayList<ClusterNetworkEntryBuilder>();
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        } else {
            this.clusterNetwork = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterNetwork(ClusterNetworkEntry ... clusterNetwork) {
        if (this.clusterNetwork != null) {
            this.clusterNetwork.clear();
        }
        if (clusterNetwork != null) {
            for (ClusterNetworkEntry item : clusterNetwork) {
                this.addToClusterNetwork(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterNetwork() {
        return this.clusterNetwork != null && !this.clusterNetwork.isEmpty();
    }

    @Override
    public A addNewClusterNetwork(String cidr, Integer hostPrefix, Integer hostSubnetLength) {
        return this.addToClusterNetwork(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
    }

    @Override
    public NetworkingFluent.ClusterNetworkNested<A> addNewClusterNetwork() {
        return new ClusterNetworkNestedImpl();
    }

    @Override
    public NetworkingFluent.ClusterNetworkNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworkNestedImpl(-1, item);
    }

    @Override
    public NetworkingFluent.ClusterNetworkNested<A> setNewClusterNetworkLike(Integer index, ClusterNetworkEntry item) {
        return new ClusterNetworkNestedImpl(index, item);
    }

    @Override
    public NetworkingFluent.ClusterNetworkNested<A> editClusterNetwork(Integer index) {
        if (this.clusterNetwork.size() <= index) {
            throw new RuntimeException("Can't edit clusterNetwork. Index exceeds size.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public NetworkingFluent.ClusterNetworkNested<A> editFirstClusterNetwork() {
        if (this.clusterNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    @Override
    public NetworkingFluent.ClusterNetworkNested<A> editLastClusterNetwork() {
        int index = this.clusterNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterNetwork. The list is empty.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public NetworkingFluent.ClusterNetworkNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetwork.size(); ++i) {
            if (!predicate.test(this.clusterNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterNetwork. No match found.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public A addToDeprecatedClusterNetworks(Integer index, ClusterNetworkEntry item) {
        if (this.deprecatedClusterNetworks == null) {
            this.deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        this._visitables.get((Object)"deprecatedClusterNetworks").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"deprecatedClusterNetworks").size(), builder);
        this.deprecatedClusterNetworks.add(index >= 0 ? index.intValue() : this.deprecatedClusterNetworks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToDeprecatedClusterNetworks(Integer index, ClusterNetworkEntry item) {
        if (this.deprecatedClusterNetworks == null) {
            this.deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"deprecatedClusterNetworks").size()) {
            this._visitables.get((Object)"deprecatedClusterNetworks").add(builder);
        } else {
            this._visitables.get((Object)"deprecatedClusterNetworks").set(index, builder);
        }
        if (index < 0 || index >= this.deprecatedClusterNetworks.size()) {
            this.deprecatedClusterNetworks.add(builder);
        } else {
            this.deprecatedClusterNetworks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToDeprecatedClusterNetworks(ClusterNetworkEntry ... items) {
        if (this.deprecatedClusterNetworks == null) {
            this.deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"deprecatedClusterNetworks").add(builder);
            this.deprecatedClusterNetworks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToDeprecatedClusterNetworks(Collection<ClusterNetworkEntry> items) {
        if (this.deprecatedClusterNetworks == null) {
            this.deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"deprecatedClusterNetworks").add(builder);
            this.deprecatedClusterNetworks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromDeprecatedClusterNetworks(ClusterNetworkEntry ... items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"deprecatedClusterNetworks").remove(builder);
            if (this.deprecatedClusterNetworks == null) continue;
            this.deprecatedClusterNetworks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDeprecatedClusterNetworks(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get((Object)"deprecatedClusterNetworks").remove(builder);
            if (this.deprecatedClusterNetworks == null) continue;
            this.deprecatedClusterNetworks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromDeprecatedClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.deprecatedClusterNetworks == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.deprecatedClusterNetworks.iterator();
        List visitables = this._visitables.get((Object)"deprecatedClusterNetworks");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterNetworkEntry> getDeprecatedClusterNetworks() {
        return NetworkingFluentImpl.build(this.deprecatedClusterNetworks);
    }

    @Override
    public List<ClusterNetworkEntry> buildDeprecatedClusterNetworks() {
        return NetworkingFluentImpl.build(this.deprecatedClusterNetworks);
    }

    @Override
    public ClusterNetworkEntry buildDeprecatedClusterNetwork(Integer index) {
        return this.deprecatedClusterNetworks.get(index).build();
    }

    @Override
    public ClusterNetworkEntry buildFirstDeprecatedClusterNetwork() {
        return this.deprecatedClusterNetworks.get(0).build();
    }

    @Override
    public ClusterNetworkEntry buildLastDeprecatedClusterNetwork() {
        return this.deprecatedClusterNetworks.get(this.deprecatedClusterNetworks.size() - 1).build();
    }

    @Override
    public ClusterNetworkEntry buildMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.deprecatedClusterNetworks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.deprecatedClusterNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDeprecatedClusterNetworks(List<ClusterNetworkEntry> deprecatedClusterNetworks) {
        if (this.deprecatedClusterNetworks != null) {
            this._visitables.get((Object)"deprecatedClusterNetworks").removeAll(this.deprecatedClusterNetworks);
        }
        if (deprecatedClusterNetworks != null) {
            this.deprecatedClusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
            for (ClusterNetworkEntry item : deprecatedClusterNetworks) {
                this.addToDeprecatedClusterNetworks(item);
            }
        } else {
            this.deprecatedClusterNetworks = null;
        }
        return (A)this;
    }

    @Override
    public A withDeprecatedClusterNetworks(ClusterNetworkEntry ... deprecatedClusterNetworks) {
        if (this.deprecatedClusterNetworks != null) {
            this.deprecatedClusterNetworks.clear();
        }
        if (deprecatedClusterNetworks != null) {
            for (ClusterNetworkEntry item : deprecatedClusterNetworks) {
                this.addToDeprecatedClusterNetworks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedClusterNetworks() {
        return this.deprecatedClusterNetworks != null && !this.deprecatedClusterNetworks.isEmpty();
    }

    @Override
    public A addNewDeprecatedClusterNetwork(String cidr, Integer hostPrefix, Integer hostSubnetLength) {
        return this.addToDeprecatedClusterNetworks(new ClusterNetworkEntry(cidr, hostPrefix, hostSubnetLength));
    }

    @Override
    public NetworkingFluent.DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetwork() {
        return new DeprecatedClusterNetworksNestedImpl();
    }

    @Override
    public NetworkingFluent.DeprecatedClusterNetworksNested<A> addNewDeprecatedClusterNetworkLike(ClusterNetworkEntry item) {
        return new DeprecatedClusterNetworksNestedImpl(-1, item);
    }

    @Override
    public NetworkingFluent.DeprecatedClusterNetworksNested<A> setNewDeprecatedClusterNetworkLike(Integer index, ClusterNetworkEntry item) {
        return new DeprecatedClusterNetworksNestedImpl(index, item);
    }

    @Override
    public NetworkingFluent.DeprecatedClusterNetworksNested<A> editDeprecatedClusterNetwork(Integer index) {
        if (this.deprecatedClusterNetworks.size() <= index) {
            throw new RuntimeException("Can't edit deprecatedClusterNetworks. Index exceeds size.");
        }
        return this.setNewDeprecatedClusterNetworkLike(index, this.buildDeprecatedClusterNetwork(index));
    }

    @Override
    public NetworkingFluent.DeprecatedClusterNetworksNested<A> editFirstDeprecatedClusterNetwork() {
        if (this.deprecatedClusterNetworks.size() == 0) {
            throw new RuntimeException("Can't edit first deprecatedClusterNetworks. The list is empty.");
        }
        return this.setNewDeprecatedClusterNetworkLike(0, this.buildDeprecatedClusterNetwork(0));
    }

    @Override
    public NetworkingFluent.DeprecatedClusterNetworksNested<A> editLastDeprecatedClusterNetwork() {
        int index = this.deprecatedClusterNetworks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last deprecatedClusterNetworks. The list is empty.");
        }
        return this.setNewDeprecatedClusterNetworkLike(index, this.buildDeprecatedClusterNetwork(index));
    }

    @Override
    public NetworkingFluent.DeprecatedClusterNetworksNested<A> editMatchingDeprecatedClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.deprecatedClusterNetworks.size(); ++i) {
            if (!predicate.test(this.deprecatedClusterNetworks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching deprecatedClusterNetworks. No match found.");
        }
        return this.setNewDeprecatedClusterNetworkLike(index, this.buildDeprecatedClusterNetwork(index));
    }

    @Override
    public String getMachineCIDR() {
        return this.machineCIDR;
    }

    @Override
    public A withMachineCIDR(String machineCIDR) {
        this.machineCIDR = machineCIDR;
        return (A)this;
    }

    @Override
    public Boolean hasMachineCIDR() {
        return this.machineCIDR != null;
    }

    @Override
    @Deprecated
    public A withNewMachineCIDR(String arg0) {
        return this.withMachineCIDR(new String(arg0));
    }

    @Override
    public A addToMachineNetwork(Integer index, MachineNetworkEntry item) {
        if (this.machineNetwork == null) {
            this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();
        }
        MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
        this._visitables.get((Object)"machineNetwork").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"machineNetwork").size(), builder);
        this.machineNetwork.add(index >= 0 ? index.intValue() : this.machineNetwork.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMachineNetwork(Integer index, MachineNetworkEntry item) {
        if (this.machineNetwork == null) {
            this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();
        }
        MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"machineNetwork").size()) {
            this._visitables.get((Object)"machineNetwork").add(builder);
        } else {
            this._visitables.get((Object)"machineNetwork").set(index, builder);
        }
        if (index < 0 || index >= this.machineNetwork.size()) {
            this.machineNetwork.add(builder);
        } else {
            this.machineNetwork.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMachineNetwork(MachineNetworkEntry ... items) {
        if (this.machineNetwork == null) {
            this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();
        }
        for (MachineNetworkEntry item : items) {
            MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
            this._visitables.get((Object)"machineNetwork").add(builder);
            this.machineNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMachineNetwork(Collection<MachineNetworkEntry> items) {
        if (this.machineNetwork == null) {
            this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();
        }
        for (MachineNetworkEntry item : items) {
            MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
            this._visitables.get((Object)"machineNetwork").add(builder);
            this.machineNetwork.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMachineNetwork(MachineNetworkEntry ... items) {
        for (MachineNetworkEntry item : items) {
            MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
            this._visitables.get((Object)"machineNetwork").remove(builder);
            if (this.machineNetwork == null) continue;
            this.machineNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMachineNetwork(Collection<MachineNetworkEntry> items) {
        for (MachineNetworkEntry item : items) {
            MachineNetworkEntryBuilder builder = new MachineNetworkEntryBuilder(item);
            this._visitables.get((Object)"machineNetwork").remove(builder);
            if (this.machineNetwork == null) continue;
            this.machineNetwork.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
        if (this.machineNetwork == null) {
            return (A)this;
        }
        Iterator<MachineNetworkEntryBuilder> each = this.machineNetwork.iterator();
        List visitables = this._visitables.get((Object)"machineNetwork");
        while (each.hasNext()) {
            MachineNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<MachineNetworkEntry> getMachineNetwork() {
        return NetworkingFluentImpl.build(this.machineNetwork);
    }

    @Override
    public List<MachineNetworkEntry> buildMachineNetwork() {
        return NetworkingFluentImpl.build(this.machineNetwork);
    }

    @Override
    public MachineNetworkEntry buildMachineNetwork(Integer index) {
        return this.machineNetwork.get(index).build();
    }

    @Override
    public MachineNetworkEntry buildFirstMachineNetwork() {
        return this.machineNetwork.get(0).build();
    }

    @Override
    public MachineNetworkEntry buildLastMachineNetwork() {
        return this.machineNetwork.get(this.machineNetwork.size() - 1).build();
    }

    @Override
    public MachineNetworkEntry buildMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
        for (MachineNetworkEntryBuilder item : this.machineNetwork) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
        for (MachineNetworkEntryBuilder item : this.machineNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMachineNetwork(List<MachineNetworkEntry> machineNetwork) {
        if (this.machineNetwork != null) {
            this._visitables.get((Object)"machineNetwork").removeAll(this.machineNetwork);
        }
        if (machineNetwork != null) {
            this.machineNetwork = new ArrayList<MachineNetworkEntryBuilder>();
            for (MachineNetworkEntry item : machineNetwork) {
                this.addToMachineNetwork(item);
            }
        } else {
            this.machineNetwork = null;
        }
        return (A)this;
    }

    @Override
    public A withMachineNetwork(MachineNetworkEntry ... machineNetwork) {
        if (this.machineNetwork != null) {
            this.machineNetwork.clear();
        }
        if (machineNetwork != null) {
            for (MachineNetworkEntry item : machineNetwork) {
                this.addToMachineNetwork(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMachineNetwork() {
        return this.machineNetwork != null && !this.machineNetwork.isEmpty();
    }

    @Override
    public A addNewMachineNetwork(String cidr) {
        return this.addToMachineNetwork(new MachineNetworkEntry(cidr));
    }

    @Override
    public NetworkingFluent.MachineNetworkNested<A> addNewMachineNetwork() {
        return new MachineNetworkNestedImpl();
    }

    @Override
    public NetworkingFluent.MachineNetworkNested<A> addNewMachineNetworkLike(MachineNetworkEntry item) {
        return new MachineNetworkNestedImpl(-1, item);
    }

    @Override
    public NetworkingFluent.MachineNetworkNested<A> setNewMachineNetworkLike(Integer index, MachineNetworkEntry item) {
        return new MachineNetworkNestedImpl(index, item);
    }

    @Override
    public NetworkingFluent.MachineNetworkNested<A> editMachineNetwork(Integer index) {
        if (this.machineNetwork.size() <= index) {
            throw new RuntimeException("Can't edit machineNetwork. Index exceeds size.");
        }
        return this.setNewMachineNetworkLike(index, this.buildMachineNetwork(index));
    }

    @Override
    public NetworkingFluent.MachineNetworkNested<A> editFirstMachineNetwork() {
        if (this.machineNetwork.size() == 0) {
            throw new RuntimeException("Can't edit first machineNetwork. The list is empty.");
        }
        return this.setNewMachineNetworkLike(0, this.buildMachineNetwork(0));
    }

    @Override
    public NetworkingFluent.MachineNetworkNested<A> editLastMachineNetwork() {
        int index = this.machineNetwork.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last machineNetwork. The list is empty.");
        }
        return this.setNewMachineNetworkLike(index, this.buildMachineNetwork(index));
    }

    @Override
    public NetworkingFluent.MachineNetworkNested<A> editMatchingMachineNetwork(Predicate<MachineNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.machineNetwork.size(); ++i) {
            if (!predicate.test(this.machineNetwork.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching machineNetwork. No match found.");
        }
        return this.setNewMachineNetworkLike(index, this.buildMachineNetwork(index));
    }

    @Override
    public String getNetworkType() {
        return this.networkType;
    }

    @Override
    public A withNetworkType(String networkType) {
        this.networkType = networkType;
        return (A)this;
    }

    @Override
    public Boolean hasNetworkType() {
        return this.networkType != null;
    }

    @Override
    @Deprecated
    public A withNewNetworkType(String arg0) {
        return this.withNetworkType(new String(arg0));
    }

    @Override
    public String getServiceCIDR() {
        return this.serviceCIDR;
    }

    @Override
    public A withServiceCIDR(String serviceCIDR) {
        this.serviceCIDR = serviceCIDR;
        return (A)this;
    }

    @Override
    public Boolean hasServiceCIDR() {
        return this.serviceCIDR != null;
    }

    @Override
    @Deprecated
    public A withNewServiceCIDR(String arg0) {
        return this.withServiceCIDR(new String(arg0));
    }

    @Override
    public A addToServiceNetwork(Integer index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServiceNetwork(Integer index, String item) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        this.serviceNetwork.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServiceNetwork(String ... items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceNetwork(Collection<String> items) {
        if (this.serviceNetwork == null) {
            this.serviceNetwork = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceNetwork.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceNetwork(String ... items) {
        for (String item : items) {
            if (this.serviceNetwork == null) continue;
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceNetwork(Collection<String> items) {
        for (String item : items) {
            if (this.serviceNetwork == null) continue;
            this.serviceNetwork.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServiceNetwork() {
        return this.serviceNetwork;
    }

    @Override
    public String getServiceNetwork(Integer index) {
        return this.serviceNetwork.get(index);
    }

    @Override
    public String getFirstServiceNetwork() {
        return this.serviceNetwork.get(0);
    }

    @Override
    public String getLastServiceNetwork() {
        return this.serviceNetwork.get(this.serviceNetwork.size() - 1);
    }

    @Override
    public String getMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceNetwork(Predicate<String> predicate) {
        for (String item : this.serviceNetwork) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceNetwork(List<String> serviceNetwork) {
        if (serviceNetwork != null) {
            this.serviceNetwork = new ArrayList<String>();
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        } else {
            this.serviceNetwork = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceNetwork(String ... serviceNetwork) {
        if (this.serviceNetwork != null) {
            this.serviceNetwork.clear();
        }
        if (serviceNetwork != null) {
            for (String item : serviceNetwork) {
                this.addToServiceNetwork(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceNetwork() {
        return this.serviceNetwork != null && !this.serviceNetwork.isEmpty();
    }

    @Override
    public A addNewServiceNetwork(String arg0) {
        return this.addToServiceNetwork(new String(arg0));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    @Deprecated
    public A withNewType(String arg0) {
        return this.withType(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkingFluentImpl that = (NetworkingFluentImpl)o;
        if (this.clusterNetwork != null ? !this.clusterNetwork.equals(that.clusterNetwork) : that.clusterNetwork != null) {
            return false;
        }
        if (this.deprecatedClusterNetworks != null ? !this.deprecatedClusterNetworks.equals(that.deprecatedClusterNetworks) : that.deprecatedClusterNetworks != null) {
            return false;
        }
        if (this.machineCIDR != null ? !this.machineCIDR.equals(that.machineCIDR) : that.machineCIDR != null) {
            return false;
        }
        if (this.machineNetwork != null ? !this.machineNetwork.equals(that.machineNetwork) : that.machineNetwork != null) {
            return false;
        }
        if (this.networkType != null ? !this.networkType.equals(that.networkType) : that.networkType != null) {
            return false;
        }
        if (this.serviceCIDR != null ? !this.serviceCIDR.equals(that.serviceCIDR) : that.serviceCIDR != null) {
            return false;
        }
        if (this.serviceNetwork != null ? !this.serviceNetwork.equals(that.serviceNetwork) : that.serviceNetwork != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.clusterNetwork, this.deprecatedClusterNetworks, this.machineCIDR, this.machineNetwork, this.networkType, this.serviceCIDR, this.serviceNetwork, this.type, this.additionalProperties, super.hashCode());
    }

    public class MachineNetworkNestedImpl<N>
    extends MachineNetworkEntryFluentImpl<NetworkingFluent.MachineNetworkNested<N>>
    implements NetworkingFluent.MachineNetworkNested<N>,
    Nested<N> {
        MachineNetworkEntryBuilder builder;
        Integer index;

        MachineNetworkNestedImpl(Integer index, MachineNetworkEntry item) {
            this.index = index;
            this.builder = new MachineNetworkEntryBuilder(this, item);
        }

        MachineNetworkNestedImpl() {
            this.index = -1;
            this.builder = new MachineNetworkEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkingFluentImpl.this.setToMachineNetwork(this.index, this.builder.build());
        }

        @Override
        public N endMachineNetwork() {
            return this.and();
        }
    }

    public class DeprecatedClusterNetworksNestedImpl<N>
    extends ClusterNetworkEntryFluentImpl<NetworkingFluent.DeprecatedClusterNetworksNested<N>>
    implements NetworkingFluent.DeprecatedClusterNetworksNested<N>,
    Nested<N> {
        ClusterNetworkEntryBuilder builder;
        Integer index;

        DeprecatedClusterNetworksNestedImpl(Integer index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        DeprecatedClusterNetworksNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkingFluentImpl.this.setToDeprecatedClusterNetworks(this.index, this.builder.build());
        }

        @Override
        public N endDeprecatedClusterNetwork() {
            return this.and();
        }
    }

    public class ClusterNetworkNestedImpl<N>
    extends ClusterNetworkEntryFluentImpl<NetworkingFluent.ClusterNetworkNested<N>>
    implements NetworkingFluent.ClusterNetworkNested<N>,
    Nested<N> {
        ClusterNetworkEntryBuilder builder;
        Integer index;

        ClusterNetworkNestedImpl(Integer index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        ClusterNetworkNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkingFluentImpl.this.setToClusterNetwork(this.index, this.builder.build());
        }

        @Override
        public N endClusterNetwork() {
            return this.and();
        }
    }
}

