/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.ovirt.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.ovirt.v1.CPU;
import io.fabric8.openshift.api.model.installer.ovirt.v1.CPUFluent;
import io.fabric8.openshift.api.model.installer.ovirt.v1.CPUFluentImpl;
import java.util.Objects;

public class CPUBuilder
extends CPUFluentImpl<CPUBuilder>
implements VisitableBuilder<CPU, CPUBuilder> {
    CPUFluent<?> fluent;
    Boolean validationEnabled;

    public CPUBuilder() {
        this(false);
    }

    public CPUBuilder(Boolean validationEnabled) {
        this(new CPU(), validationEnabled);
    }

    public CPUBuilder(CPUFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CPUBuilder(CPUFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CPU(), validationEnabled);
    }

    public CPUBuilder(CPUFluent<?> fluent, CPU instance) {
        this(fluent, instance, false);
    }

    public CPUBuilder(CPUFluent<?> fluent, CPU instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCores(instance.getCores());
        fluent.withSockets(instance.getSockets());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public CPUBuilder(CPU instance) {
        this(instance, (Boolean)false);
    }

    public CPUBuilder(CPU instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCores(instance.getCores());
        this.withSockets(instance.getSockets());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public CPU build() {
        CPU buildable = new CPU(this.fluent.getCores(), this.fluent.getSockets());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CPUBuilder that = (CPUBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

