/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.aws.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.aws.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.installer.aws.v1.Platform;
import io.fabric8.openshift.api.model.installer.aws.v1.PlatformFluent;
import io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpoint;
import io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointBuilder;
import io.fabric8.openshift.api.model.installer.aws.v1.ServiceEndpointFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private String amiID;
    private MachinePoolBuilder defaultMachinePlatform;
    private Boolean experimentalPropagateUserTags;
    private String hostedZone;
    private String region;
    private List<ServiceEndpointBuilder> serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();
    private List<String> subnets = new ArrayList<String>();
    private Map<String, String> userTags;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withAmiID(instance.getAmiID());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withExperimentalPropagateUserTags(instance.getExperimentalPropagateUserTags());
        this.withHostedZone(instance.getHostedZone());
        this.withRegion(instance.getRegion());
        this.withServiceEndpoints(instance.getServiceEndpoints());
        this.withSubnets(instance.getSubnets());
        this.withUserTags(instance.getUserTags());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getAmiID() {
        return this.amiID;
    }

    @Override
    public A withAmiID(String amiID) {
        this.amiID = amiID;
        return (A)this;
    }

    @Override
    public Boolean hasAmiID() {
        return this.amiID != null;
    }

    @Override
    @Deprecated
    public A withNewAmiID(String arg0) {
        return this.withAmiID(new String(arg0));
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get((Object)"defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get((Object)"defaultMachinePlatform").add(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    public Boolean getExperimentalPropagateUserTags() {
        return this.experimentalPropagateUserTags;
    }

    @Override
    public A withExperimentalPropagateUserTags(Boolean experimentalPropagateUserTags) {
        this.experimentalPropagateUserTags = experimentalPropagateUserTags;
        return (A)this;
    }

    @Override
    public Boolean hasExperimentalPropagateUserTags() {
        return this.experimentalPropagateUserTags != null;
    }

    @Override
    public String getHostedZone() {
        return this.hostedZone;
    }

    @Override
    public A withHostedZone(String hostedZone) {
        this.hostedZone = hostedZone;
        return (A)this;
    }

    @Override
    public Boolean hasHostedZone() {
        return this.hostedZone != null;
    }

    @Override
    @Deprecated
    public A withNewHostedZone(String arg0) {
        return this.withHostedZone(new String(arg0));
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    @Deprecated
    public A withNewRegion(String arg0) {
        return this.withRegion(new String(arg0));
    }

    @Override
    public A addToServiceEndpoints(Integer index, ServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();
        }
        ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
        this._visitables.get((Object)"serviceEndpoints").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"serviceEndpoints").size(), builder);
        this.serviceEndpoints.add(index >= 0 ? index.intValue() : this.serviceEndpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServiceEndpoints(Integer index, ServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();
        }
        ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"serviceEndpoints").size()) {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
        } else {
            this._visitables.get((Object)"serviceEndpoints").set(index, builder);
        }
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this.serviceEndpoints.add(builder);
        } else {
            this.serviceEndpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServiceEndpoints(ServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceEndpoints(Collection<ServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();
        }
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceEndpoints(ServiceEndpoint ... items) {
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove(builder);
            if (this.serviceEndpoints == null) continue;
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceEndpoints(Collection<ServiceEndpoint> items) {
        for (ServiceEndpoint item : items) {
            ServiceEndpointBuilder builder = new ServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove(builder);
            if (this.serviceEndpoints == null) continue;
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServiceEndpoints(Predicate<ServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        Iterator<ServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        List visitables = this._visitables.get((Object)"serviceEndpoints");
        while (each.hasNext()) {
            ServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServiceEndpoint> getServiceEndpoints() {
        return PlatformFluentImpl.build(this.serviceEndpoints);
    }

    @Override
    public List<ServiceEndpoint> buildServiceEndpoints() {
        return PlatformFluentImpl.build(this.serviceEndpoints);
    }

    @Override
    public ServiceEndpoint buildServiceEndpoint(Integer index) {
        return this.serviceEndpoints.get(index).build();
    }

    @Override
    public ServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    @Override
    public ServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    @Override
    public ServiceEndpoint buildMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        for (ServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        for (ServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceEndpoints(List<ServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get((Object)"serviceEndpoints").removeAll(this.serviceEndpoints);
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList<ServiceEndpointBuilder>();
            for (ServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceEndpoints(ServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
        }
        if (serviceEndpoints != null) {
            for (ServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    @Override
    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new ServiceEndpoint(name, url));
    }

    @Override
    public PlatformFluent.ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNestedImpl();
    }

    @Override
    public PlatformFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(ServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(-1, item);
    }

    @Override
    public PlatformFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(Integer index, ServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(index, item);
    }

    @Override
    public PlatformFluent.ServiceEndpointsNested<A> editServiceEndpoint(Integer index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public PlatformFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    @Override
    public PlatformFluent.ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public PlatformFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<ServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public A addToSubnets(Integer index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSubnets(Integer index, String item) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        this.subnets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSubnets(String ... items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubnets(Collection<String> items) {
        if (this.subnets == null) {
            this.subnets = new ArrayList<String>();
        }
        for (String item : items) {
            this.subnets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubnets(String ... items) {
        for (String item : items) {
            if (this.subnets == null) continue;
            this.subnets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubnets(Collection<String> items) {
        for (String item : items) {
            if (this.subnets == null) continue;
            this.subnets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSubnets() {
        return this.subnets;
    }

    @Override
    public String getSubnet(Integer index) {
        return this.subnets.get(index);
    }

    @Override
    public String getFirstSubnet() {
        return this.subnets.get(0);
    }

    @Override
    public String getLastSubnet() {
        return this.subnets.get(this.subnets.size() - 1);
    }

    @Override
    public String getMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubnet(Predicate<String> predicate) {
        for (String item : this.subnets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubnets(List<String> subnets) {
        if (subnets != null) {
            this.subnets = new ArrayList<String>();
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        } else {
            this.subnets = null;
        }
        return (A)this;
    }

    @Override
    public A withSubnets(String ... subnets) {
        if (this.subnets != null) {
            this.subnets.clear();
        }
        if (subnets != null) {
            for (String item : subnets) {
                this.addToSubnets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubnets() {
        return this.subnets != null && !this.subnets.isEmpty();
    }

    @Override
    public A addNewSubnet(String arg0) {
        return this.addToSubnets(new String(arg0));
    }

    @Override
    public A addToUserTags(String key, String value) {
        if (this.userTags == null && key != null && value != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.userTags.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUserTags(Map<String, String> map) {
        if (this.userTags == null && map != null) {
            this.userTags = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.userTags.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUserTags(String key) {
        if (this.userTags == null) {
            return (A)this;
        }
        if (key != null && this.userTags != null) {
            this.userTags.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUserTags(Map<String, String> map) {
        if (this.userTags == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.userTags == null) continue;
                this.userTags.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getUserTags() {
        return this.userTags;
    }

    @Override
    public <K, V> A withUserTags(Map<String, String> userTags) {
        this.userTags = userTags == null ? null : new LinkedHashMap<String, String>(userTags);
        return (A)this;
    }

    @Override
    public Boolean hasUserTags() {
        return this.userTags != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.amiID != null ? !this.amiID.equals(that.amiID) : that.amiID != null) {
            return false;
        }
        if (this.defaultMachinePlatform != null ? !this.defaultMachinePlatform.equals(that.defaultMachinePlatform) : that.defaultMachinePlatform != null) {
            return false;
        }
        if (this.experimentalPropagateUserTags != null ? !this.experimentalPropagateUserTags.equals(that.experimentalPropagateUserTags) : that.experimentalPropagateUserTags != null) {
            return false;
        }
        if (this.hostedZone != null ? !this.hostedZone.equals(that.hostedZone) : that.hostedZone != null) {
            return false;
        }
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        if (this.serviceEndpoints != null ? !this.serviceEndpoints.equals(that.serviceEndpoints) : that.serviceEndpoints != null) {
            return false;
        }
        if (this.subnets != null ? !this.subnets.equals(that.subnets) : that.subnets != null) {
            return false;
        }
        if (this.userTags != null ? !this.userTags.equals(that.userTags) : that.userTags != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.amiID, this.defaultMachinePlatform, this.experimentalPropagateUserTags, this.hostedZone, this.region, this.serviceEndpoints, this.subnets, this.userTags, this.additionalProperties, super.hashCode());
    }

    public class ServiceEndpointsNestedImpl<N>
    extends ServiceEndpointFluentImpl<PlatformFluent.ServiceEndpointsNested<N>>
    implements PlatformFluent.ServiceEndpointsNested<N>,
    Nested<N> {
        ServiceEndpointBuilder builder;
        Integer index;

        ServiceEndpointsNestedImpl(Integer index, ServiceEndpoint item) {
            this.index = index;
            this.builder = new ServiceEndpointBuilder(this, item);
        }

        ServiceEndpointsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceEndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endServiceEndpoint() {
            return this.and();
        }
    }

    public class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

