/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.openshift.api.model.hive.v1.AWSAssociatedVPC;
import io.fabric8.openshift.api.model.hive.v1.AWSAssociatedVPCBuilder;
import io.fabric8.openshift.api.model.hive.v1.AWSAssociatedVPCFluent;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfig;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventory;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryBuilder;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkInventoryFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AWSPrivateLinkConfigFluent<A extends AWSPrivateLinkConfigFluent<A>>
extends BaseFluent<A> {
    private ArrayList<AWSAssociatedVPCBuilder> associatedVPCs = new ArrayList();
    private LocalObjectReferenceBuilder credentialsSecretRef;
    private String dnsRecordType;
    private ArrayList<AWSPrivateLinkInventoryBuilder> endpointVPCInventory = new ArrayList();
    private Map<String, Object> additionalProperties;

    public AWSPrivateLinkConfigFluent() {
    }

    public AWSPrivateLinkConfigFluent(AWSPrivateLinkConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(AWSPrivateLinkConfig instance) {
        AWSPrivateLinkConfig aWSPrivateLinkConfig = instance = instance != null ? instance : new AWSPrivateLinkConfig();
        if (instance != null) {
            this.withAssociatedVPCs(instance.getAssociatedVPCs());
            this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
            this.withDnsRecordType(instance.getDnsRecordType());
            this.withEndpointVPCInventory(instance.getEndpointVPCInventory());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAssociatedVPCs(int index, AWSAssociatedVPC item) {
        if (this.associatedVPCs == null) {
            this.associatedVPCs = new ArrayList();
        }
        AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
        if (index < 0 || index >= this.associatedVPCs.size()) {
            this._visitables.get((Object)"associatedVPCs").add(builder);
            this.associatedVPCs.add(builder);
        } else {
            this._visitables.get((Object)"associatedVPCs").add(builder);
            this.associatedVPCs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAssociatedVPCs(int index, AWSAssociatedVPC item) {
        if (this.associatedVPCs == null) {
            this.associatedVPCs = new ArrayList();
        }
        AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
        if (index < 0 || index >= this.associatedVPCs.size()) {
            this._visitables.get((Object)"associatedVPCs").add(builder);
            this.associatedVPCs.add(builder);
        } else {
            this._visitables.get((Object)"associatedVPCs").add(builder);
            this.associatedVPCs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAssociatedVPCs(AWSAssociatedVPC ... items) {
        if (this.associatedVPCs == null) {
            this.associatedVPCs = new ArrayList();
        }
        for (AWSAssociatedVPC item : items) {
            AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
            this._visitables.get((Object)"associatedVPCs").add(builder);
            this.associatedVPCs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAssociatedVPCs(Collection<AWSAssociatedVPC> items) {
        if (this.associatedVPCs == null) {
            this.associatedVPCs = new ArrayList();
        }
        for (AWSAssociatedVPC item : items) {
            AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
            this._visitables.get((Object)"associatedVPCs").add(builder);
            this.associatedVPCs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAssociatedVPCs(AWSAssociatedVPC ... items) {
        if (this.associatedVPCs == null) {
            return (A)((Object)this);
        }
        for (AWSAssociatedVPC item : items) {
            AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
            this._visitables.get((Object)"associatedVPCs").remove((Object)builder);
            this.associatedVPCs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAssociatedVPCs(Collection<AWSAssociatedVPC> items) {
        if (this.associatedVPCs == null) {
            return (A)((Object)this);
        }
        for (AWSAssociatedVPC item : items) {
            AWSAssociatedVPCBuilder builder = new AWSAssociatedVPCBuilder(item);
            this._visitables.get((Object)"associatedVPCs").remove((Object)builder);
            this.associatedVPCs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAssociatedVPCs(Predicate<AWSAssociatedVPCBuilder> predicate) {
        if (this.associatedVPCs == null) {
            return (A)((Object)this);
        }
        Iterator<AWSAssociatedVPCBuilder> each = this.associatedVPCs.iterator();
        List visitables = this._visitables.get((Object)"associatedVPCs");
        while (each.hasNext()) {
            AWSAssociatedVPCBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AWSAssociatedVPC> buildAssociatedVPCs() {
        return this.associatedVPCs != null ? AWSPrivateLinkConfigFluent.build(this.associatedVPCs) : null;
    }

    public AWSAssociatedVPC buildAssociatedVPC(int index) {
        return this.associatedVPCs.get(index).build();
    }

    public AWSAssociatedVPC buildFirstAssociatedVPC() {
        return this.associatedVPCs.get(0).build();
    }

    public AWSAssociatedVPC buildLastAssociatedVPC() {
        return this.associatedVPCs.get(this.associatedVPCs.size() - 1).build();
    }

    public AWSAssociatedVPC buildMatchingAssociatedVPC(Predicate<AWSAssociatedVPCBuilder> predicate) {
        for (AWSAssociatedVPCBuilder item : this.associatedVPCs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAssociatedVPC(Predicate<AWSAssociatedVPCBuilder> predicate) {
        for (AWSAssociatedVPCBuilder item : this.associatedVPCs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAssociatedVPCs(List<AWSAssociatedVPC> associatedVPCs) {
        if (this.associatedVPCs != null) {
            this._visitables.get((Object)"associatedVPCs").clear();
        }
        if (associatedVPCs != null) {
            this.associatedVPCs = new ArrayList();
            for (AWSAssociatedVPC item : associatedVPCs) {
                this.addToAssociatedVPCs(item);
            }
        } else {
            this.associatedVPCs = null;
        }
        return (A)((Object)this);
    }

    public A withAssociatedVPCs(AWSAssociatedVPC ... associatedVPCs) {
        if (this.associatedVPCs != null) {
            this.associatedVPCs.clear();
            this._visitables.remove((Object)"associatedVPCs");
        }
        if (associatedVPCs != null) {
            for (AWSAssociatedVPC item : associatedVPCs) {
                this.addToAssociatedVPCs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAssociatedVPCs() {
        return this.associatedVPCs != null && !this.associatedVPCs.isEmpty();
    }

    public AssociatedVPCsNested<A> addNewAssociatedVPC() {
        return new AssociatedVPCsNested(-1, null);
    }

    public AssociatedVPCsNested<A> addNewAssociatedVPCLike(AWSAssociatedVPC item) {
        return new AssociatedVPCsNested(-1, item);
    }

    public AssociatedVPCsNested<A> setNewAssociatedVPCLike(int index, AWSAssociatedVPC item) {
        return new AssociatedVPCsNested(index, item);
    }

    public AssociatedVPCsNested<A> editAssociatedVPC(int index) {
        if (this.associatedVPCs.size() <= index) {
            throw new RuntimeException("Can't edit associatedVPCs. Index exceeds size.");
        }
        return this.setNewAssociatedVPCLike(index, this.buildAssociatedVPC(index));
    }

    public AssociatedVPCsNested<A> editFirstAssociatedVPC() {
        if (this.associatedVPCs.size() == 0) {
            throw new RuntimeException("Can't edit first associatedVPCs. The list is empty.");
        }
        return this.setNewAssociatedVPCLike(0, this.buildAssociatedVPC(0));
    }

    public AssociatedVPCsNested<A> editLastAssociatedVPC() {
        int index = this.associatedVPCs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last associatedVPCs. The list is empty.");
        }
        return this.setNewAssociatedVPCLike(index, this.buildAssociatedVPC(index));
    }

    public AssociatedVPCsNested<A> editMatchingAssociatedVPC(Predicate<AWSAssociatedVPCBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.associatedVPCs.size(); ++i) {
            if (!predicate.test(this.associatedVPCs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching associatedVPCs. No match found.");
        }
        return this.setNewAssociatedVPCLike(index, this.buildAssociatedVPC(index));
    }

    public LocalObjectReference buildCredentialsSecretRef() {
        return this.credentialsSecretRef != null ? this.credentialsSecretRef.build() : null;
    }

    public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
        this._visitables.remove((Object)"credentialsSecretRef");
        if (credentialsSecretRef != null) {
            this.credentialsSecretRef = new LocalObjectReferenceBuilder(credentialsSecretRef);
            this._visitables.get((Object)"credentialsSecretRef").add(this.credentialsSecretRef);
        } else {
            this.credentialsSecretRef = null;
            this._visitables.get((Object)"credentialsSecretRef").remove(this.credentialsSecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasCredentialsSecretRef() {
        return this.credentialsSecretRef != null;
    }

    public A withNewCredentialsSecretRef(String name) {
        return this.withCredentialsSecretRef(new LocalObjectReference(name));
    }

    public CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
        return new CredentialsSecretRefNested(null);
    }

    public CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
        return new CredentialsSecretRefNested(item);
    }

    public CredentialsSecretRefNested<A> editCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(null));
    }

    public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
        return this.withNewCredentialsSecretRefLike(Optional.ofNullable(this.buildCredentialsSecretRef()).orElse(item));
    }

    public String getDnsRecordType() {
        return this.dnsRecordType;
    }

    public A withDnsRecordType(String dnsRecordType) {
        this.dnsRecordType = dnsRecordType;
        return (A)((Object)this);
    }

    public boolean hasDnsRecordType() {
        return this.dnsRecordType != null;
    }

    public A addToEndpointVPCInventory(int index, AWSPrivateLinkInventory item) {
        if (this.endpointVPCInventory == null) {
            this.endpointVPCInventory = new ArrayList();
        }
        AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
        if (index < 0 || index >= this.endpointVPCInventory.size()) {
            this._visitables.get((Object)"endpointVPCInventory").add(builder);
            this.endpointVPCInventory.add(builder);
        } else {
            this._visitables.get((Object)"endpointVPCInventory").add(builder);
            this.endpointVPCInventory.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEndpointVPCInventory(int index, AWSPrivateLinkInventory item) {
        if (this.endpointVPCInventory == null) {
            this.endpointVPCInventory = new ArrayList();
        }
        AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
        if (index < 0 || index >= this.endpointVPCInventory.size()) {
            this._visitables.get((Object)"endpointVPCInventory").add(builder);
            this.endpointVPCInventory.add(builder);
        } else {
            this._visitables.get((Object)"endpointVPCInventory").add(builder);
            this.endpointVPCInventory.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEndpointVPCInventory(AWSPrivateLinkInventory ... items) {
        if (this.endpointVPCInventory == null) {
            this.endpointVPCInventory = new ArrayList();
        }
        for (AWSPrivateLinkInventory item : items) {
            AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
            this._visitables.get((Object)"endpointVPCInventory").add(builder);
            this.endpointVPCInventory.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEndpointVPCInventory(Collection<AWSPrivateLinkInventory> items) {
        if (this.endpointVPCInventory == null) {
            this.endpointVPCInventory = new ArrayList();
        }
        for (AWSPrivateLinkInventory item : items) {
            AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
            this._visitables.get((Object)"endpointVPCInventory").add(builder);
            this.endpointVPCInventory.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEndpointVPCInventory(AWSPrivateLinkInventory ... items) {
        if (this.endpointVPCInventory == null) {
            return (A)((Object)this);
        }
        for (AWSPrivateLinkInventory item : items) {
            AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
            this._visitables.get((Object)"endpointVPCInventory").remove((Object)builder);
            this.endpointVPCInventory.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEndpointVPCInventory(Collection<AWSPrivateLinkInventory> items) {
        if (this.endpointVPCInventory == null) {
            return (A)((Object)this);
        }
        for (AWSPrivateLinkInventory item : items) {
            AWSPrivateLinkInventoryBuilder builder = new AWSPrivateLinkInventoryBuilder(item);
            this._visitables.get((Object)"endpointVPCInventory").remove((Object)builder);
            this.endpointVPCInventory.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
        if (this.endpointVPCInventory == null) {
            return (A)((Object)this);
        }
        Iterator<AWSPrivateLinkInventoryBuilder> each = this.endpointVPCInventory.iterator();
        List visitables = this._visitables.get((Object)"endpointVPCInventory");
        while (each.hasNext()) {
            AWSPrivateLinkInventoryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<AWSPrivateLinkInventory> buildEndpointVPCInventory() {
        return this.endpointVPCInventory != null ? AWSPrivateLinkConfigFluent.build(this.endpointVPCInventory) : null;
    }

    public AWSPrivateLinkInventory buildEndpointVPCInventory(int index) {
        return this.endpointVPCInventory.get(index).build();
    }

    public AWSPrivateLinkInventory buildFirstEndpointVPCInventory() {
        return this.endpointVPCInventory.get(0).build();
    }

    public AWSPrivateLinkInventory buildLastEndpointVPCInventory() {
        return this.endpointVPCInventory.get(this.endpointVPCInventory.size() - 1).build();
    }

    public AWSPrivateLinkInventory buildMatchingEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
        for (AWSPrivateLinkInventoryBuilder item : this.endpointVPCInventory) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
        for (AWSPrivateLinkInventoryBuilder item : this.endpointVPCInventory) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEndpointVPCInventory(List<AWSPrivateLinkInventory> endpointVPCInventory) {
        if (this.endpointVPCInventory != null) {
            this._visitables.get((Object)"endpointVPCInventory").clear();
        }
        if (endpointVPCInventory != null) {
            this.endpointVPCInventory = new ArrayList();
            for (AWSPrivateLinkInventory item : endpointVPCInventory) {
                this.addToEndpointVPCInventory(item);
            }
        } else {
            this.endpointVPCInventory = null;
        }
        return (A)((Object)this);
    }

    public A withEndpointVPCInventory(AWSPrivateLinkInventory ... endpointVPCInventory) {
        if (this.endpointVPCInventory != null) {
            this.endpointVPCInventory.clear();
            this._visitables.remove((Object)"endpointVPCInventory");
        }
        if (endpointVPCInventory != null) {
            for (AWSPrivateLinkInventory item : endpointVPCInventory) {
                this.addToEndpointVPCInventory(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasEndpointVPCInventory() {
        return this.endpointVPCInventory != null && !this.endpointVPCInventory.isEmpty();
    }

    public EndpointVPCInventoryNested<A> addNewEndpointVPCInventory() {
        return new EndpointVPCInventoryNested(-1, null);
    }

    public EndpointVPCInventoryNested<A> addNewEndpointVPCInventoryLike(AWSPrivateLinkInventory item) {
        return new EndpointVPCInventoryNested(-1, item);
    }

    public EndpointVPCInventoryNested<A> setNewEndpointVPCInventoryLike(int index, AWSPrivateLinkInventory item) {
        return new EndpointVPCInventoryNested(index, item);
    }

    public EndpointVPCInventoryNested<A> editEndpointVPCInventory(int index) {
        if (this.endpointVPCInventory.size() <= index) {
            throw new RuntimeException("Can't edit endpointVPCInventory. Index exceeds size.");
        }
        return this.setNewEndpointVPCInventoryLike(index, this.buildEndpointVPCInventory(index));
    }

    public EndpointVPCInventoryNested<A> editFirstEndpointVPCInventory() {
        if (this.endpointVPCInventory.size() == 0) {
            throw new RuntimeException("Can't edit first endpointVPCInventory. The list is empty.");
        }
        return this.setNewEndpointVPCInventoryLike(0, this.buildEndpointVPCInventory(0));
    }

    public EndpointVPCInventoryNested<A> editLastEndpointVPCInventory() {
        int index = this.endpointVPCInventory.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpointVPCInventory. The list is empty.");
        }
        return this.setNewEndpointVPCInventoryLike(index, this.buildEndpointVPCInventory(index));
    }

    public EndpointVPCInventoryNested<A> editMatchingEndpointVPCInventory(Predicate<AWSPrivateLinkInventoryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpointVPCInventory.size(); ++i) {
            if (!predicate.test(this.endpointVPCInventory.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpointVPCInventory. No match found.");
        }
        return this.setNewEndpointVPCInventoryLike(index, this.buildEndpointVPCInventory(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSPrivateLinkConfigFluent that = (AWSPrivateLinkConfigFluent)((Object)o);
        if (!Objects.equals(this.associatedVPCs, that.associatedVPCs)) {
            return false;
        }
        if (!Objects.equals(this.credentialsSecretRef, that.credentialsSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.dnsRecordType, that.dnsRecordType)) {
            return false;
        }
        if (!Objects.equals(this.endpointVPCInventory, that.endpointVPCInventory)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.associatedVPCs, this.credentialsSecretRef, this.dnsRecordType, this.endpointVPCInventory, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.associatedVPCs != null && !this.associatedVPCs.isEmpty()) {
            sb.append("associatedVPCs:");
            sb.append(String.valueOf(this.associatedVPCs) + ",");
        }
        if (this.credentialsSecretRef != null) {
            sb.append("credentialsSecretRef:");
            sb.append(String.valueOf(this.credentialsSecretRef) + ",");
        }
        if (this.dnsRecordType != null) {
            sb.append("dnsRecordType:");
            sb.append(this.dnsRecordType + ",");
        }
        if (this.endpointVPCInventory != null && !this.endpointVPCInventory.isEmpty()) {
            sb.append("endpointVPCInventory:");
            sb.append(String.valueOf(this.endpointVPCInventory) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class EndpointVPCInventoryNested<N>
    extends AWSPrivateLinkInventoryFluent<EndpointVPCInventoryNested<N>>
    implements Nested<N> {
        AWSPrivateLinkInventoryBuilder builder;
        int index;

        EndpointVPCInventoryNested(int index, AWSPrivateLinkInventory item) {
            this.index = index;
            this.builder = new AWSPrivateLinkInventoryBuilder(this, item);
        }

        public N and() {
            return (N)AWSPrivateLinkConfigFluent.this.setToEndpointVPCInventory(this.index, this.builder.build());
        }

        public N endEndpointVPCInventory() {
            return this.and();
        }
    }

    public class CredentialsSecretRefNested<N>
    extends LocalObjectReferenceFluent<CredentialsSecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        CredentialsSecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)AWSPrivateLinkConfigFluent.this.withCredentialsSecretRef(this.builder.build());
        }

        public N endCredentialsSecretRef() {
            return this.and();
        }
    }

    public class AssociatedVPCsNested<N>
    extends AWSAssociatedVPCFluent<AssociatedVPCsNested<N>>
    implements Nested<N> {
        AWSAssociatedVPCBuilder builder;
        int index;

        AssociatedVPCsNested(int index, AWSAssociatedVPC item) {
            this.index = index;
            this.builder = new AWSAssociatedVPCBuilder(this, item);
        }

        public N and() {
            return (N)AWSPrivateLinkConfigFluent.this.setToAssociatedVPCs(this.index, this.builder.build());
        }

        public N endAssociatedVPC() {
            return this.and();
        }
    }
}

