package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SpecificControllerConfigBuilder extends SpecificControllerConfigFluentImpl<SpecificControllerConfigBuilder> implements VisitableBuilder<SpecificControllerConfig,SpecificControllerConfigBuilder>{
  public SpecificControllerConfigBuilder() {
    this(false);
  }
  public SpecificControllerConfigBuilder(Boolean validationEnabled) {
    this(new SpecificControllerConfig(), validationEnabled);
  }
  public SpecificControllerConfigBuilder(SpecificControllerConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public SpecificControllerConfigBuilder(SpecificControllerConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SpecificControllerConfig(), validationEnabled);
  }
  public SpecificControllerConfigBuilder(SpecificControllerConfigFluent<?> fluent,SpecificControllerConfig instance) {
    this(fluent, instance, false);
  }
  public SpecificControllerConfigBuilder(SpecificControllerConfigFluent<?> fluent,SpecificControllerConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfig(instance.getConfig()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SpecificControllerConfigBuilder(SpecificControllerConfig instance) {
    this(instance,false);
  }
  public SpecificControllerConfigBuilder(SpecificControllerConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfig(instance.getConfig()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SpecificControllerConfigFluent<?> fluent;
  Boolean validationEnabled;
  public SpecificControllerConfig build() {
    SpecificControllerConfig buildable = new SpecificControllerConfig(fluent.getConfig(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}