package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManageDNSAWSConfigBuilder extends ManageDNSAWSConfigFluentImpl<ManageDNSAWSConfigBuilder> implements VisitableBuilder<ManageDNSAWSConfig,ManageDNSAWSConfigBuilder>{
  public ManageDNSAWSConfigBuilder() {
    this(false);
  }
  public ManageDNSAWSConfigBuilder(Boolean validationEnabled) {
    this(new ManageDNSAWSConfig(), validationEnabled);
  }
  public ManageDNSAWSConfigBuilder(ManageDNSAWSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ManageDNSAWSConfigBuilder(ManageDNSAWSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManageDNSAWSConfig(), validationEnabled);
  }
  public ManageDNSAWSConfigBuilder(ManageDNSAWSConfigFluent<?> fluent,ManageDNSAWSConfig instance) {
    this(fluent, instance, false);
  }
  public ManageDNSAWSConfigBuilder(ManageDNSAWSConfigFluent<?> fluent,ManageDNSAWSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withRegion(instance.getRegion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ManageDNSAWSConfigBuilder(ManageDNSAWSConfig instance) {
    this(instance,false);
  }
  public ManageDNSAWSConfigBuilder(ManageDNSAWSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withRegion(instance.getRegion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ManageDNSAWSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public ManageDNSAWSConfig build() {
    ManageDNSAWSConfig buildable = new ManageDNSAWSConfig(fluent.getCredentialsSecretRef(),fluent.getRegion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}