package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.Taint;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolSpecFluentImpl<A extends MachinePoolSpecFluent<A>> extends BaseFluent<A> implements MachinePoolSpecFluent<A>{
  public MachinePoolSpecFluentImpl() {
  }
  public MachinePoolSpecFluentImpl(MachinePoolSpec instance) {
    this.withAutoscaling(instance.getAutoscaling()); 
    this.withClusterDeploymentRef(instance.getClusterDeploymentRef()); 
    this.withLabels(instance.getLabels()); 
    this.withName(instance.getName()); 
    this.withPlatform(instance.getPlatform()); 
    this.withReplicas(instance.getReplicas()); 
    this.withTaints(instance.getTaints()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private MachinePoolAutoscalingBuilder autoscaling;
  private LocalObjectReferenceBuilder clusterDeploymentRef;
  private Map<String,String> labels;
  private String name;
  private MachinePoolPlatformBuilder platform;
  private Long replicas;
  private List<Taint> taints = new ArrayList<Taint>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAutoscaling instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePoolAutoscaling getAutoscaling() {
    return this.autoscaling!=null ?this.autoscaling.build():null;
  }
  public MachinePoolAutoscaling buildAutoscaling() {
    return this.autoscaling!=null ?this.autoscaling.build():null;
  }
  public A withAutoscaling(MachinePoolAutoscaling autoscaling) {
    _visitables.get("autoscaling").remove(this.autoscaling);
    if (autoscaling!=null){ this.autoscaling= new MachinePoolAutoscalingBuilder(autoscaling); _visitables.get("autoscaling").add(this.autoscaling);} else { this.autoscaling = null; _visitables.get("autoscaling").remove(this.autoscaling); } return (A) this;
  }
  public Boolean hasAutoscaling() {
    return this.autoscaling != null;
  }
  public A withNewAutoscaling(Integer maxReplicas,Integer minReplicas) {
    return (A)withAutoscaling(new MachinePoolAutoscaling(maxReplicas, minReplicas));
  }
  public MachinePoolSpecFluent.AutoscalingNested<A> withNewAutoscaling() {
    return new MachinePoolSpecFluentImpl.AutoscalingNestedImpl();
  }
  public MachinePoolSpecFluent.AutoscalingNested<A> withNewAutoscalingLike(MachinePoolAutoscaling item) {
    return new MachinePoolSpecFluentImpl.AutoscalingNestedImpl(item);
  }
  public MachinePoolSpecFluent.AutoscalingNested<A> editAutoscaling() {
    return withNewAutoscalingLike(getAutoscaling());
  }
  public MachinePoolSpecFluent.AutoscalingNested<A> editOrNewAutoscaling() {
    return withNewAutoscalingLike(getAutoscaling() != null ? getAutoscaling(): new MachinePoolAutoscalingBuilder().build());
  }
  public MachinePoolSpecFluent.AutoscalingNested<A> editOrNewAutoscalingLike(MachinePoolAutoscaling item) {
    return withNewAutoscalingLike(getAutoscaling() != null ? getAutoscaling(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildClusterDeploymentRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getClusterDeploymentRef() {
    return this.clusterDeploymentRef!=null ?this.clusterDeploymentRef.build():null;
  }
  public LocalObjectReference buildClusterDeploymentRef() {
    return this.clusterDeploymentRef!=null ?this.clusterDeploymentRef.build():null;
  }
  public A withClusterDeploymentRef(LocalObjectReference clusterDeploymentRef) {
    _visitables.get("clusterDeploymentRef").remove(this.clusterDeploymentRef);
    if (clusterDeploymentRef!=null){ this.clusterDeploymentRef= new LocalObjectReferenceBuilder(clusterDeploymentRef); _visitables.get("clusterDeploymentRef").add(this.clusterDeploymentRef);} else { this.clusterDeploymentRef = null; _visitables.get("clusterDeploymentRef").remove(this.clusterDeploymentRef); } return (A) this;
  }
  public Boolean hasClusterDeploymentRef() {
    return this.clusterDeploymentRef != null;
  }
  public A withNewClusterDeploymentRef(String name) {
    return (A)withClusterDeploymentRef(new LocalObjectReference(name));
  }
  public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> withNewClusterDeploymentRef() {
    return new MachinePoolSpecFluentImpl.ClusterDeploymentRefNestedImpl();
  }
  public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> withNewClusterDeploymentRefLike(LocalObjectReference item) {
    return new MachinePoolSpecFluentImpl.ClusterDeploymentRefNestedImpl(item);
  }
  public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> editClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(getClusterDeploymentRef());
  }
  public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(getClusterDeploymentRef() != null ? getClusterDeploymentRef(): new LocalObjectReferenceBuilder().build());
  }
  public MachinePoolSpecFluent.ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRefLike(LocalObjectReference item) {
    return withNewClusterDeploymentRefLike(getClusterDeploymentRef() != null ? getClusterDeploymentRef(): item);
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public Boolean hasLabels() {
    return this.labels != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPlatform instead.
   * @return The buildable object.
   */
  @Deprecated
  public MachinePoolPlatform getPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public MachinePoolPlatform buildPlatform() {
    return this.platform!=null ?this.platform.build():null;
  }
  public A withPlatform(MachinePoolPlatform platform) {
    _visitables.get("platform").remove(this.platform);
    if (platform!=null){ this.platform= new MachinePoolPlatformBuilder(platform); _visitables.get("platform").add(this.platform);} else { this.platform = null; _visitables.get("platform").remove(this.platform); } return (A) this;
  }
  public Boolean hasPlatform() {
    return this.platform != null;
  }
  public MachinePoolSpecFluent.PlatformNested<A> withNewPlatform() {
    return new MachinePoolSpecFluentImpl.PlatformNestedImpl();
  }
  public MachinePoolSpecFluent.PlatformNested<A> withNewPlatformLike(MachinePoolPlatform item) {
    return new MachinePoolSpecFluentImpl.PlatformNestedImpl(item);
  }
  public MachinePoolSpecFluent.PlatformNested<A> editPlatform() {
    return withNewPlatformLike(getPlatform());
  }
  public MachinePoolSpecFluent.PlatformNested<A> editOrNewPlatform() {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): new MachinePoolPlatformBuilder().build());
  }
  public MachinePoolSpecFluent.PlatformNested<A> editOrNewPlatformLike(MachinePoolPlatform item) {
    return withNewPlatformLike(getPlatform() != null ? getPlatform(): item);
  }
  public Long getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Long replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public A addToTaints(Integer index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.add(index, item);
    return (A)this;
  }
  public A setToTaints(Integer index,Taint item) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    this.taints.set(index, item); return (A)this;
  }
  public A addToTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  public A addAllToTaints(Collection<Taint> items) {
    if (this.taints == null) {this.taints = new ArrayList<Taint>();}
    for (Taint item : items) {this.taints.add(item);} return (A)this;
  }
  public A removeFromTaints(io.fabric8.kubernetes.api.model.Taint... items) {
    for (Taint item : items) {if (this.taints!= null){ this.taints.remove(item);}} return (A)this;
  }
  public A removeAllFromTaints(Collection<Taint> items) {
    for (Taint item : items) {if (this.taints!= null){ this.taints.remove(item);}} return (A)this;
  }
  public List<Taint> getTaints() {
    return this.taints;
  }
  public Taint getTaint(Integer index) {
    return this.taints.get(index);
  }
  public Taint getFirstTaint() {
    return this.taints.get(0);
  }
  public Taint getLastTaint() {
    return this.taints.get(taints.size() - 1);
  }
  public Taint getMatchingTaint(Predicate<Taint> predicate) {
    for (Taint item: taints) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingTaint(Predicate<Taint> predicate) {
    for (Taint item: taints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTaints(List<Taint> taints) {
    if (taints != null) {this.taints = new ArrayList(); for (Taint item : taints){this.addToTaints(item);}} else { this.taints = null;} return (A) this;
  }
  public A withTaints(io.fabric8.kubernetes.api.model.Taint... taints) {
    if (this.taints != null) {this.taints.clear();}
    if (taints != null) {for (Taint item :taints){ this.addToTaints(item);}} return (A) this;
  }
  public Boolean hasTaints() {
    return taints != null && !taints.isEmpty();
  }
  public A addNewTaint(String effect,String key,String timeAdded,String value) {
    return (A)addToTaints(new Taint(effect, key, timeAdded, value));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachinePoolSpecFluentImpl that = (MachinePoolSpecFluentImpl) o;
    if (autoscaling != null ? !autoscaling.equals(that.autoscaling) :that.autoscaling != null) return false;
    if (clusterDeploymentRef != null ? !clusterDeploymentRef.equals(that.clusterDeploymentRef) :that.clusterDeploymentRef != null) return false;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (platform != null ? !platform.equals(that.platform) :that.platform != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (taints != null ? !taints.equals(that.taints) :that.taints != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(autoscaling,  clusterDeploymentRef,  labels,  name,  platform,  replicas,  taints,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (autoscaling != null) { sb.append("autoscaling:"); sb.append(autoscaling + ","); }
    if (clusterDeploymentRef != null) { sb.append("clusterDeploymentRef:"); sb.append(clusterDeploymentRef + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (platform != null) { sb.append("platform:"); sb.append(platform + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (taints != null && !taints.isEmpty()) { sb.append("taints:"); sb.append(taints + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AutoscalingNestedImpl<N> extends MachinePoolAutoscalingFluentImpl<MachinePoolSpecFluent.AutoscalingNested<N>> implements MachinePoolSpecFluent.AutoscalingNested<N>,Nested<N>{
    AutoscalingNestedImpl(MachinePoolAutoscaling item) {
      this.builder = new MachinePoolAutoscalingBuilder(this, item);
    }
    AutoscalingNestedImpl() {
      this.builder = new MachinePoolAutoscalingBuilder(this);
    }
    MachinePoolAutoscalingBuilder builder;
    public N and() {
      return (N) MachinePoolSpecFluentImpl.this.withAutoscaling(builder.build());
    }
    public N endAutoscaling() {
      return and();
    }
    
  }
  class ClusterDeploymentRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<MachinePoolSpecFluent.ClusterDeploymentRefNested<N>> implements MachinePoolSpecFluent.ClusterDeploymentRefNested<N>,Nested<N>{
    ClusterDeploymentRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ClusterDeploymentRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) MachinePoolSpecFluentImpl.this.withClusterDeploymentRef(builder.build());
    }
    public N endClusterDeploymentRef() {
      return and();
    }
    
  }
  class PlatformNestedImpl<N> extends MachinePoolPlatformFluentImpl<MachinePoolSpecFluent.PlatformNested<N>> implements MachinePoolSpecFluent.PlatformNested<N>,Nested<N>{
    PlatformNestedImpl(MachinePoolPlatform item) {
      this.builder = new MachinePoolPlatformBuilder(this, item);
    }
    PlatformNestedImpl() {
      this.builder = new MachinePoolPlatformBuilder(this);
    }
    MachinePoolPlatformBuilder builder;
    public N and() {
      return (N) MachinePoolSpecFluentImpl.this.withPlatform(builder.build());
    }
    public N endPlatform() {
      return and();
    }
    
  }
  
}