package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GCPDNSZoneSpecBuilder extends GCPDNSZoneSpecFluentImpl<GCPDNSZoneSpecBuilder> implements VisitableBuilder<GCPDNSZoneSpec,GCPDNSZoneSpecBuilder>{
  public GCPDNSZoneSpecBuilder() {
    this(false);
  }
  public GCPDNSZoneSpecBuilder(Boolean validationEnabled) {
    this(new GCPDNSZoneSpec(), validationEnabled);
  }
  public GCPDNSZoneSpecBuilder(GCPDNSZoneSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public GCPDNSZoneSpecBuilder(GCPDNSZoneSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GCPDNSZoneSpec(), validationEnabled);
  }
  public GCPDNSZoneSpecBuilder(GCPDNSZoneSpecFluent<?> fluent,GCPDNSZoneSpec instance) {
    this(fluent, instance, false);
  }
  public GCPDNSZoneSpecBuilder(GCPDNSZoneSpecFluent<?> fluent,GCPDNSZoneSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GCPDNSZoneSpecBuilder(GCPDNSZoneSpec instance) {
    this(instance,false);
  }
  public GCPDNSZoneSpecBuilder(GCPDNSZoneSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GCPDNSZoneSpecFluent<?> fluent;
  Boolean validationEnabled;
  public GCPDNSZoneSpec build() {
    GCPDNSZoneSpec buildable = new GCPDNSZoneSpec(fluent.getCredentialsSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}