package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class FailedProvisionConfigFluentImpl<A extends FailedProvisionConfigFluent<A>> extends BaseFluent<A> implements FailedProvisionConfigFluent<A>{
  public FailedProvisionConfigFluentImpl() {
  }
  public FailedProvisionConfigFluentImpl(FailedProvisionConfig instance) {
    this.withAws(instance.getAws()); 
    this.withRetryReasons(instance.getRetryReasons()); 
    this.withSkipGatherLogs(instance.getSkipGatherLogs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private FailedProvisionAWSConfigBuilder aws;
  private List<String> retryReasons = new ArrayList<String>();
  private Boolean skipGatherLogs;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAws instead.
   * @return The buildable object.
   */
  @Deprecated
  public FailedProvisionAWSConfig getAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public FailedProvisionAWSConfig buildAws() {
    return this.aws!=null ?this.aws.build():null;
  }
  public A withAws(FailedProvisionAWSConfig aws) {
    _visitables.get("aws").remove(this.aws);
    if (aws!=null){ this.aws= new FailedProvisionAWSConfigBuilder(aws); _visitables.get("aws").add(this.aws);} else { this.aws = null; _visitables.get("aws").remove(this.aws); } return (A) this;
  }
  public Boolean hasAws() {
    return this.aws != null;
  }
  public FailedProvisionConfigFluent.AwsNested<A> withNewAws() {
    return new FailedProvisionConfigFluentImpl.AwsNestedImpl();
  }
  public FailedProvisionConfigFluent.AwsNested<A> withNewAwsLike(FailedProvisionAWSConfig item) {
    return new FailedProvisionConfigFluentImpl.AwsNestedImpl(item);
  }
  public FailedProvisionConfigFluent.AwsNested<A> editAws() {
    return withNewAwsLike(getAws());
  }
  public FailedProvisionConfigFluent.AwsNested<A> editOrNewAws() {
    return withNewAwsLike(getAws() != null ? getAws(): new FailedProvisionAWSConfigBuilder().build());
  }
  public FailedProvisionConfigFluent.AwsNested<A> editOrNewAwsLike(FailedProvisionAWSConfig item) {
    return withNewAwsLike(getAws() != null ? getAws(): item);
  }
  public A addToRetryReasons(Integer index,String item) {
    if (this.retryReasons == null) {this.retryReasons = new ArrayList<String>();}
    this.retryReasons.add(index, item);
    return (A)this;
  }
  public A setToRetryReasons(Integer index,String item) {
    if (this.retryReasons == null) {this.retryReasons = new ArrayList<String>();}
    this.retryReasons.set(index, item); return (A)this;
  }
  public A addToRetryReasons(java.lang.String... items) {
    if (this.retryReasons == null) {this.retryReasons = new ArrayList<String>();}
    for (String item : items) {this.retryReasons.add(item);} return (A)this;
  }
  public A addAllToRetryReasons(Collection<String> items) {
    if (this.retryReasons == null) {this.retryReasons = new ArrayList<String>();}
    for (String item : items) {this.retryReasons.add(item);} return (A)this;
  }
  public A removeFromRetryReasons(java.lang.String... items) {
    for (String item : items) {if (this.retryReasons!= null){ this.retryReasons.remove(item);}} return (A)this;
  }
  public A removeAllFromRetryReasons(Collection<String> items) {
    for (String item : items) {if (this.retryReasons!= null){ this.retryReasons.remove(item);}} return (A)this;
  }
  public List<String> getRetryReasons() {
    return this.retryReasons;
  }
  public String getRetryReason(Integer index) {
    return this.retryReasons.get(index);
  }
  public String getFirstRetryReason() {
    return this.retryReasons.get(0);
  }
  public String getLastRetryReason() {
    return this.retryReasons.get(retryReasons.size() - 1);
  }
  public String getMatchingRetryReason(Predicate<String> predicate) {
    for (String item: retryReasons) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRetryReason(Predicate<String> predicate) {
    for (String item: retryReasons) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRetryReasons(List<String> retryReasons) {
    if (retryReasons != null) {this.retryReasons = new ArrayList(); for (String item : retryReasons){this.addToRetryReasons(item);}} else { this.retryReasons = null;} return (A) this;
  }
  public A withRetryReasons(java.lang.String... retryReasons) {
    if (this.retryReasons != null) {this.retryReasons.clear();}
    if (retryReasons != null) {for (String item :retryReasons){ this.addToRetryReasons(item);}} return (A) this;
  }
  public Boolean hasRetryReasons() {
    return retryReasons != null && !retryReasons.isEmpty();
  }
  public Boolean getSkipGatherLogs() {
    return this.skipGatherLogs;
  }
  public A withSkipGatherLogs(Boolean skipGatherLogs) {
    this.skipGatherLogs=skipGatherLogs; return (A) this;
  }
  public Boolean hasSkipGatherLogs() {
    return this.skipGatherLogs != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FailedProvisionConfigFluentImpl that = (FailedProvisionConfigFluentImpl) o;
    if (aws != null ? !aws.equals(that.aws) :that.aws != null) return false;
    if (retryReasons != null ? !retryReasons.equals(that.retryReasons) :that.retryReasons != null) return false;
    if (skipGatherLogs != null ? !skipGatherLogs.equals(that.skipGatherLogs) :that.skipGatherLogs != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(aws,  retryReasons,  skipGatherLogs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (aws != null) { sb.append("aws:"); sb.append(aws + ","); }
    if (retryReasons != null && !retryReasons.isEmpty()) { sb.append("retryReasons:"); sb.append(retryReasons + ","); }
    if (skipGatherLogs != null) { sb.append("skipGatherLogs:"); sb.append(skipGatherLogs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withSkipGatherLogs() {
    return withSkipGatherLogs(true);
  }
  class AwsNestedImpl<N> extends FailedProvisionAWSConfigFluentImpl<FailedProvisionConfigFluent.AwsNested<N>> implements FailedProvisionConfigFluent.AwsNested<N>,Nested<N>{
    AwsNestedImpl(FailedProvisionAWSConfig item) {
      this.builder = new FailedProvisionAWSConfigBuilder(this, item);
    }
    AwsNestedImpl() {
      this.builder = new FailedProvisionAWSConfigBuilder(this);
    }
    FailedProvisionAWSConfigBuilder builder;
    public N and() {
      return (N) FailedProvisionConfigFluentImpl.this.withAws(builder.build());
    }
    public N endAws() {
      return and();
    }
    
  }
  
}