package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterStateStatusFluentImpl<A extends ClusterStateStatusFluent<A>> extends BaseFluent<A> implements ClusterStateStatusFluent<A>{
  public ClusterStateStatusFluentImpl() {
  }
  public ClusterStateStatusFluentImpl(ClusterStateStatus instance) {
    this.withClusterOperators(instance.getClusterOperators()); 
    this.withLastUpdated(instance.getLastUpdated()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<ClusterOperatorStateBuilder> clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();
  private String lastUpdated;
  private Map<String,Object> additionalProperties;
  public A addToClusterOperators(Integer index,ClusterOperatorState item) {
    if (this.clusterOperators == null) {this.clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();}
    ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);_visitables.get("clusterOperators").add(index >= 0 ? index : _visitables.get("clusterOperators").size(), builder);this.clusterOperators.add(index >= 0 ? index : clusterOperators.size(), builder); return (A)this;
  }
  public A setToClusterOperators(Integer index,ClusterOperatorState item) {
    if (this.clusterOperators == null) {this.clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();}
    ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterOperators").size()) { _visitables.get("clusterOperators").add(builder); } else { _visitables.get("clusterOperators").set(index, builder);}
    if (index < 0 || index >= clusterOperators.size()) { clusterOperators.add(builder); } else { clusterOperators.set(index, builder);}
     return (A)this;
  }
  public A addToClusterOperators(io.fabric8.openshift.api.model.hive.v1.ClusterOperatorState... items) {
    if (this.clusterOperators == null) {this.clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();}
    for (ClusterOperatorState item : items) {ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);_visitables.get("clusterOperators").add(builder);this.clusterOperators.add(builder);} return (A)this;
  }
  public A addAllToClusterOperators(Collection<ClusterOperatorState> items) {
    if (this.clusterOperators == null) {this.clusterOperators = new ArrayList<ClusterOperatorStateBuilder>();}
    for (ClusterOperatorState item : items) {ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);_visitables.get("clusterOperators").add(builder);this.clusterOperators.add(builder);} return (A)this;
  }
  public A removeFromClusterOperators(io.fabric8.openshift.api.model.hive.v1.ClusterOperatorState... items) {
    for (ClusterOperatorState item : items) {ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);_visitables.get("clusterOperators").remove(builder);if (this.clusterOperators != null) {this.clusterOperators.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterOperators(Collection<ClusterOperatorState> items) {
    for (ClusterOperatorState item : items) {ClusterOperatorStateBuilder builder = new ClusterOperatorStateBuilder(item);_visitables.get("clusterOperators").remove(builder);if (this.clusterOperators != null) {this.clusterOperators.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterOperators(Predicate<ClusterOperatorStateBuilder> predicate) {
    if (clusterOperators == null) return (A) this;
    final Iterator<ClusterOperatorStateBuilder> each = clusterOperators.iterator();
    final List visitables = _visitables.get("clusterOperators");
    while (each.hasNext()) {
      ClusterOperatorStateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterOperators instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterOperatorState> getClusterOperators() {
    return clusterOperators != null ? build(clusterOperators) : null;
  }
  public List<ClusterOperatorState> buildClusterOperators() {
    return clusterOperators != null ? build(clusterOperators) : null;
  }
  public ClusterOperatorState buildClusterOperator(Integer index) {
    return this.clusterOperators.get(index).build();
  }
  public ClusterOperatorState buildFirstClusterOperator() {
    return this.clusterOperators.get(0).build();
  }
  public ClusterOperatorState buildLastClusterOperator() {
    return this.clusterOperators.get(clusterOperators.size() - 1).build();
  }
  public ClusterOperatorState buildMatchingClusterOperator(Predicate<ClusterOperatorStateBuilder> predicate) {
    for (ClusterOperatorStateBuilder item: clusterOperators) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingClusterOperator(Predicate<ClusterOperatorStateBuilder> predicate) {
    for (ClusterOperatorStateBuilder item: clusterOperators) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterOperators(List<ClusterOperatorState> clusterOperators) {
    if (this.clusterOperators != null) { _visitables.get("clusterOperators").removeAll(this.clusterOperators);}
    if (clusterOperators != null) {this.clusterOperators = new ArrayList(); for (ClusterOperatorState item : clusterOperators){this.addToClusterOperators(item);}} else { this.clusterOperators = null;} return (A) this;
  }
  public A withClusterOperators(io.fabric8.openshift.api.model.hive.v1.ClusterOperatorState... clusterOperators) {
    if (this.clusterOperators != null) {this.clusterOperators.clear();}
    if (clusterOperators != null) {for (ClusterOperatorState item :clusterOperators){ this.addToClusterOperators(item);}} return (A) this;
  }
  public Boolean hasClusterOperators() {
    return clusterOperators != null && !clusterOperators.isEmpty();
  }
  public ClusterStateStatusFluent.ClusterOperatorsNested<A> addNewClusterOperator() {
    return new ClusterStateStatusFluentImpl.ClusterOperatorsNestedImpl();
  }
  public ClusterStateStatusFluent.ClusterOperatorsNested<A> addNewClusterOperatorLike(ClusterOperatorState item) {
    return new ClusterStateStatusFluentImpl.ClusterOperatorsNestedImpl(-1, item);
  }
  public ClusterStateStatusFluent.ClusterOperatorsNested<A> setNewClusterOperatorLike(Integer index,ClusterOperatorState item) {
    return new ClusterStateStatusFluentImpl.ClusterOperatorsNestedImpl(index, item);
  }
  public ClusterStateStatusFluent.ClusterOperatorsNested<A> editClusterOperator(Integer index) {
    if (clusterOperators.size() <= index) throw new RuntimeException("Can't edit clusterOperators. Index exceeds size.");
    return setNewClusterOperatorLike(index, buildClusterOperator(index));
  }
  public ClusterStateStatusFluent.ClusterOperatorsNested<A> editFirstClusterOperator() {
    if (clusterOperators.size() == 0) throw new RuntimeException("Can't edit first clusterOperators. The list is empty.");
    return setNewClusterOperatorLike(0, buildClusterOperator(0));
  }
  public ClusterStateStatusFluent.ClusterOperatorsNested<A> editLastClusterOperator() {
    int index = clusterOperators.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterOperators. The list is empty.");
    return setNewClusterOperatorLike(index, buildClusterOperator(index));
  }
  public ClusterStateStatusFluent.ClusterOperatorsNested<A> editMatchingClusterOperator(Predicate<ClusterOperatorStateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterOperators.size();i++) { 
    if (predicate.test(clusterOperators.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterOperators. No match found.");
    return setNewClusterOperatorLike(index, buildClusterOperator(index));
  }
  public String getLastUpdated() {
    return this.lastUpdated;
  }
  public A withLastUpdated(String lastUpdated) {
    this.lastUpdated=lastUpdated; return (A) this;
  }
  public Boolean hasLastUpdated() {
    return this.lastUpdated != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterStateStatusFluentImpl that = (ClusterStateStatusFluentImpl) o;
    if (clusterOperators != null ? !clusterOperators.equals(that.clusterOperators) :that.clusterOperators != null) return false;
    if (lastUpdated != null ? !lastUpdated.equals(that.lastUpdated) :that.lastUpdated != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterOperators,  lastUpdated,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterOperators != null && !clusterOperators.isEmpty()) { sb.append("clusterOperators:"); sb.append(clusterOperators + ","); }
    if (lastUpdated != null) { sb.append("lastUpdated:"); sb.append(lastUpdated + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterOperatorsNestedImpl<N> extends ClusterOperatorStateFluentImpl<ClusterStateStatusFluent.ClusterOperatorsNested<N>> implements ClusterStateStatusFluent.ClusterOperatorsNested<N>,Nested<N>{
    ClusterOperatorsNestedImpl(Integer index,ClusterOperatorState item) {
      this.index = index;
      this.builder = new ClusterOperatorStateBuilder(this, item);
    }
    ClusterOperatorsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterOperatorStateBuilder(this);
    }
    ClusterOperatorStateBuilder builder;
    Integer index;
    public N and() {
      return (N) ClusterStateStatusFluentImpl.this.setToClusterOperators(index,builder.build());
    }
    public N endClusterOperator() {
      return and();
    }
    
  }
  
}