package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRelocateListBuilder extends ClusterRelocateListFluentImpl<ClusterRelocateListBuilder> implements VisitableBuilder<ClusterRelocateList,ClusterRelocateListBuilder>{
  public ClusterRelocateListBuilder() {
    this(false);
  }
  public ClusterRelocateListBuilder(Boolean validationEnabled) {
    this(new ClusterRelocateList(), validationEnabled);
  }
  public ClusterRelocateListBuilder(ClusterRelocateListFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRelocateListBuilder(ClusterRelocateListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRelocateList(), validationEnabled);
  }
  public ClusterRelocateListBuilder(ClusterRelocateListFluent<?> fluent,ClusterRelocateList instance) {
    this(fluent, instance, false);
  }
  public ClusterRelocateListBuilder(ClusterRelocateListFluent<?> fluent,ClusterRelocateList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRelocateListBuilder(ClusterRelocateList instance) {
    this(instance,false);
  }
  public ClusterRelocateListBuilder(ClusterRelocateList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterRelocateListFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRelocateList build() {
    ClusterRelocateList buildable = new ClusterRelocateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}