package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.model.PodSpec;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ClusterProvisionSpecFluentImpl<A extends ClusterProvisionSpecFluent<A>> extends BaseFluent<A> implements ClusterProvisionSpecFluent<A>{
  public ClusterProvisionSpecFluentImpl() {
  }
  public ClusterProvisionSpecFluentImpl(ClusterProvisionSpec instance) {
    this.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef()); 
    this.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef()); 
    this.withAttempt(instance.getAttempt()); 
    this.withClusterDeploymentRef(instance.getClusterDeploymentRef()); 
    this.withClusterID(instance.getClusterID()); 
    this.withInfraID(instance.getInfraID()); 
    this.withInstallLog(instance.getInstallLog()); 
    this.withMetadata(instance.getMetadata()); 
    this.withPodSpec(instance.getPodSpec()); 
    this.withPrevClusterID(instance.getPrevClusterID()); 
    this.withPrevInfraID(instance.getPrevInfraID()); 
    this.withStage(instance.getStage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private LocalObjectReferenceBuilder adminKubeconfigSecretRef;
  private LocalObjectReferenceBuilder adminPasswordSecretRef;
  private Integer attempt;
  private LocalObjectReferenceBuilder clusterDeploymentRef;
  private String clusterID;
  private String infraID;
  private String installLog;
  private Map<String,Object> metadata;
  private PodSpec podSpec;
  private String prevClusterID;
  private String prevInfraID;
  private String stage;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAdminKubeconfigSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef!=null ?this.adminKubeconfigSecretRef.build():null;
  }
  public LocalObjectReference buildAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef!=null ?this.adminKubeconfigSecretRef.build():null;
  }
  public A withAdminKubeconfigSecretRef(LocalObjectReference adminKubeconfigSecretRef) {
    _visitables.get("adminKubeconfigSecretRef").remove(this.adminKubeconfigSecretRef);
    if (adminKubeconfigSecretRef!=null){ this.adminKubeconfigSecretRef= new LocalObjectReferenceBuilder(adminKubeconfigSecretRef); _visitables.get("adminKubeconfigSecretRef").add(this.adminKubeconfigSecretRef);} else { this.adminKubeconfigSecretRef = null; _visitables.get("adminKubeconfigSecretRef").remove(this.adminKubeconfigSecretRef); } return (A) this;
  }
  public Boolean hasAdminKubeconfigSecretRef() {
    return this.adminKubeconfigSecretRef != null;
  }
  public A withNewAdminKubeconfigSecretRef(String name) {
    return (A)withAdminKubeconfigSecretRef(new LocalObjectReference(name));
  }
  public ClusterProvisionSpecFluent.AdminKubeconfigSecretRefNested<A> withNewAdminKubeconfigSecretRef() {
    return new ClusterProvisionSpecFluentImpl.AdminKubeconfigSecretRefNestedImpl();
  }
  public ClusterProvisionSpecFluent.AdminKubeconfigSecretRefNested<A> withNewAdminKubeconfigSecretRefLike(LocalObjectReference item) {
    return new ClusterProvisionSpecFluentImpl.AdminKubeconfigSecretRefNestedImpl(item);
  }
  public ClusterProvisionSpecFluent.AdminKubeconfigSecretRefNested<A> editAdminKubeconfigSecretRef() {
    return withNewAdminKubeconfigSecretRefLike(getAdminKubeconfigSecretRef());
  }
  public ClusterProvisionSpecFluent.AdminKubeconfigSecretRefNested<A> editOrNewAdminKubeconfigSecretRef() {
    return withNewAdminKubeconfigSecretRefLike(getAdminKubeconfigSecretRef() != null ? getAdminKubeconfigSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterProvisionSpecFluent.AdminKubeconfigSecretRefNested<A> editOrNewAdminKubeconfigSecretRefLike(LocalObjectReference item) {
    return withNewAdminKubeconfigSecretRefLike(getAdminKubeconfigSecretRef() != null ? getAdminKubeconfigSecretRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAdminPasswordSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef!=null ?this.adminPasswordSecretRef.build():null;
  }
  public LocalObjectReference buildAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef!=null ?this.adminPasswordSecretRef.build():null;
  }
  public A withAdminPasswordSecretRef(LocalObjectReference adminPasswordSecretRef) {
    _visitables.get("adminPasswordSecretRef").remove(this.adminPasswordSecretRef);
    if (adminPasswordSecretRef!=null){ this.adminPasswordSecretRef= new LocalObjectReferenceBuilder(adminPasswordSecretRef); _visitables.get("adminPasswordSecretRef").add(this.adminPasswordSecretRef);} else { this.adminPasswordSecretRef = null; _visitables.get("adminPasswordSecretRef").remove(this.adminPasswordSecretRef); } return (A) this;
  }
  public Boolean hasAdminPasswordSecretRef() {
    return this.adminPasswordSecretRef != null;
  }
  public A withNewAdminPasswordSecretRef(String name) {
    return (A)withAdminPasswordSecretRef(new LocalObjectReference(name));
  }
  public ClusterProvisionSpecFluent.AdminPasswordSecretRefNested<A> withNewAdminPasswordSecretRef() {
    return new ClusterProvisionSpecFluentImpl.AdminPasswordSecretRefNestedImpl();
  }
  public ClusterProvisionSpecFluent.AdminPasswordSecretRefNested<A> withNewAdminPasswordSecretRefLike(LocalObjectReference item) {
    return new ClusterProvisionSpecFluentImpl.AdminPasswordSecretRefNestedImpl(item);
  }
  public ClusterProvisionSpecFluent.AdminPasswordSecretRefNested<A> editAdminPasswordSecretRef() {
    return withNewAdminPasswordSecretRefLike(getAdminPasswordSecretRef());
  }
  public ClusterProvisionSpecFluent.AdminPasswordSecretRefNested<A> editOrNewAdminPasswordSecretRef() {
    return withNewAdminPasswordSecretRefLike(getAdminPasswordSecretRef() != null ? getAdminPasswordSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterProvisionSpecFluent.AdminPasswordSecretRefNested<A> editOrNewAdminPasswordSecretRefLike(LocalObjectReference item) {
    return withNewAdminPasswordSecretRefLike(getAdminPasswordSecretRef() != null ? getAdminPasswordSecretRef(): item);
  }
  public Integer getAttempt() {
    return this.attempt;
  }
  public A withAttempt(Integer attempt) {
    this.attempt=attempt; return (A) this;
  }
  public Boolean hasAttempt() {
    return this.attempt != null;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterDeploymentRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getClusterDeploymentRef() {
    return this.clusterDeploymentRef!=null ?this.clusterDeploymentRef.build():null;
  }
  public LocalObjectReference buildClusterDeploymentRef() {
    return this.clusterDeploymentRef!=null ?this.clusterDeploymentRef.build():null;
  }
  public A withClusterDeploymentRef(LocalObjectReference clusterDeploymentRef) {
    _visitables.get("clusterDeploymentRef").remove(this.clusterDeploymentRef);
    if (clusterDeploymentRef!=null){ this.clusterDeploymentRef= new LocalObjectReferenceBuilder(clusterDeploymentRef); _visitables.get("clusterDeploymentRef").add(this.clusterDeploymentRef);} else { this.clusterDeploymentRef = null; _visitables.get("clusterDeploymentRef").remove(this.clusterDeploymentRef); } return (A) this;
  }
  public Boolean hasClusterDeploymentRef() {
    return this.clusterDeploymentRef != null;
  }
  public A withNewClusterDeploymentRef(String name) {
    return (A)withClusterDeploymentRef(new LocalObjectReference(name));
  }
  public ClusterProvisionSpecFluent.ClusterDeploymentRefNested<A> withNewClusterDeploymentRef() {
    return new ClusterProvisionSpecFluentImpl.ClusterDeploymentRefNestedImpl();
  }
  public ClusterProvisionSpecFluent.ClusterDeploymentRefNested<A> withNewClusterDeploymentRefLike(LocalObjectReference item) {
    return new ClusterProvisionSpecFluentImpl.ClusterDeploymentRefNestedImpl(item);
  }
  public ClusterProvisionSpecFluent.ClusterDeploymentRefNested<A> editClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(getClusterDeploymentRef());
  }
  public ClusterProvisionSpecFluent.ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRef() {
    return withNewClusterDeploymentRefLike(getClusterDeploymentRef() != null ? getClusterDeploymentRef(): new LocalObjectReferenceBuilder().build());
  }
  public ClusterProvisionSpecFluent.ClusterDeploymentRefNested<A> editOrNewClusterDeploymentRefLike(LocalObjectReference item) {
    return withNewClusterDeploymentRefLike(getClusterDeploymentRef() != null ? getClusterDeploymentRef(): item);
  }
  public String getClusterID() {
    return this.clusterID;
  }
  public A withClusterID(String clusterID) {
    this.clusterID=clusterID; return (A) this;
  }
  public Boolean hasClusterID() {
    return this.clusterID != null;
  }
  public String getInfraID() {
    return this.infraID;
  }
  public A withInfraID(String infraID) {
    this.infraID=infraID; return (A) this;
  }
  public Boolean hasInfraID() {
    return this.infraID != null;
  }
  public String getInstallLog() {
    return this.installLog;
  }
  public A withInstallLog(String installLog) {
    this.installLog=installLog; return (A) this;
  }
  public Boolean hasInstallLog() {
    return this.installLog != null;
  }
  public A addToMetadata(String key,Object value) {
    if(this.metadata == null && key != null && value != null) { this.metadata = new LinkedHashMap(); }
    if(key != null && value != null) {this.metadata.put(key, value);} return (A)this;
  }
  public A addToMetadata(Map<String,Object> map) {
    if(this.metadata == null && map != null) { this.metadata = new LinkedHashMap(); }
    if(map != null) { this.metadata.putAll(map);} return (A)this;
  }
  public A removeFromMetadata(String key) {
    if(this.metadata == null) { return (A) this; }
    if(key != null && this.metadata != null) {this.metadata.remove(key);} return (A)this;
  }
  public A removeFromMetadata(Map<String,Object> map) {
    if(this.metadata == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.metadata != null){this.metadata.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getMetadata() {
    return this.metadata;
  }
  public <K,V>A withMetadata(Map<String,Object> metadata) {
    if (metadata == null) { this.metadata =  null;} else {this.metadata = new LinkedHashMap(metadata);} return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PodSpec getPodSpec() {
    return this.podSpec;
  }
  public A withPodSpec(PodSpec podSpec) {
    this.podSpec=podSpec; return (A) this;
  }
  public Boolean hasPodSpec() {
    return this.podSpec != null;
  }
  public String getPrevClusterID() {
    return this.prevClusterID;
  }
  public A withPrevClusterID(String prevClusterID) {
    this.prevClusterID=prevClusterID; return (A) this;
  }
  public Boolean hasPrevClusterID() {
    return this.prevClusterID != null;
  }
  public String getPrevInfraID() {
    return this.prevInfraID;
  }
  public A withPrevInfraID(String prevInfraID) {
    this.prevInfraID=prevInfraID; return (A) this;
  }
  public Boolean hasPrevInfraID() {
    return this.prevInfraID != null;
  }
  public String getStage() {
    return this.stage;
  }
  public A withStage(String stage) {
    this.stage=stage; return (A) this;
  }
  public Boolean hasStage() {
    return this.stage != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ClusterProvisionSpecFluentImpl that = (ClusterProvisionSpecFluentImpl) o;
    if (adminKubeconfigSecretRef != null ? !adminKubeconfigSecretRef.equals(that.adminKubeconfigSecretRef) :that.adminKubeconfigSecretRef != null) return false;
    if (adminPasswordSecretRef != null ? !adminPasswordSecretRef.equals(that.adminPasswordSecretRef) :that.adminPasswordSecretRef != null) return false;
    if (attempt != null ? !attempt.equals(that.attempt) :that.attempt != null) return false;
    if (clusterDeploymentRef != null ? !clusterDeploymentRef.equals(that.clusterDeploymentRef) :that.clusterDeploymentRef != null) return false;
    if (clusterID != null ? !clusterID.equals(that.clusterID) :that.clusterID != null) return false;
    if (infraID != null ? !infraID.equals(that.infraID) :that.infraID != null) return false;
    if (installLog != null ? !installLog.equals(that.installLog) :that.installLog != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (podSpec != null ? !podSpec.equals(that.podSpec) :that.podSpec != null) return false;
    if (prevClusterID != null ? !prevClusterID.equals(that.prevClusterID) :that.prevClusterID != null) return false;
    if (prevInfraID != null ? !prevInfraID.equals(that.prevInfraID) :that.prevInfraID != null) return false;
    if (stage != null ? !stage.equals(that.stage) :that.stage != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(adminKubeconfigSecretRef,  adminPasswordSecretRef,  attempt,  clusterDeploymentRef,  clusterID,  infraID,  installLog,  metadata,  podSpec,  prevClusterID,  prevInfraID,  stage,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (adminKubeconfigSecretRef != null) { sb.append("adminKubeconfigSecretRef:"); sb.append(adminKubeconfigSecretRef + ","); }
    if (adminPasswordSecretRef != null) { sb.append("adminPasswordSecretRef:"); sb.append(adminPasswordSecretRef + ","); }
    if (attempt != null) { sb.append("attempt:"); sb.append(attempt + ","); }
    if (clusterDeploymentRef != null) { sb.append("clusterDeploymentRef:"); sb.append(clusterDeploymentRef + ","); }
    if (clusterID != null) { sb.append("clusterID:"); sb.append(clusterID + ","); }
    if (infraID != null) { sb.append("infraID:"); sb.append(infraID + ","); }
    if (installLog != null) { sb.append("installLog:"); sb.append(installLog + ","); }
    if (metadata != null && !metadata.isEmpty()) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (podSpec != null) { sb.append("podSpec:"); sb.append(podSpec + ","); }
    if (prevClusterID != null) { sb.append("prevClusterID:"); sb.append(prevClusterID + ","); }
    if (prevInfraID != null) { sb.append("prevInfraID:"); sb.append(prevInfraID + ","); }
    if (stage != null) { sb.append("stage:"); sb.append(stage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AdminKubeconfigSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterProvisionSpecFluent.AdminKubeconfigSecretRefNested<N>> implements ClusterProvisionSpecFluent.AdminKubeconfigSecretRefNested<N>,Nested<N>{
    AdminKubeconfigSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    AdminKubeconfigSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterProvisionSpecFluentImpl.this.withAdminKubeconfigSecretRef(builder.build());
    }
    public N endAdminKubeconfigSecretRef() {
      return and();
    }
    
  }
  class AdminPasswordSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterProvisionSpecFluent.AdminPasswordSecretRefNested<N>> implements ClusterProvisionSpecFluent.AdminPasswordSecretRefNested<N>,Nested<N>{
    AdminPasswordSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    AdminPasswordSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterProvisionSpecFluentImpl.this.withAdminPasswordSecretRef(builder.build());
    }
    public N endAdminPasswordSecretRef() {
      return and();
    }
    
  }
  class ClusterDeploymentRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<ClusterProvisionSpecFluent.ClusterDeploymentRefNested<N>> implements ClusterProvisionSpecFluent.ClusterDeploymentRefNested<N>,Nested<N>{
    ClusterDeploymentRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    ClusterDeploymentRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ClusterProvisionSpecFluentImpl.this.withClusterDeploymentRef(builder.build());
    }
    public N endClusterDeploymentRef() {
      return and();
    }
    
  }
  
}