package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterDeprovisionStatusBuilder extends ClusterDeprovisionStatusFluentImpl<ClusterDeprovisionStatusBuilder> implements VisitableBuilder<ClusterDeprovisionStatus,ClusterDeprovisionStatusBuilder>{
  public ClusterDeprovisionStatusBuilder() {
    this(false);
  }
  public ClusterDeprovisionStatusBuilder(Boolean validationEnabled) {
    this(new ClusterDeprovisionStatus(), validationEnabled);
  }
  public ClusterDeprovisionStatusBuilder(ClusterDeprovisionStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterDeprovisionStatusBuilder(ClusterDeprovisionStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterDeprovisionStatus(), validationEnabled);
  }
  public ClusterDeprovisionStatusBuilder(ClusterDeprovisionStatusFluent<?> fluent,ClusterDeprovisionStatus instance) {
    this(fluent, instance, false);
  }
  public ClusterDeprovisionStatusBuilder(ClusterDeprovisionStatusFluent<?> fluent,ClusterDeprovisionStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCompleted(instance.getCompleted()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterDeprovisionStatusBuilder(ClusterDeprovisionStatus instance) {
    this(instance,false);
  }
  public ClusterDeprovisionStatusBuilder(ClusterDeprovisionStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCompleted(instance.getCompleted()); 
    this.withConditions(instance.getConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterDeprovisionStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterDeprovisionStatus build() {
    ClusterDeprovisionStatus buildable = new ClusterDeprovisionStatus(fluent.getCompleted(),fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}