package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CheckpointSpecBuilder extends CheckpointSpecFluentImpl<CheckpointSpecBuilder> implements VisitableBuilder<CheckpointSpec,CheckpointSpecBuilder>{
  public CheckpointSpecBuilder() {
    this(false);
  }
  public CheckpointSpecBuilder(Boolean validationEnabled) {
    this(new CheckpointSpec(), validationEnabled);
  }
  public CheckpointSpecBuilder(CheckpointSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CheckpointSpecBuilder(CheckpointSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CheckpointSpec(), validationEnabled);
  }
  public CheckpointSpecBuilder(CheckpointSpecFluent<?> fluent,CheckpointSpec instance) {
    this(fluent, instance, false);
  }
  public CheckpointSpecBuilder(CheckpointSpecFluent<?> fluent,CheckpointSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastBackupChecksum(instance.getLastBackupChecksum()); 
    fluent.withLastBackupRef(instance.getLastBackupRef()); 
    fluent.withLastBackupTime(instance.getLastBackupTime()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CheckpointSpecBuilder(CheckpointSpec instance) {
    this(instance,false);
  }
  public CheckpointSpecBuilder(CheckpointSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastBackupChecksum(instance.getLastBackupChecksum()); 
    this.withLastBackupRef(instance.getLastBackupRef()); 
    this.withLastBackupTime(instance.getLastBackupTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CheckpointSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CheckpointSpec build() {
    CheckpointSpec buildable = new CheckpointSpec(fluent.getLastBackupChecksum(),fluent.getLastBackupRef(),fluent.getLastBackupTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}