package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRole;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleBuilder;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.openshift.api.model.hive.aws.v1.AssumeRoleFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AWSDNSZoneSpecFluentImpl<A extends AWSDNSZoneSpecFluent<A>> extends BaseFluent<A> implements AWSDNSZoneSpecFluent<A>{
  public AWSDNSZoneSpecFluentImpl() {
  }
  public AWSDNSZoneSpecFluentImpl(AWSDNSZoneSpec instance) {
    this.withAdditionalTags(instance.getAdditionalTags()); 
    this.withCredentialsAssumeRole(instance.getCredentialsAssumeRole()); 
    this.withCredentialsSecretRef(instance.getCredentialsSecretRef()); 
    this.withRegion(instance.getRegion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<AWSResourceTagBuilder> additionalTags = new ArrayList<AWSResourceTagBuilder>();
  private AssumeRoleBuilder credentialsAssumeRole;
  private LocalObjectReferenceBuilder credentialsSecretRef;
  private String region;
  private Map<String,Object> additionalProperties;
  public A addToAdditionalTags(Integer index,AWSResourceTag item) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<AWSResourceTagBuilder>();}
    AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("additionalTags").add(index >= 0 ? index : _visitables.get("additionalTags").size(), builder);this.additionalTags.add(index >= 0 ? index : additionalTags.size(), builder); return (A)this;
  }
  public A setToAdditionalTags(Integer index,AWSResourceTag item) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<AWSResourceTagBuilder>();}
    AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);
    if (index < 0 || index >= _visitables.get("additionalTags").size()) { _visitables.get("additionalTags").add(builder); } else { _visitables.get("additionalTags").set(index, builder);}
    if (index < 0 || index >= additionalTags.size()) { additionalTags.add(builder); } else { additionalTags.set(index, builder);}
     return (A)this;
  }
  public A addToAdditionalTags(io.fabric8.openshift.api.model.hive.v1.AWSResourceTag... items) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<AWSResourceTagBuilder>();}
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("additionalTags").add(builder);this.additionalTags.add(builder);} return (A)this;
  }
  public A addAllToAdditionalTags(Collection<AWSResourceTag> items) {
    if (this.additionalTags == null) {this.additionalTags = new ArrayList<AWSResourceTagBuilder>();}
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("additionalTags").add(builder);this.additionalTags.add(builder);} return (A)this;
  }
  public A removeFromAdditionalTags(io.fabric8.openshift.api.model.hive.v1.AWSResourceTag... items) {
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("additionalTags").remove(builder);if (this.additionalTags != null) {this.additionalTags.remove(builder);}} return (A)this;
  }
  public A removeAllFromAdditionalTags(Collection<AWSResourceTag> items) {
    for (AWSResourceTag item : items) {AWSResourceTagBuilder builder = new AWSResourceTagBuilder(item);_visitables.get("additionalTags").remove(builder);if (this.additionalTags != null) {this.additionalTags.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAdditionalTags(Predicate<AWSResourceTagBuilder> predicate) {
    if (additionalTags == null) return (A) this;
    final Iterator<AWSResourceTagBuilder> each = additionalTags.iterator();
    final List visitables = _visitables.get("additionalTags");
    while (each.hasNext()) {
      AWSResourceTagBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAdditionalTags instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AWSResourceTag> getAdditionalTags() {
    return additionalTags != null ? build(additionalTags) : null;
  }
  public List<AWSResourceTag> buildAdditionalTags() {
    return additionalTags != null ? build(additionalTags) : null;
  }
  public AWSResourceTag buildAdditionalTag(Integer index) {
    return this.additionalTags.get(index).build();
  }
  public AWSResourceTag buildFirstAdditionalTag() {
    return this.additionalTags.get(0).build();
  }
  public AWSResourceTag buildLastAdditionalTag() {
    return this.additionalTags.get(additionalTags.size() - 1).build();
  }
  public AWSResourceTag buildMatchingAdditionalTag(Predicate<AWSResourceTagBuilder> predicate) {
    for (AWSResourceTagBuilder item: additionalTags) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAdditionalTag(Predicate<AWSResourceTagBuilder> predicate) {
    for (AWSResourceTagBuilder item: additionalTags) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdditionalTags(List<AWSResourceTag> additionalTags) {
    if (this.additionalTags != null) { _visitables.get("additionalTags").removeAll(this.additionalTags);}
    if (additionalTags != null) {this.additionalTags = new ArrayList(); for (AWSResourceTag item : additionalTags){this.addToAdditionalTags(item);}} else { this.additionalTags = null;} return (A) this;
  }
  public A withAdditionalTags(io.fabric8.openshift.api.model.hive.v1.AWSResourceTag... additionalTags) {
    if (this.additionalTags != null) {this.additionalTags.clear();}
    if (additionalTags != null) {for (AWSResourceTag item :additionalTags){ this.addToAdditionalTags(item);}} return (A) this;
  }
  public Boolean hasAdditionalTags() {
    return additionalTags != null && !additionalTags.isEmpty();
  }
  public A addNewAdditionalTag(String key,String value) {
    return (A)addToAdditionalTags(new AWSResourceTag(key, value));
  }
  public AWSDNSZoneSpecFluent.AdditionalTagsNested<A> addNewAdditionalTag() {
    return new AWSDNSZoneSpecFluentImpl.AdditionalTagsNestedImpl();
  }
  public AWSDNSZoneSpecFluent.AdditionalTagsNested<A> addNewAdditionalTagLike(AWSResourceTag item) {
    return new AWSDNSZoneSpecFluentImpl.AdditionalTagsNestedImpl(-1, item);
  }
  public AWSDNSZoneSpecFluent.AdditionalTagsNested<A> setNewAdditionalTagLike(Integer index,AWSResourceTag item) {
    return new AWSDNSZoneSpecFluentImpl.AdditionalTagsNestedImpl(index, item);
  }
  public AWSDNSZoneSpecFluent.AdditionalTagsNested<A> editAdditionalTag(Integer index) {
    if (additionalTags.size() <= index) throw new RuntimeException("Can't edit additionalTags. Index exceeds size.");
    return setNewAdditionalTagLike(index, buildAdditionalTag(index));
  }
  public AWSDNSZoneSpecFluent.AdditionalTagsNested<A> editFirstAdditionalTag() {
    if (additionalTags.size() == 0) throw new RuntimeException("Can't edit first additionalTags. The list is empty.");
    return setNewAdditionalTagLike(0, buildAdditionalTag(0));
  }
  public AWSDNSZoneSpecFluent.AdditionalTagsNested<A> editLastAdditionalTag() {
    int index = additionalTags.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalTags. The list is empty.");
    return setNewAdditionalTagLike(index, buildAdditionalTag(index));
  }
  public AWSDNSZoneSpecFluent.AdditionalTagsNested<A> editMatchingAdditionalTag(Predicate<AWSResourceTagBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalTags.size();i++) { 
    if (predicate.test(additionalTags.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalTags. No match found.");
    return setNewAdditionalTagLike(index, buildAdditionalTag(index));
  }
  
  /**
   * This method has been deprecated, please use method buildCredentialsAssumeRole instead.
   * @return The buildable object.
   */
  @Deprecated
  public AssumeRole getCredentialsAssumeRole() {
    return this.credentialsAssumeRole!=null ?this.credentialsAssumeRole.build():null;
  }
  public AssumeRole buildCredentialsAssumeRole() {
    return this.credentialsAssumeRole!=null ?this.credentialsAssumeRole.build():null;
  }
  public A withCredentialsAssumeRole(AssumeRole credentialsAssumeRole) {
    _visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole);
    if (credentialsAssumeRole!=null){ this.credentialsAssumeRole= new AssumeRoleBuilder(credentialsAssumeRole); _visitables.get("credentialsAssumeRole").add(this.credentialsAssumeRole);} else { this.credentialsAssumeRole = null; _visitables.get("credentialsAssumeRole").remove(this.credentialsAssumeRole); } return (A) this;
  }
  public Boolean hasCredentialsAssumeRole() {
    return this.credentialsAssumeRole != null;
  }
  public A withNewCredentialsAssumeRole(String externalID,String roleARN) {
    return (A)withCredentialsAssumeRole(new AssumeRole(externalID, roleARN));
  }
  public AWSDNSZoneSpecFluent.CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRole() {
    return new AWSDNSZoneSpecFluentImpl.CredentialsAssumeRoleNestedImpl();
  }
  public AWSDNSZoneSpecFluent.CredentialsAssumeRoleNested<A> withNewCredentialsAssumeRoleLike(AssumeRole item) {
    return new AWSDNSZoneSpecFluentImpl.CredentialsAssumeRoleNestedImpl(item);
  }
  public AWSDNSZoneSpecFluent.CredentialsAssumeRoleNested<A> editCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(getCredentialsAssumeRole());
  }
  public AWSDNSZoneSpecFluent.CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRole() {
    return withNewCredentialsAssumeRoleLike(getCredentialsAssumeRole() != null ? getCredentialsAssumeRole(): new AssumeRoleBuilder().build());
  }
  public AWSDNSZoneSpecFluent.CredentialsAssumeRoleNested<A> editOrNewCredentialsAssumeRoleLike(AssumeRole item) {
    return withNewCredentialsAssumeRoleLike(getCredentialsAssumeRole() != null ? getCredentialsAssumeRole(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCredentialsSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalObjectReference getCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public LocalObjectReference buildCredentialsSecretRef() {
    return this.credentialsSecretRef!=null ?this.credentialsSecretRef.build():null;
  }
  public A withCredentialsSecretRef(LocalObjectReference credentialsSecretRef) {
    _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef);
    if (credentialsSecretRef!=null){ this.credentialsSecretRef= new LocalObjectReferenceBuilder(credentialsSecretRef); _visitables.get("credentialsSecretRef").add(this.credentialsSecretRef);} else { this.credentialsSecretRef = null; _visitables.get("credentialsSecretRef").remove(this.credentialsSecretRef); } return (A) this;
  }
  public Boolean hasCredentialsSecretRef() {
    return this.credentialsSecretRef != null;
  }
  public A withNewCredentialsSecretRef(String name) {
    return (A)withCredentialsSecretRef(new LocalObjectReference(name));
  }
  public AWSDNSZoneSpecFluent.CredentialsSecretRefNested<A> withNewCredentialsSecretRef() {
    return new AWSDNSZoneSpecFluentImpl.CredentialsSecretRefNestedImpl();
  }
  public AWSDNSZoneSpecFluent.CredentialsSecretRefNested<A> withNewCredentialsSecretRefLike(LocalObjectReference item) {
    return new AWSDNSZoneSpecFluentImpl.CredentialsSecretRefNestedImpl(item);
  }
  public AWSDNSZoneSpecFluent.CredentialsSecretRefNested<A> editCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef());
  }
  public AWSDNSZoneSpecFluent.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRef() {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): new LocalObjectReferenceBuilder().build());
  }
  public AWSDNSZoneSpecFluent.CredentialsSecretRefNested<A> editOrNewCredentialsSecretRefLike(LocalObjectReference item) {
    return withNewCredentialsSecretRefLike(getCredentialsSecretRef() != null ? getCredentialsSecretRef(): item);
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public Boolean hasRegion() {
    return this.region != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AWSDNSZoneSpecFluentImpl that = (AWSDNSZoneSpecFluentImpl) o;
    if (additionalTags != null ? !additionalTags.equals(that.additionalTags) :that.additionalTags != null) return false;
    if (credentialsAssumeRole != null ? !credentialsAssumeRole.equals(that.credentialsAssumeRole) :that.credentialsAssumeRole != null) return false;
    if (credentialsSecretRef != null ? !credentialsSecretRef.equals(that.credentialsSecretRef) :that.credentialsSecretRef != null) return false;
    if (region != null ? !region.equals(that.region) :that.region != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(additionalTags,  credentialsAssumeRole,  credentialsSecretRef,  region,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalTags != null && !additionalTags.isEmpty()) { sb.append("additionalTags:"); sb.append(additionalTags + ","); }
    if (credentialsAssumeRole != null) { sb.append("credentialsAssumeRole:"); sb.append(credentialsAssumeRole + ","); }
    if (credentialsSecretRef != null) { sb.append("credentialsSecretRef:"); sb.append(credentialsSecretRef + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AdditionalTagsNestedImpl<N> extends AWSResourceTagFluentImpl<AWSDNSZoneSpecFluent.AdditionalTagsNested<N>> implements AWSDNSZoneSpecFluent.AdditionalTagsNested<N>,Nested<N>{
    AdditionalTagsNestedImpl(Integer index,AWSResourceTag item) {
      this.index = index;
      this.builder = new AWSResourceTagBuilder(this, item);
    }
    AdditionalTagsNestedImpl() {
      this.index = -1;
      this.builder = new AWSResourceTagBuilder(this);
    }
    AWSResourceTagBuilder builder;
    Integer index;
    public N and() {
      return (N) AWSDNSZoneSpecFluentImpl.this.setToAdditionalTags(index,builder.build());
    }
    public N endAdditionalTag() {
      return and();
    }
    
  }
  class CredentialsAssumeRoleNestedImpl<N> extends AssumeRoleFluentImpl<AWSDNSZoneSpecFluent.CredentialsAssumeRoleNested<N>> implements AWSDNSZoneSpecFluent.CredentialsAssumeRoleNested<N>,Nested<N>{
    CredentialsAssumeRoleNestedImpl(AssumeRole item) {
      this.builder = new AssumeRoleBuilder(this, item);
    }
    CredentialsAssumeRoleNestedImpl() {
      this.builder = new AssumeRoleBuilder(this);
    }
    AssumeRoleBuilder builder;
    public N and() {
      return (N) AWSDNSZoneSpecFluentImpl.this.withCredentialsAssumeRole(builder.build());
    }
    public N endCredentialsAssumeRole() {
      return and();
    }
    
  }
  class CredentialsSecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<AWSDNSZoneSpecFluent.CredentialsSecretRefNested<N>> implements AWSDNSZoneSpecFluent.CredentialsSecretRefNested<N>,Nested<N>{
    CredentialsSecretRefNestedImpl(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    CredentialsSecretRefNestedImpl() {
      this.builder = new LocalObjectReferenceBuilder(this);
    }
    LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) AWSDNSZoneSpecFluentImpl.this.withCredentialsSecretRef(builder.build());
    }
    public N endCredentialsSecretRef() {
      return and();
    }
    
  }
  
}