package io.fabric8.openshift.api.model.hive.aws.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MachinePoolPlatformFluentImpl<A extends MachinePoolPlatformFluent<A>> extends BaseFluent<A> implements MachinePoolPlatformFluent<A>{
  public MachinePoolPlatformFluentImpl() {
  }
  public MachinePoolPlatformFluentImpl(MachinePoolPlatform instance) {
    this.withRootVolume(instance.getRootVolume()); 
    this.withSpotMarketOptions(instance.getSpotMarketOptions()); 
    this.withSubnets(instance.getSubnets()); 
    this.withType(instance.getType()); 
    this.withZones(instance.getZones()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private EC2RootVolumeBuilder rootVolume;
  private SpotMarketOptionsBuilder spotMarketOptions;
  private List<String> subnets = new ArrayList<String>();
  private String type;
  private List<String> zones = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildRootVolume instead.
   * @return The buildable object.
   */
  @Deprecated
  public EC2RootVolume getRootVolume() {
    return this.rootVolume!=null ?this.rootVolume.build():null;
  }
  public EC2RootVolume buildRootVolume() {
    return this.rootVolume!=null ?this.rootVolume.build():null;
  }
  public A withRootVolume(EC2RootVolume rootVolume) {
    _visitables.get("rootVolume").remove(this.rootVolume);
    if (rootVolume!=null){ this.rootVolume= new EC2RootVolumeBuilder(rootVolume); _visitables.get("rootVolume").add(this.rootVolume);} else { this.rootVolume = null; _visitables.get("rootVolume").remove(this.rootVolume); } return (A) this;
  }
  public Boolean hasRootVolume() {
    return this.rootVolume != null;
  }
  public A withNewRootVolume(Integer iops,String kmsKeyARN,Integer size,String type) {
    return (A)withRootVolume(new EC2RootVolume(iops, kmsKeyARN, size, type));
  }
  public MachinePoolPlatformFluent.RootVolumeNested<A> withNewRootVolume() {
    return new MachinePoolPlatformFluentImpl.RootVolumeNestedImpl();
  }
  public MachinePoolPlatformFluent.RootVolumeNested<A> withNewRootVolumeLike(EC2RootVolume item) {
    return new MachinePoolPlatformFluentImpl.RootVolumeNestedImpl(item);
  }
  public MachinePoolPlatformFluent.RootVolumeNested<A> editRootVolume() {
    return withNewRootVolumeLike(getRootVolume());
  }
  public MachinePoolPlatformFluent.RootVolumeNested<A> editOrNewRootVolume() {
    return withNewRootVolumeLike(getRootVolume() != null ? getRootVolume(): new EC2RootVolumeBuilder().build());
  }
  public MachinePoolPlatformFluent.RootVolumeNested<A> editOrNewRootVolumeLike(EC2RootVolume item) {
    return withNewRootVolumeLike(getRootVolume() != null ? getRootVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpotMarketOptions instead.
   * @return The buildable object.
   */
  @Deprecated
  public SpotMarketOptions getSpotMarketOptions() {
    return this.spotMarketOptions!=null ?this.spotMarketOptions.build():null;
  }
  public SpotMarketOptions buildSpotMarketOptions() {
    return this.spotMarketOptions!=null ?this.spotMarketOptions.build():null;
  }
  public A withSpotMarketOptions(SpotMarketOptions spotMarketOptions) {
    _visitables.get("spotMarketOptions").remove(this.spotMarketOptions);
    if (spotMarketOptions!=null){ this.spotMarketOptions= new SpotMarketOptionsBuilder(spotMarketOptions); _visitables.get("spotMarketOptions").add(this.spotMarketOptions);} else { this.spotMarketOptions = null; _visitables.get("spotMarketOptions").remove(this.spotMarketOptions); } return (A) this;
  }
  public Boolean hasSpotMarketOptions() {
    return this.spotMarketOptions != null;
  }
  public A withNewSpotMarketOptions(String maxPrice) {
    return (A)withSpotMarketOptions(new SpotMarketOptions(maxPrice));
  }
  public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> withNewSpotMarketOptions() {
    return new MachinePoolPlatformFluentImpl.SpotMarketOptionsNestedImpl();
  }
  public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> withNewSpotMarketOptionsLike(SpotMarketOptions item) {
    return new MachinePoolPlatformFluentImpl.SpotMarketOptionsNestedImpl(item);
  }
  public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> editSpotMarketOptions() {
    return withNewSpotMarketOptionsLike(getSpotMarketOptions());
  }
  public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> editOrNewSpotMarketOptions() {
    return withNewSpotMarketOptionsLike(getSpotMarketOptions() != null ? getSpotMarketOptions(): new SpotMarketOptionsBuilder().build());
  }
  public MachinePoolPlatformFluent.SpotMarketOptionsNested<A> editOrNewSpotMarketOptionsLike(SpotMarketOptions item) {
    return withNewSpotMarketOptionsLike(getSpotMarketOptions() != null ? getSpotMarketOptions(): item);
  }
  public A addToSubnets(Integer index,String item) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    this.subnets.add(index, item);
    return (A)this;
  }
  public A setToSubnets(Integer index,String item) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    this.subnets.set(index, item); return (A)this;
  }
  public A addToSubnets(java.lang.String... items) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    for (String item : items) {this.subnets.add(item);} return (A)this;
  }
  public A addAllToSubnets(Collection<String> items) {
    if (this.subnets == null) {this.subnets = new ArrayList<String>();}
    for (String item : items) {this.subnets.add(item);} return (A)this;
  }
  public A removeFromSubnets(java.lang.String... items) {
    for (String item : items) {if (this.subnets!= null){ this.subnets.remove(item);}} return (A)this;
  }
  public A removeAllFromSubnets(Collection<String> items) {
    for (String item : items) {if (this.subnets!= null){ this.subnets.remove(item);}} return (A)this;
  }
  public List<String> getSubnets() {
    return this.subnets;
  }
  public String getSubnet(Integer index) {
    return this.subnets.get(index);
  }
  public String getFirstSubnet() {
    return this.subnets.get(0);
  }
  public String getLastSubnet() {
    return this.subnets.get(subnets.size() - 1);
  }
  public String getMatchingSubnet(Predicate<String> predicate) {
    for (String item: subnets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSubnet(Predicate<String> predicate) {
    for (String item: subnets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubnets(List<String> subnets) {
    if (subnets != null) {this.subnets = new ArrayList(); for (String item : subnets){this.addToSubnets(item);}} else { this.subnets = null;} return (A) this;
  }
  public A withSubnets(java.lang.String... subnets) {
    if (this.subnets != null) {this.subnets.clear();}
    if (subnets != null) {for (String item :subnets){ this.addToSubnets(item);}} return (A) this;
  }
  public Boolean hasSubnets() {
    return subnets != null && !subnets.isEmpty();
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToZones(Integer index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.add(index, item);
    return (A)this;
  }
  public A setToZones(Integer index,String item) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    this.zones.set(index, item); return (A)this;
  }
  public A addToZones(java.lang.String... items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A addAllToZones(Collection<String> items) {
    if (this.zones == null) {this.zones = new ArrayList<String>();}
    for (String item : items) {this.zones.add(item);} return (A)this;
  }
  public A removeFromZones(java.lang.String... items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public A removeAllFromZones(Collection<String> items) {
    for (String item : items) {if (this.zones!= null){ this.zones.remove(item);}} return (A)this;
  }
  public List<String> getZones() {
    return this.zones;
  }
  public String getZone(Integer index) {
    return this.zones.get(index);
  }
  public String getFirstZone() {
    return this.zones.get(0);
  }
  public String getLastZone() {
    return this.zones.get(zones.size() - 1);
  }
  public String getMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingZone(Predicate<String> predicate) {
    for (String item: zones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withZones(List<String> zones) {
    if (zones != null) {this.zones = new ArrayList(); for (String item : zones){this.addToZones(item);}} else { this.zones = null;} return (A) this;
  }
  public A withZones(java.lang.String... zones) {
    if (this.zones != null) {this.zones.clear();}
    if (zones != null) {for (String item :zones){ this.addToZones(item);}} return (A) this;
  }
  public Boolean hasZones() {
    return zones != null && !zones.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MachinePoolPlatformFluentImpl that = (MachinePoolPlatformFluentImpl) o;
    if (rootVolume != null ? !rootVolume.equals(that.rootVolume) :that.rootVolume != null) return false;
    if (spotMarketOptions != null ? !spotMarketOptions.equals(that.spotMarketOptions) :that.spotMarketOptions != null) return false;
    if (subnets != null ? !subnets.equals(that.subnets) :that.subnets != null) return false;
    if (type != null ? !type.equals(that.type) :that.type != null) return false;
    if (zones != null ? !zones.equals(that.zones) :that.zones != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(rootVolume,  spotMarketOptions,  subnets,  type,  zones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (rootVolume != null) { sb.append("rootVolume:"); sb.append(rootVolume + ","); }
    if (spotMarketOptions != null) { sb.append("spotMarketOptions:"); sb.append(spotMarketOptions + ","); }
    if (subnets != null && !subnets.isEmpty()) { sb.append("subnets:"); sb.append(subnets + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (zones != null && !zones.isEmpty()) { sb.append("zones:"); sb.append(zones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class RootVolumeNestedImpl<N> extends EC2RootVolumeFluentImpl<MachinePoolPlatformFluent.RootVolumeNested<N>> implements MachinePoolPlatformFluent.RootVolumeNested<N>,Nested<N>{
    RootVolumeNestedImpl(EC2RootVolume item) {
      this.builder = new EC2RootVolumeBuilder(this, item);
    }
    RootVolumeNestedImpl() {
      this.builder = new EC2RootVolumeBuilder(this);
    }
    EC2RootVolumeBuilder builder;
    public N and() {
      return (N) MachinePoolPlatformFluentImpl.this.withRootVolume(builder.build());
    }
    public N endRootVolume() {
      return and();
    }
    
  }
  class SpotMarketOptionsNestedImpl<N> extends SpotMarketOptionsFluentImpl<MachinePoolPlatformFluent.SpotMarketOptionsNested<N>> implements MachinePoolPlatformFluent.SpotMarketOptionsNested<N>,Nested<N>{
    SpotMarketOptionsNestedImpl(SpotMarketOptions item) {
      this.builder = new SpotMarketOptionsBuilder(this, item);
    }
    SpotMarketOptionsNestedImpl() {
      this.builder = new SpotMarketOptionsBuilder(this);
    }
    SpotMarketOptionsBuilder builder;
    public N and() {
      return (N) MachinePoolPlatformFluentImpl.this.withSpotMarketOptions(builder.build());
    }
    public N endSpotMarketOptions() {
      return and();
    }
    
  }
  
}