package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.openshift.api.model.config.v1.IdentityProvider;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class SelectorSyncIdentityProviderSpecFluentImpl<A extends SelectorSyncIdentityProviderSpecFluent<A>> extends BaseFluent<A> implements SelectorSyncIdentityProviderSpecFluent<A>{
  public SelectorSyncIdentityProviderSpecFluentImpl() {
  }
  public SelectorSyncIdentityProviderSpecFluentImpl(SelectorSyncIdentityProviderSpec instance) {
    this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector()); 
    this.withIdentityProviders(instance.getIdentityProviders()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private LabelSelectorBuilder clusterDeploymentSelector;
  private List<IdentityProvider> identityProviders = new ArrayList<IdentityProvider>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildClusterDeploymentSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getClusterDeploymentSelector() {
    return this.clusterDeploymentSelector!=null ?this.clusterDeploymentSelector.build():null;
  }
  public LabelSelector buildClusterDeploymentSelector() {
    return this.clusterDeploymentSelector!=null ?this.clusterDeploymentSelector.build():null;
  }
  public A withClusterDeploymentSelector(LabelSelector clusterDeploymentSelector) {
    _visitables.get("clusterDeploymentSelector").remove(this.clusterDeploymentSelector);
    if (clusterDeploymentSelector!=null){ this.clusterDeploymentSelector= new LabelSelectorBuilder(clusterDeploymentSelector); _visitables.get("clusterDeploymentSelector").add(this.clusterDeploymentSelector);} else { this.clusterDeploymentSelector = null; _visitables.get("clusterDeploymentSelector").remove(this.clusterDeploymentSelector); } return (A) this;
  }
  public Boolean hasClusterDeploymentSelector() {
    return this.clusterDeploymentSelector != null;
  }
  public SelectorSyncIdentityProviderSpecFluent.ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelector() {
    return new SelectorSyncIdentityProviderSpecFluentImpl.ClusterDeploymentSelectorNestedImpl();
  }
  public SelectorSyncIdentityProviderSpecFluent.ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelectorLike(LabelSelector item) {
    return new SelectorSyncIdentityProviderSpecFluentImpl.ClusterDeploymentSelectorNestedImpl(item);
  }
  public SelectorSyncIdentityProviderSpecFluent.ClusterDeploymentSelectorNested<A> editClusterDeploymentSelector() {
    return withNewClusterDeploymentSelectorLike(getClusterDeploymentSelector());
  }
  public SelectorSyncIdentityProviderSpecFluent.ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelector() {
    return withNewClusterDeploymentSelectorLike(getClusterDeploymentSelector() != null ? getClusterDeploymentSelector(): new LabelSelectorBuilder().build());
  }
  public SelectorSyncIdentityProviderSpecFluent.ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelectorLike(LabelSelector item) {
    return withNewClusterDeploymentSelectorLike(getClusterDeploymentSelector() != null ? getClusterDeploymentSelector(): item);
  }
  public A addToIdentityProviders(Integer index,IdentityProvider item) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProvider>();}
    this.identityProviders.add(index, item);
    return (A)this;
  }
  public A setToIdentityProviders(Integer index,IdentityProvider item) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProvider>();}
    this.identityProviders.set(index, item); return (A)this;
  }
  public A addToIdentityProviders(io.fabric8.openshift.api.model.config.v1.IdentityProvider... items) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProvider>();}
    for (IdentityProvider item : items) {this.identityProviders.add(item);} return (A)this;
  }
  public A addAllToIdentityProviders(Collection<IdentityProvider> items) {
    if (this.identityProviders == null) {this.identityProviders = new ArrayList<IdentityProvider>();}
    for (IdentityProvider item : items) {this.identityProviders.add(item);} return (A)this;
  }
  public A removeFromIdentityProviders(io.fabric8.openshift.api.model.config.v1.IdentityProvider... items) {
    for (IdentityProvider item : items) {if (this.identityProviders!= null){ this.identityProviders.remove(item);}} return (A)this;
  }
  public A removeAllFromIdentityProviders(Collection<IdentityProvider> items) {
    for (IdentityProvider item : items) {if (this.identityProviders!= null){ this.identityProviders.remove(item);}} return (A)this;
  }
  public List<IdentityProvider> getIdentityProviders() {
    return this.identityProviders;
  }
  public IdentityProvider getIdentityProvider(Integer index) {
    return this.identityProviders.get(index);
  }
  public IdentityProvider getFirstIdentityProvider() {
    return this.identityProviders.get(0);
  }
  public IdentityProvider getLastIdentityProvider() {
    return this.identityProviders.get(identityProviders.size() - 1);
  }
  public IdentityProvider getMatchingIdentityProvider(Predicate<IdentityProvider> predicate) {
    for (IdentityProvider item: identityProviders) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingIdentityProvider(Predicate<IdentityProvider> predicate) {
    for (IdentityProvider item: identityProviders) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIdentityProviders(List<IdentityProvider> identityProviders) {
    if (identityProviders != null) {this.identityProviders = new ArrayList(); for (IdentityProvider item : identityProviders){this.addToIdentityProviders(item);}} else { this.identityProviders = null;} return (A) this;
  }
  public A withIdentityProviders(io.fabric8.openshift.api.model.config.v1.IdentityProvider... identityProviders) {
    if (this.identityProviders != null) {this.identityProviders.clear();}
    if (identityProviders != null) {for (IdentityProvider item :identityProviders){ this.addToIdentityProviders(item);}} return (A) this;
  }
  public Boolean hasIdentityProviders() {
    return identityProviders != null && !identityProviders.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    SelectorSyncIdentityProviderSpecFluentImpl that = (SelectorSyncIdentityProviderSpecFluentImpl) o;
    if (clusterDeploymentSelector != null ? !clusterDeploymentSelector.equals(that.clusterDeploymentSelector) :that.clusterDeploymentSelector != null) return false;
    if (identityProviders != null ? !identityProviders.equals(that.identityProviders) :that.identityProviders != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterDeploymentSelector,  identityProviders,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterDeploymentSelector != null) { sb.append("clusterDeploymentSelector:"); sb.append(clusterDeploymentSelector + ","); }
    if (identityProviders != null && !identityProviders.isEmpty()) { sb.append("identityProviders:"); sb.append(identityProviders + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterDeploymentSelectorNestedImpl<N> extends LabelSelectorFluentImpl<SelectorSyncIdentityProviderSpecFluent.ClusterDeploymentSelectorNested<N>> implements SelectorSyncIdentityProviderSpecFluent.ClusterDeploymentSelectorNested<N>,Nested<N>{
    ClusterDeploymentSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ClusterDeploymentSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) SelectorSyncIdentityProviderSpecFluentImpl.this.withClusterDeploymentSelector(builder.build());
    }
    public N endClusterDeploymentSelector() {
      return and();
    }
    
  }
  
}