package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterRelocateSpecBuilder extends ClusterRelocateSpecFluentImpl<ClusterRelocateSpecBuilder> implements VisitableBuilder<ClusterRelocateSpec,ClusterRelocateSpecBuilder>{
  public ClusterRelocateSpecBuilder() {
    this(false);
  }
  public ClusterRelocateSpecBuilder(Boolean validationEnabled) {
    this(new ClusterRelocateSpec(), validationEnabled);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterRelocateSpec(), validationEnabled);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent,ClusterRelocateSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpecFluent<?> fluent,ClusterRelocateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClusterDeploymentSelector(instance.getClusterDeploymentSelector()); 
    fluent.withKubeconfigSecretRef(instance.getKubeconfigSecretRef()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpec instance) {
    this(instance,false);
  }
  public ClusterRelocateSpecBuilder(ClusterRelocateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector()); 
    this.withKubeconfigSecretRef(instance.getKubeconfigSecretRef()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterRelocateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterRelocateSpec build() {
    ClusterRelocateSpec buildable = new ClusterRelocateSpec(fluent.getClusterDeploymentSelector(),fluent.getKubeconfigSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}