package io.fabric8.openshift.api.model.hive.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CheckpointSpecFluentImpl<A extends CheckpointSpecFluent<A>> extends BaseFluent<A> implements CheckpointSpecFluent<A>{
  public CheckpointSpecFluentImpl() {
  }
  public CheckpointSpecFluentImpl(CheckpointSpec instance) {
    this.withLastBackupChecksum(instance.getLastBackupChecksum()); 
    this.withLastBackupRef(instance.getLastBackupRef()); 
    this.withLastBackupTime(instance.getLastBackupTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String lastBackupChecksum;
  private BackupReferenceBuilder lastBackupRef;
  private String lastBackupTime;
  private Map<String,Object> additionalProperties;
  public String getLastBackupChecksum() {
    return this.lastBackupChecksum;
  }
  public A withLastBackupChecksum(String lastBackupChecksum) {
    this.lastBackupChecksum=lastBackupChecksum; return (A) this;
  }
  public Boolean hasLastBackupChecksum() {
    return this.lastBackupChecksum != null;
  }
  
  /**
   * This method has been deprecated, please use method buildLastBackupRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public BackupReference getLastBackupRef() {
    return this.lastBackupRef!=null ?this.lastBackupRef.build():null;
  }
  public BackupReference buildLastBackupRef() {
    return this.lastBackupRef!=null ?this.lastBackupRef.build():null;
  }
  public A withLastBackupRef(BackupReference lastBackupRef) {
    _visitables.get("lastBackupRef").remove(this.lastBackupRef);
    if (lastBackupRef!=null){ this.lastBackupRef= new BackupReferenceBuilder(lastBackupRef); _visitables.get("lastBackupRef").add(this.lastBackupRef);} else { this.lastBackupRef = null; _visitables.get("lastBackupRef").remove(this.lastBackupRef); } return (A) this;
  }
  public Boolean hasLastBackupRef() {
    return this.lastBackupRef != null;
  }
  public A withNewLastBackupRef(String name,String namespace) {
    return (A)withLastBackupRef(new BackupReference(name, namespace));
  }
  public CheckpointSpecFluent.LastBackupRefNested<A> withNewLastBackupRef() {
    return new CheckpointSpecFluentImpl.LastBackupRefNestedImpl();
  }
  public CheckpointSpecFluent.LastBackupRefNested<A> withNewLastBackupRefLike(BackupReference item) {
    return new CheckpointSpecFluentImpl.LastBackupRefNestedImpl(item);
  }
  public CheckpointSpecFluent.LastBackupRefNested<A> editLastBackupRef() {
    return withNewLastBackupRefLike(getLastBackupRef());
  }
  public CheckpointSpecFluent.LastBackupRefNested<A> editOrNewLastBackupRef() {
    return withNewLastBackupRefLike(getLastBackupRef() != null ? getLastBackupRef(): new BackupReferenceBuilder().build());
  }
  public CheckpointSpecFluent.LastBackupRefNested<A> editOrNewLastBackupRefLike(BackupReference item) {
    return withNewLastBackupRefLike(getLastBackupRef() != null ? getLastBackupRef(): item);
  }
  public String getLastBackupTime() {
    return this.lastBackupTime;
  }
  public A withLastBackupTime(String lastBackupTime) {
    this.lastBackupTime=lastBackupTime; return (A) this;
  }
  public Boolean hasLastBackupTime() {
    return this.lastBackupTime != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CheckpointSpecFluentImpl that = (CheckpointSpecFluentImpl) o;
    if (lastBackupChecksum != null ? !lastBackupChecksum.equals(that.lastBackupChecksum) :that.lastBackupChecksum != null) return false;
    if (lastBackupRef != null ? !lastBackupRef.equals(that.lastBackupRef) :that.lastBackupRef != null) return false;
    if (lastBackupTime != null ? !lastBackupTime.equals(that.lastBackupTime) :that.lastBackupTime != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(lastBackupChecksum,  lastBackupRef,  lastBackupTime,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (lastBackupChecksum != null) { sb.append("lastBackupChecksum:"); sb.append(lastBackupChecksum + ","); }
    if (lastBackupRef != null) { sb.append("lastBackupRef:"); sb.append(lastBackupRef + ","); }
    if (lastBackupTime != null) { sb.append("lastBackupTime:"); sb.append(lastBackupTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LastBackupRefNestedImpl<N> extends BackupReferenceFluentImpl<CheckpointSpecFluent.LastBackupRefNested<N>> implements CheckpointSpecFluent.LastBackupRefNested<N>,Nested<N>{
    LastBackupRefNestedImpl(BackupReference item) {
      this.builder = new BackupReferenceBuilder(this, item);
    }
    LastBackupRefNestedImpl() {
      this.builder = new BackupReferenceBuilder(this);
    }
    BackupReferenceBuilder builder;
    public N and() {
      return (N) CheckpointSpecFluentImpl.this.withLastBackupRef(builder.build());
    }
    public N endLastBackupRef() {
      return and();
    }
    
  }
  
}