/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpec;
import io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterClaimSpecFluentImpl;
import java.util.Objects;

public class ClusterClaimSpecBuilder
extends ClusterClaimSpecFluentImpl<ClusterClaimSpecBuilder>
implements VisitableBuilder<ClusterClaimSpec, ClusterClaimSpecBuilder> {
    ClusterClaimSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterClaimSpecBuilder() {
        this(false);
    }

    public ClusterClaimSpecBuilder(Boolean validationEnabled) {
        this(new ClusterClaimSpec(), validationEnabled);
    }

    public ClusterClaimSpecBuilder(ClusterClaimSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterClaimSpecBuilder(ClusterClaimSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterClaimSpec(), validationEnabled);
    }

    public ClusterClaimSpecBuilder(ClusterClaimSpecFluent<?> fluent, ClusterClaimSpec instance) {
        this(fluent, instance, false);
    }

    public ClusterClaimSpecBuilder(ClusterClaimSpecFluent<?> fluent, ClusterClaimSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterPoolName(instance.getClusterPoolName());
        fluent.withLifetime(instance.getLifetime());
        fluent.withNamespace(instance.getNamespace());
        fluent.withSubjects(instance.getSubjects());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterClaimSpecBuilder(ClusterClaimSpec instance) {
        this(instance, (Boolean)false);
    }

    public ClusterClaimSpecBuilder(ClusterClaimSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterPoolName(instance.getClusterPoolName());
        this.withLifetime(instance.getLifetime());
        this.withNamespace(instance.getNamespace());
        this.withSubjects(instance.getSubjects());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterClaimSpec build() {
        ClusterClaimSpec buildable = new ClusterClaimSpec(this.fluent.getClusterPoolName(), this.fluent.getLifetime(), this.fluent.getNamespace(), this.fluent.getSubjects());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterClaimSpecBuilder that = (ClusterClaimSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

