/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.v1.HiveConfig;
import io.fabric8.openshift.api.model.hive.v1.HiveConfigFluent;
import io.fabric8.openshift.api.model.hive.v1.HiveConfigFluentImpl;
import java.util.Objects;

public class HiveConfigBuilder
extends HiveConfigFluentImpl<HiveConfigBuilder>
implements VisitableBuilder<HiveConfig, HiveConfigBuilder> {
    HiveConfigFluent<?> fluent;
    Boolean validationEnabled;

    public HiveConfigBuilder() {
        this(false);
    }

    public HiveConfigBuilder(Boolean validationEnabled) {
        this(new HiveConfig(), validationEnabled);
    }

    public HiveConfigBuilder(HiveConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HiveConfigBuilder(HiveConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HiveConfig(), validationEnabled);
    }

    public HiveConfigBuilder(HiveConfigFluent<?> fluent, HiveConfig instance) {
        this(fluent, instance, false);
    }

    public HiveConfigBuilder(HiveConfigFluent<?> fluent, HiveConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HiveConfigBuilder(HiveConfig instance) {
        this(instance, (Boolean)false);
    }

    public HiveConfigBuilder(HiveConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HiveConfig build() {
        HiveConfig buildable = new HiveConfig(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HiveConfigBuilder that = (HiveConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

