/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterMetadata;
import io.fabric8.openshift.api.model.hive.v1.ClusterMetadataFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterMetadataFluentImpl;
import java.util.Objects;

public class ClusterMetadataBuilder
extends ClusterMetadataFluentImpl<ClusterMetadataBuilder>
implements VisitableBuilder<ClusterMetadata, ClusterMetadataBuilder> {
    ClusterMetadataFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterMetadataBuilder() {
        this(false);
    }

    public ClusterMetadataBuilder(Boolean validationEnabled) {
        this(new ClusterMetadata(), validationEnabled);
    }

    public ClusterMetadataBuilder(ClusterMetadataFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterMetadataBuilder(ClusterMetadataFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterMetadata(), validationEnabled);
    }

    public ClusterMetadataBuilder(ClusterMetadataFluent<?> fluent, ClusterMetadata instance) {
        this(fluent, instance, false);
    }

    public ClusterMetadataBuilder(ClusterMetadataFluent<?> fluent, ClusterMetadata instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef());
        fluent.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef());
        fluent.withClusterID(instance.getClusterID());
        fluent.withInfraID(instance.getInfraID());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterMetadataBuilder(ClusterMetadata instance) {
        this(instance, (Boolean)false);
    }

    public ClusterMetadataBuilder(ClusterMetadata instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAdminKubeconfigSecretRef(instance.getAdminKubeconfigSecretRef());
        this.withAdminPasswordSecretRef(instance.getAdminPasswordSecretRef());
        this.withClusterID(instance.getClusterID());
        this.withInfraID(instance.getInfraID());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterMetadata build() {
        ClusterMetadata buildable = new ClusterMetadata(this.fluent.getAdminKubeconfigSecretRef(), this.fluent.getAdminPasswordSecretRef(), this.fluent.getClusterID(), this.fluent.getInfraID());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterMetadataBuilder that = (ClusterMetadataBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

