/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterIngress;
import io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluent;
import io.fabric8.openshift.api.model.hive.v1.ClusterIngressFluentImpl;
import java.util.Objects;

public class ClusterIngressBuilder
extends ClusterIngressFluentImpl<ClusterIngressBuilder>
implements VisitableBuilder<ClusterIngress, ClusterIngressBuilder> {
    ClusterIngressFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterIngressBuilder() {
        this(false);
    }

    public ClusterIngressBuilder(Boolean validationEnabled) {
        this(new ClusterIngress(), validationEnabled);
    }

    public ClusterIngressBuilder(ClusterIngressFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClusterIngressBuilder(ClusterIngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterIngress(), validationEnabled);
    }

    public ClusterIngressBuilder(ClusterIngressFluent<?> fluent, ClusterIngress instance) {
        this(fluent, instance, false);
    }

    public ClusterIngressBuilder(ClusterIngressFluent<?> fluent, ClusterIngress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDomain(instance.getDomain());
        fluent.withName(instance.getName());
        fluent.withNamespaceSelector(instance.getNamespaceSelector());
        fluent.withRouteSelector(instance.getRouteSelector());
        fluent.withServingCertificate(instance.getServingCertificate());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterIngressBuilder(ClusterIngress instance) {
        this(instance, (Boolean)false);
    }

    public ClusterIngressBuilder(ClusterIngress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDomain(instance.getDomain());
        this.withName(instance.getName());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withRouteSelector(instance.getRouteSelector());
        this.withServingCertificate(instance.getServingCertificate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public ClusterIngress build() {
        ClusterIngress buildable = new ClusterIngress(this.fluent.getDomain(), this.fluent.getName(), this.fluent.getNamespaceSelector(), this.fluent.getRouteSelector(), this.fluent.getServingCertificate());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterIngressBuilder that = (ClusterIngressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

