/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfig;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigFluent;
import io.fabric8.openshift.api.model.hive.v1.AWSPrivateLinkConfigFluentImpl;
import java.util.Objects;

public class AWSPrivateLinkConfigBuilder
extends AWSPrivateLinkConfigFluentImpl<AWSPrivateLinkConfigBuilder>
implements VisitableBuilder<AWSPrivateLinkConfig, AWSPrivateLinkConfigBuilder> {
    AWSPrivateLinkConfigFluent<?> fluent;
    Boolean validationEnabled;

    public AWSPrivateLinkConfigBuilder() {
        this(false);
    }

    public AWSPrivateLinkConfigBuilder(Boolean validationEnabled) {
        this(new AWSPrivateLinkConfig(), validationEnabled);
    }

    public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AWSPrivateLinkConfig(), validationEnabled);
    }

    public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent, AWSPrivateLinkConfig instance) {
        this(fluent, instance, false);
    }

    public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfigFluent<?> fluent, AWSPrivateLinkConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAssociatedVPCs(instance.getAssociatedVPCs());
        fluent.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        fluent.withDnsRecordType(instance.getDnsRecordType());
        fluent.withEndpointVPCInventory(instance.getEndpointVPCInventory());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfig instance) {
        this(instance, (Boolean)false);
    }

    public AWSPrivateLinkConfigBuilder(AWSPrivateLinkConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAssociatedVPCs(instance.getAssociatedVPCs());
        this.withCredentialsSecretRef(instance.getCredentialsSecretRef());
        this.withDnsRecordType(instance.getDnsRecordType());
        this.withEndpointVPCInventory(instance.getEndpointVPCInventory());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public AWSPrivateLinkConfig build() {
        AWSPrivateLinkConfig buildable = new AWSPrivateLinkConfig(this.fluent.getAssociatedVPCs(), this.fluent.getCredentialsSecretRef(), this.fluent.getDnsRecordType(), this.fluent.getEndpointVPCInventory());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AWSPrivateLinkConfigBuilder that = (AWSPrivateLinkConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

